/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.utils.PathUtil;

public class JavaRuntimeDetectionUtil {
    @Nullable
    public static IdeKotlinVersion getJavaRuntimeVersion(@NotNull Library library2) {
        if (library2 == null) {
            JavaRuntimeDetectionUtil.$$$reportNull$$$0(0);
        }
        return JavaRuntimeDetectionUtil.getJavaRuntimeVersion(Arrays.asList(library2.getFiles(OrderRootType.CLASSES)));
    }

    @Nullable
    public static IdeKotlinVersion getJavaRuntimeVersion(@NotNull List<VirtualFile> classesRoots) {
        VirtualFile stdJar;
        if (classesRoots == null) {
            JavaRuntimeDetectionUtil.$$$reportNull$$$0(1);
        }
        if ((stdJar = JavaRuntimeDetectionUtil.getRuntimeJar(classesRoots)) != null) {
            return IdeKotlinVersion.fromManifest(stdJar);
        }
        return null;
    }

    @Nullable
    public static VirtualFile getRuntimeJar(@NotNull List<VirtualFile> classesRoots) {
        if (classesRoots == null) {
            JavaRuntimeDetectionUtil.$$$reportNull$$$0(2);
        }
        for (VirtualFile root : classesRoots) {
            if (!PathUtil.KOTLIN_RUNTIME_JAR_PATTERN.matcher(root.getName()).matches()) continue;
            return root;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/framework/JavaRuntimeDetectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getJavaRuntimeVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRuntimeJar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

