/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.conventionNameCalls.ConventionUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedEqualsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class UnusedEqualsInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            private final void reportIfNotUsedAsExpression(KtExpression expression2) {
                BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default((KtElement)expression2, null, 1, null);
                if (Intrinsics.areEqual((Object)context2, (Object)BindingContext.EMPTY) ^ true && !BindingContextUtilsKt.isUsedAsExpression((KtExpression)expression2, (BindingContext)context2)) {
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("unused.equals.expression", new Object[0]), new LocalQuickFix[0]);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitBinaryExpression(expression2);
                if (!Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)KtTokens.EQEQ)) return;
                PsiElement parent2 = expression2.getParent();
                PsiElement psiElement2 = parent2;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"parent");
                if (psiElement2.getParent() instanceof KtIfExpression) {
                    bl = true;
                } else {
                    if (!(parent2 instanceof KtBlockExpression)) return;
                    if (((KtBlockExpression)parent2).getParent() instanceof KtCodeFragment) {
                        List list2 = ((KtBlockExpression)parent2).getStatements();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parent.statements");
                        if (!(Intrinsics.areEqual((Object)((KtExpression)CollectionsKt.lastOrNull((List)list2)), (Object)expression2) ^ true)) return;
                    }
                    bl = true;
                }
                boolean shouldReport = bl;
                if (!shouldReport) return;
                this.reportIfNotUsedAsExpression((KtExpression)expression2);
            }

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitCallExpression(expression2);
                KtExpression ktExpression = expression2.getCalleeExpression();
                if (!(ktExpression instanceof KtSimpleNameExpression)) {
                    ktExpression = null;
                }
                KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression calleeExpression2 = ktSimpleNameExpression;
                if (Intrinsics.areEqual((Object)calleeExpression2.getReferencedNameAsName(), (Object)OperatorNameConventions.EQUALS) ^ true) {
                    return;
                }
                if (!ConventionUtilsKt.isAnyEquals((KtExpression)expression2)) {
                    return;
                }
                this.reportIfNotUsedAsExpression(KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)((KtExpression)expression2)));
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

