/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.junit;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit.UniqueIdConfigurationProducer;
import com.intellij.execution.testframework.AbstractInClassConfigurationProducer;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.extensions.KotlinTestFrameworkProvider;
import org.jetbrains.kotlin.idea.junit.JunitKotlinTestFrameworkProvider;
import org.jetbrains.kotlin.idea.junit.KotlinJUnitRunConfigurationProducer;
import org.jetbrains.kotlin.idea.run.JvmMppUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/junit/KotlinJUnitRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/intellij/execution/junit/JUnitConfiguration;", "()V", "createDelegatingContextWithLightElement", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "fromContext", "lightElement", "Lcom/intellij/psi/PsiMember;", "isAvailableInMpp", "", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isConfigurationFromContext", "configuration", "onFirstRun", "", "performRunnable", "Ljava/lang/Runnable;", "settingsMatchTemplate", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "shouldReplace", "self", "other", "kotlin.junit"})
public final class KotlinJUnitRunConfigurationProducer
extends RunConfigurationProducer<JUnitConfiguration> {
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.isProducedBy(JUnitConfigurationProducer.class) || other.isProducedBy(AbstractPatternBasedConfigurationProducer.class);
    }

    private final boolean isAvailableInMpp(ConfigurationContext context2) {
        Module module2 = context2.getModule();
        return module2 == null || !MultiplatformUtilKt.isNewMPPModule(module2) || !JvmMppUtilsKt.forceGradleRunnerInMPP();
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context2) || !this.isAvailableInMpp(context2)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"class", (Object)configuration2.getTestType()) ^ true && Intrinsics.areEqual((Object)"method", (Object)configuration2.getTestType()) ^ true) {
            return false;
        }
        Location location2 = context2.getLocation();
        if (location2 == null || (location2 = location2.getPsiElement()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"context.location?.psiElement ?: return false");
        Location element3 = location2;
        KotlinTestFrameworkProvider.JavaEntity javaEntity = JunitKotlinTestFrameworkProvider.INSTANCE.getJavaEntity((PsiElement)element3);
        if (javaEntity == null) {
            return false;
        }
        KotlinTestFrameworkProvider.JavaEntity javaEntity2 = javaEntity;
        TestObject testObject = configuration2.getTestObject();
        if (!testObject.isConfiguredByElement(configuration2, javaEntity2.getTestClass(), javaEntity2.getMethod(), null, null)) {
            return false;
        }
        String[] nodeIds = UniqueIdConfigurationProducer.getNodeIds((ConfigurationContext)context2);
        String[] stringArray = nodeIds;
        if (!(stringArray == null || stringArray.length == 0)) {
            return false;
        }
        return this.settingsMatchTemplate(configuration2, context2);
    }

    private final boolean settingsMatchTemplate(JUnitConfiguration configuration2, ConfigurationContext context2) {
        String vmParameters;
        RunConfiguration predefinedConfiguration = context2.getOriginalConfiguration((ConfigurationType)JUnitConfigurationType.getInstance());
        RunConfiguration runConfiguration = predefinedConfiguration;
        if (!(runConfiguration instanceof CommonJavaRunConfigurationParameters)) {
            runConfiguration = null;
        }
        CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters = (CommonJavaRunConfigurationParameters)runConfiguration;
        String string = vmParameters = commonJavaRunConfigurationParameters != null ? commonJavaRunConfigurationParameters.getVMParameters() : null;
        if (vmParameters != null && Intrinsics.areEqual((Object)configuration2.getVMParameters(), (Object)vmParameters) ^ true) {
            return false;
        }
        Project project2 = configuration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"configuration.project");
        RunManager runManager = RunManager.Companion.getInstance(project2);
        ConfigurationFactory configurationFactory = this.getConfigurationFactory();
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"configurationFactory");
        RunnerAndConfigurationSettings template2 = runManager.getConfigurationTemplate(configurationFactory);
        RunConfiguration runConfiguration2 = template2.getConfiguration();
        if (runConfiguration2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.configurations.ModuleBasedConfiguration<*, *>");
        }
        RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)runConfiguration2).getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"(template.configuration \u2026, *>).configurationModule");
        Module predefinedModule = runConfigurationModule.getModule();
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration2.getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
        Module configurationModule = javaRunConfigurationModule.getModule();
        Location location2 = context2.getLocation();
        return Intrinsics.areEqual((Object)configurationModule, location2 != null && (location2 = location2.getModule()) != null ? JvmMppUtilsKt.asJvmModule((Module)location2) : null) || Intrinsics.areEqual((Object)configurationModule, (Object)predefinedModule);
    }

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        DumbService dumbService = DumbService.getInstance((Project)context2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(context.project)");
        if (dumbService.isDumb()) {
            return false;
        }
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context2) || !this.isAvailableInMpp(context2)) {
            return false;
        }
        Location location2 = context2.getLocation();
        if (location2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"context.location ?: return false");
        Location location3 = location2;
        PsiElement psiElement2 = location3.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"location.psiElement");
        PsiElement element3 = psiElement2;
        Module module2 = context2.getModule();
        if (module2 == null || (module2 = JvmMppUtilsKt.asJvmModule(module2)) == null) {
            return false;
        }
        if (!ProjectRootsUtil.isInProjectOrLibSource$default(element3, false, 2, null) || !(element3.getContainingFile() instanceof KtFile)) {
            return false;
        }
        String[] nodeIds = UniqueIdConfigurationProducer.getNodeIds((ConfigurationContext)context2);
        String[] stringArray = nodeIds;
        if (!(stringArray == null || stringArray.length == 0)) {
            return false;
        }
        KotlinTestFrameworkProvider.JavaTestEntity javaTestEntity = JunitKotlinTestFrameworkProvider.INSTANCE.getJavaTestEntity(element3, true);
        if (javaTestEntity == null) {
            return false;
        }
        KotlinTestFrameworkProvider.JavaTestEntity testEntity2 = javaTestEntity;
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration2.getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
        Module originalModule = javaRunConfigurationModule.getModule();
        PsiMethod testMethod = testEntity2.getTestMethod();
        if (testMethod != null) {
            configuration2.beMethodConfiguration(PsiLocation.fromPsiElement((PsiElement)((PsiElement)testMethod)));
        } else {
            configuration2.beClassConfiguration(testEntity2.getTestClass());
        }
        configuration2.restoreOriginalModule(originalModule);
        JavaRunConfigurationExtensionManager.Companion.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location3);
        return true;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context2, @NotNull Runnable performRunnable) {
        Intrinsics.checkNotNullParameter((Object)fromContext, (String)"fromContext");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)performRunnable, (String)"performRunnable");
        KotlinTestFrameworkProvider.JavaTestEntity javaTestEntity = (KotlinTestFrameworkProvider.JavaTestEntity)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(fromContext){
            final /* synthetic */ ConfigurationFromContext $fromContext;

            @Nullable
            public final KotlinTestFrameworkProvider.JavaTestEntity compute() {
                boolean $i$f$runReadAction = false;
                return (KotlinTestFrameworkProvider.JavaTestEntity)ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ onFirstRun.testEntity.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        PsiElement psiElement2 = this.this$0.$fromContext.getSourceElement();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"fromContext.sourceElement");
                        return (T)JunitKotlinTestFrameworkProvider.INSTANCE.getJavaTestEntity(psiElement2, true);
                    }
                });
            }
            {
                this.$fromContext = configurationFromContext;
            }
        }, KotlinBundle.message("progress.text.detect.test.framework", new Object[0]), true, context2.getProject());
        if (javaTestEntity == null) {
            super.onFirstRun(fromContext, context2, performRunnable);
            return;
        }
        KotlinTestFrameworkProvider.JavaTestEntity testEntity2 = javaTestEntity;
        PsiMethod psiMethod = testEntity2.getTestMethod();
        if (psiMethod == null) {
            psiMethod = testEntity2.getTestClass();
        }
        PsiMethod sourceElement = psiMethod;
        ConfigurationFromContext contextWithLightElement = this.createDelegatingContextWithLightElement(fromContext, (PsiMember)sourceElement);
        new AbstractInClassConfigurationProducer<JUnitConfiguration>(){

            @NotNull
            public ConfigurationFactory getConfigurationFactory() {
                JUnitConfigurationType jUnitConfigurationType = JUnitConfigurationType.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)jUnitConfigurationType, (String)"JUnitConfigurationType.getInstance()");
                ConfigurationFactory configurationFactory = jUnitConfigurationType.getFactory();
                Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"JUnitConfigurationType.getInstance().factory");
                return configurationFactory;
            }
        }.onFirstRun(contextWithLightElement, context2, performRunnable);
    }

    private final ConfigurationFromContext createDelegatingContextWithLightElement(ConfigurationFromContext fromContext, PsiMember lightElement) {
        return new ConfigurationFromContext(fromContext, lightElement){
            final /* synthetic */ ConfigurationFromContext $fromContext;
            final /* synthetic */ PsiMember $lightElement;

            @NotNull
            public RunnerAndConfigurationSettings getConfigurationSettings() {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.$fromContext.getConfigurationSettings();
                Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"fromContext.configurationSettings");
                return runnerAndConfigurationSettings;
            }

            public void setConfigurationSettings(@NotNull RunnerAndConfigurationSettings configurationSettings) {
                Intrinsics.checkNotNullParameter((Object)configurationSettings, (String)"configurationSettings");
                this.$fromContext.setConfigurationSettings(configurationSettings);
            }

            @NotNull
            public PsiMember getSourceElement() {
                return this.$lightElement;
            }
            {
                this.$fromContext = $captured_local_variable$0;
                this.$lightElement = $captured_local_variable$1;
            }
        };
    }

    public KotlinJUnitRunConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }
}

