/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.run.KotlinMainFunctionLocatingService;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/run/EntryPointContainerFinder;", "", "()V", "find", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "locationElement", "Lcom/intellij/psi/PsiElement;", "findInFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "declarationContainer", "strict", "", "kotlin.jvm-run-configurations"})
public final class EntryPointContainerFinder {
    @NotNull
    public static final EntryPointContainerFinder INSTANCE;

    @Nullable
    public final KtDeclarationContainer find(@NotNull PsiElement locationElement) {
        KtDeclarationContainer ktDeclarationContainer;
        Intrinsics.checkNotNullParameter((Object)locationElement, (String)"locationElement");
        PsiFile psiFile2 = locationElement.getContainingFile();
        if (!(psiFile2 instanceof KtFile) || !ProjectRootsUtil.isInProjectOrLibSource$default((PsiElement)psiFile2, false, 2, null)) {
            return null;
        }
        KotlinMainFunctionLocatingService mainLocatingService = KotlinMainFunctionLocatingService.Companion.getInstance();
        KtDeclarationContainer currentElement = this.declarationContainer(locationElement, false);
        while (currentElement != null) {
            KtDeclarationContainer entryPointContainer = currentElement;
            if (entryPointContainer instanceof KtClass) {
                entryPointContainer = (KtDeclarationContainer)CollectionsKt.singleOrNull((List)((KtClass)entryPointContainer).getCompanionObjects());
            }
            if (entryPointContainer != null) {
                List list2 = entryPointContainer.getDeclarations();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"entryPointContainer.declarations");
                if (mainLocatingService.hasMain(list2)) {
                    return entryPointContainer;
                }
            }
            currentElement = this.declarationContainer((PsiElement)currentElement, true);
        }
        PsiElement $this$safeAs$iv = locationElement;
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtFile)) {
            psiElement2 = null;
        }
        KtFile ktFile = (KtFile)psiElement2;
        if (ktFile != null) {
            KtFile ktFile2 = ktFile;
            EntryPointContainerFinder entryPointContainerFinder = this;
            KtFile p1 = ktFile2;
            boolean bl = false;
            ktDeclarationContainer = entryPointContainerFinder.findInFile(p1);
        } else {
            ktDeclarationContainer = null;
        }
        return ktDeclarationContainer;
    }

    private final KtDeclarationContainer findInFile(KtFile locationElement) {
        KotlinMainFunctionLocatingService mainLocatingService = KotlinMainFunctionLocatingService.Companion.getInstance();
        var $fun$lookupDeepFirstMainDeclarations$1 = new Function1<KtClassOrObject, KtDeclarationContainer>(mainLocatingService){
            final /* synthetic */ KotlinMainFunctionLocatingService $mainLocatingService;

            @Nullable
            public final KtDeclarationContainer invoke(@NotNull KtClassOrObject $this$lookupDeepFirstMainDeclarations) {
                Intrinsics.checkNotNullParameter((Object)$this$lookupDeepFirstMainDeclarations, (String)"$this$lookupDeepFirstMainDeclarations");
                if ($this$lookupDeepFirstMainDeclarations.isLocal()) {
                    return null;
                }
                if (this.$mainLocatingService.hasMain($this$lookupDeepFirstMainDeclarations.getDeclarations())) {
                    return (KtDeclarationContainer)$this$lookupDeepFirstMainDeclarations;
                }
                Iterator<E> iterator = $this$lookupDeepFirstMainDeclarations.getDeclarations().iterator();
                while (iterator.hasNext()) {
                    KtClassOrObject ktClassOrObject;
                    KtClassOrObject ktClassOrObject2;
                    KtDeclaration declaration2;
                    KtDeclaration $this$safeAs$iv = declaration2 = (KtDeclaration)iterator.next();
                    boolean $i$f$safeAs = false;
                    KtDeclaration ktDeclaration = $this$safeAs$iv;
                    if (!(ktDeclaration instanceof KtClassOrObject)) {
                        ktDeclaration = null;
                    }
                    if ((ktClassOrObject2 = (KtClassOrObject)ktDeclaration) == null || (ktClassOrObject2 = this.invoke(ktClassOrObject2)) == null) continue;
                    KtClassOrObject it = ktClassOrObject = ktClassOrObject2;
                    boolean bl = false;
                    return it;
                }
                return null;
            }
            {
                this.$mainLocatingService = kotlinMainFunctionLocatingService;
                super(1);
            }
        };
        List declarations = locationElement.getDeclarations();
        for (KtDeclaration declaration2 : declarations) {
            KtDeclarationContainer ktDeclarationContainer;
            KtClassOrObject classOrObject;
            KtDeclaration ktDeclaration = declaration2;
            if (!(ktDeclaration instanceof KtClassOrObject)) {
                ktDeclaration = null;
            }
            if ((KtClassOrObject)ktDeclaration == null) {
                continue;
            }
            KtDeclarationContainer ktDeclarationContainer2 = $fun$lookupDeepFirstMainDeclarations$1.invoke(classOrObject);
            if (ktDeclarationContainer2 == null) continue;
            KtDeclarationContainer it = ktDeclarationContainer = ktDeclarationContainer2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final KtDeclarationContainer declarationContainer(PsiElement $this$declarationContainer, boolean strict) {
        PsiElement element3 = strict ? PsiTreeUtil.getParentOfType((PsiElement)$this$declarationContainer, (Class[])new Class[]{KtClassOrObject.class, KtFile.class}) : PsiTreeUtil.getNonStrictParentOfType((PsiElement)$this$declarationContainer, (Class[])new Class[]{KtClassOrObject.class, KtFile.class});
        return (KtDeclarationContainer)element3;
    }

    private EntryPointContainerFinder() {
    }

    static {
        EntryPointContainerFinder entryPointContainerFinder;
        INSTANCE = entryPointContainerFinder = new EntryPointContainerFinder();
    }
}

