/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.PropertiesConventionUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u00a4\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\"\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00030'\u001a\u000e\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+\u001a\n\u0010,\u001a\u00020-*\u00020.\u001a\u0015\u0010/\u001a\u00020+*\u00020+2\u0006\u00100\u001a\u00020+H\u0086\u0004\u001a\n\u00101\u001a\u00020+*\u000202\u001a\n\u00103\u001a\u00020+*\u000202\u001a\n\u00104\u001a\u00020+*\u000202\u001a\n\u00105\u001a\u00020\u0003*\u00020.\u001a\u0012\u00106\u001a\u00020+*\u0002072\u0006\u00108\u001a\u000202\u001a#\u00109\u001a\u00020-*\u00020.2\u0012\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020<0;\"\u00020<\u00a2\u0006\u0002\u0010=\u001a+\u0010>\u001a\u00020+*\u00020+2\u0006\u0010?\u001a\u00020.2\u0012\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020<0;\"\u00020<\u00a2\u0006\u0002\u0010@\u001a\u0012\u0010A\u001a\u00020+*\u00020+2\u0006\u0010?\u001a\u00020.\u001a\n\u0010B\u001a\u00020-*\u00020C\u001a\u000e\u0010D\u001a\u0004\u0018\u00010E*\u000202H\u0007\u001a!\u0010F\u001a\u00020G*\u00020H2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020H\u0012\u0004\u0012\u00020G0'H\u0082\b\u001a.\u0010J\u001a\u00020K*\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020-2\b\u0010P\u001a\u0004\u0018\u00010C2\b\u0010Q\u001a\u0004\u0018\u00010R\u001a\n\u0010S\u001a\u00020\u0003*\u00020T\u001a\f\u0010U\u001a\u00020\u0003*\u0004\u0018\u000102\u001a\u0015\u0010V\u001a\u00020+*\u00020+2\u0006\u00100\u001a\u00020-H\u0086\u0002\u001a\r\u0010W\u001a\u00020-*\u00020-H\u0086\u0002\u001a\u0015\u0010X\u001a\u00020-*\u00020-2\u0006\u00100\u001a\u00020+H\u0086\u0004\u001a\u0015\u0010X\u001a\u00020+*\u00020+2\u0006\u00100\u001a\u00020+H\u0086\u0004\u001a\n\u0010Y\u001a\u00020-*\u00020.\u001a\u0017\u0010Z\u001a\u00070-\u00a2\u0006\u0002\b[*\u00020-2\u0006\u0010\\\u001a\u00020<\u001a\u0012\u0010Z\u001a\u00020+*\u00020+2\u0006\u0010\\\u001a\u00020<\u001a\u000f\u0010]\u001a\u00070-\u00a2\u0006\u0002\b[*\u00020-\u001a\n\u0010]\u001a\u00020+*\u00020+\u001a\n\u0010^\u001a\u00020N*\u00020+\u001a\u0012\u0010_\u001a\u00020+*\u00020+2\u0006\u0010`\u001a\u00020+\u001a\n\u0010a\u001a\u00020+*\u000202\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0007\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u0015\u0010\t\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\"\u0015\u0010\u000b\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\"\u0015\u0010\r\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\"\u0015\u0010\u000f\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\"\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0018\u0010\u0015\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006\"\u0018\u0010\u0016\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006\"\u0018\u0010\u0017\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006\" \u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001a*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\"\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u0012*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014\"\u001d\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001a*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001c\u00a8\u0006b"}, d2={"parenthesisRegex", "Lkotlin/text/Regex;", "canBeGetter", "", "Lcom/intellij/psi/PsiMethod;", "getCanBeGetter", "(Lcom/intellij/psi/PsiMethod;)Z", "canBeSetter", "getCanBeSetter", "canHaveOverride", "getCanHaveOverride", "canHaveSyntheticAccessors", "getCanHaveSyntheticAccessors", "canHaveSyntheticGetter", "getCanHaveSyntheticGetter", "canHaveSyntheticSetter", "getCanHaveSyntheticSetter", "getterName", "Lorg/jetbrains/kotlin/name/Name;", "getGetterName", "(Lcom/intellij/psi/PsiMethod;)Lorg/jetbrains/kotlin/name/Name;", "isFinalProperty", "isTopLevelDeclaration", "probablyCanHaveSyntheticAccessors", "getProbablyCanHaveSyntheticAccessors", "setterNames", "", "getSetterNames", "(Lcom/intellij/psi/PsiMethod;)Ljava/util/Collection;", "syntheticAccessors", "getSyntheticAccessors", "syntheticGetter", "getSyntheticGetter", "syntheticSetters", "getSyntheticSetters", "findScriptsWithUsages", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtFile;", "isOnlyKotlinSearch", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/openapi/project/Project;", "and", "otherScope", "codeUsageScope", "Lcom/intellij/psi/PsiElement;", "codeUsageScopeRestrictedToKotlinSources", "codeUsageScopeRestrictedToProject", "containsKotlinFile", "effectiveSearchScope", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "element", "everythingScopeExcludeFileTypes", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/fileTypes/FileType;)Lcom/intellij/psi/search/GlobalSearchScope;", "excludeFileTypes", "project", "(Lcom/intellij/psi/search/SearchScope;Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/fileTypes/FileType;)Lcom/intellij/psi/search/SearchScope;", "excludeKotlinSources", "fileScope", "Lcom/intellij/psi/PsiFile;", "getKotlinFqName", "Lorg/jetbrains/kotlin/name/FqName;", "ifNotEmpty", "", "", "action", "isCheapEnoughToSearchConsideringOperators", "Lcom/intellij/psi/search/PsiSearchHelper$SearchCostResult;", "Lcom/intellij/psi/search/PsiSearchHelper;", "name", "", "scope", "fileToIgnoreOccurrencesIn", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isImportUsage", "Lcom/intellij/psi/PsiReference;", "isPotentiallyOperator", "minus", "not", "or", "projectScope", "restrictByFileType", "Lorg/jetbrains/annotations/NotNull;", "fileType", "restrictToKotlinSources", "toHumanReadableString", "unionSafe", "other", "useScope", "kotlin.fir.frontend-independent"})
public final class SearchUtilKt {
    private static final Regex parenthesisRegex = new Regex("( *\\( *)|( *\\) *)|( *, *(?![^\\[]*]))");

    @NotNull
    public static final SearchScope and(@NotNull SearchScope $this$and, @NotNull SearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"$this$and");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        SearchScope searchScope2 = $this$and.intersectWith(otherScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"intersectWith(otherScope)");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope or(@NotNull SearchScope $this$or, @NotNull SearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"$this$or");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        SearchScope searchScope2 = $this$or.union(otherScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"union(otherScope)");
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope or(@NotNull GlobalSearchScope $this$or, @NotNull SearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"$this$or");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        GlobalSearchScope globalSearchScope = $this$or.union(otherScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"union(otherScope)");
        return globalSearchScope;
    }

    @NotNull
    public static final SearchScope minus(@NotNull SearchScope $this$minus, @NotNull GlobalSearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"$this$minus");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        return SearchUtilKt.and($this$minus, (SearchScope)SearchUtilKt.not(otherScope));
    }

    @NotNull
    public static final GlobalSearchScope not(@NotNull GlobalSearchScope $this$not) {
        Intrinsics.checkNotNullParameter((Object)$this$not, (String)"$this$not");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)$this$not);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.notScope(this)");
        return globalSearchScope;
    }

    @NotNull
    public static final SearchScope unionSafe(@NotNull SearchScope $this$unionSafe, @NotNull SearchScope other) {
        PsiElement[] psiElementArray;
        Intrinsics.checkNotNullParameter((Object)$this$unionSafe, (String)"$this$unionSafe");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$unionSafe instanceof LocalSearchScope) {
            PsiElement[] psiElementArray2 = ((LocalSearchScope)$this$unionSafe).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"this.scope");
            psiElementArray = psiElementArray2;
            if (psiElementArray.length == 0) {
                return other;
            }
        }
        if (other instanceof LocalSearchScope) {
            PsiElement[] psiElementArray3 = ((LocalSearchScope)other).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"other.scope");
            psiElementArray = psiElementArray3;
            if (psiElementArray.length == 0) {
                return $this$unionSafe;
            }
        }
        SearchScope searchScope2 = $this$unionSafe.union(other);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"this.union(other)");
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope allScope(@NotNull Project $this$allScope) {
        Intrinsics.checkNotNullParameter((Object)$this$allScope, (String)"$this$allScope");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$this$allScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(this)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope projectScope(@NotNull Project $this$projectScope) {
        Intrinsics.checkNotNullParameter((Object)$this$projectScope, (String)"$this$projectScope");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)$this$projectScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(this)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope fileScope(@NotNull PsiFile $this$fileScope) {
        Intrinsics.checkNotNullParameter((Object)$this$fileScope, (String)"$this$fileScope");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)$this$fileScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.fileScope(this)");
        return globalSearchScope;
    }

    public static final boolean containsKotlinFile(@NotNull Project $this$containsKotlinFile) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinFile, (String)"$this$containsKotlinFile");
        return FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)SearchUtilKt.projectScope($this$containsKotlinFile));
    }

    @NotNull
    public static final GlobalSearchScope restrictByFileType(@NotNull GlobalSearchScope $this$restrictByFileType, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)$this$restrictByFileType, (String)"$this$restrictByFileType");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)$this$restrictByFileType, (FileType[])new FileType[]{fileType});
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.getSco\u2026FileTypes(this, fileType)");
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SearchScope restrictByFileType(@NotNull SearchScope $this$restrictByFileType, @NotNull FileType fileType) {
        SearchScope searchScope2;
        Intrinsics.checkNotNullParameter((Object)$this$restrictByFileType, (String)"$this$restrictByFileType");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        SearchScope searchScope3 = $this$restrictByFileType;
        if (searchScope3 instanceof GlobalSearchScope) {
            searchScope2 = (SearchScope)SearchUtilKt.restrictByFileType((GlobalSearchScope)$this$restrictByFileType, fileType);
        } else if (searchScope3 instanceof LocalSearchScope) {
            LocalSearchScope localSearchScope;
            void $this$filterTo$iv$iv;
            PsiElement[] psiElementArray = ((LocalSearchScope)$this$restrictByFileType).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"scope");
            PsiElement[] $this$filter$iv = psiElementArray;
            boolean $i$f$filter = false;
            PsiElement[] psiElementArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                PsiFile psiFile2 = v2.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"it.containingFile");
                if (!Intrinsics.areEqual((Object)psiFile2.getFileType(), (Object)fileType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List elements2 = (List)destination$iv$iv;
            int n2 = elements2.size();
            if (n2 == 0) {
                localSearchScope = LocalSearchScope.EMPTY;
            } else if (n2 == ((LocalSearchScope)$this$restrictByFileType).getScope().length) {
                localSearchScope = (LocalSearchScope)$this$restrictByFileType;
            } else {
                Collection $this$toTypedArray$iv = elements2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PsiElement[] psiElementArray3 = thisCollection$iv.toArray(new PsiElement[0]);
                Intrinsics.checkNotNull((Object)psiElementArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                localSearchScope = new LocalSearchScope(psiElementArray3);
            }
            Intrinsics.checkNotNullExpressionValue((Object)localSearchScope, (String)"when (elements.size) {\n \u2026toTypedArray())\n        }");
            searchScope2 = (SearchScope)localSearchScope;
        } else {
            searchScope2 = $this$restrictByFileType;
        }
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope restrictToKotlinSources(@NotNull GlobalSearchScope $this$restrictToKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$restrictToKotlinSources, (String)"$this$restrictToKotlinSources");
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
        return SearchUtilKt.restrictByFileType($this$restrictToKotlinSources, (FileType)kotlinFileType);
    }

    @NotNull
    public static final SearchScope restrictToKotlinSources(@NotNull SearchScope $this$restrictToKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$restrictToKotlinSources, (String)"$this$restrictToKotlinSources");
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
        return SearchUtilKt.restrictByFileType($this$restrictToKotlinSources, (FileType)kotlinFileType);
    }

    @NotNull
    public static final SearchScope excludeKotlinSources(@NotNull SearchScope $this$excludeKotlinSources, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$excludeKotlinSources, (String)"$this$excludeKotlinSources");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        FileType[] fileTypeArray = new FileType[1];
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
        fileTypeArray[0] = (FileType)kotlinFileType;
        return SearchUtilKt.excludeFileTypes($this$excludeKotlinSources, project2, fileTypeArray);
    }

    @NotNull
    public static final GlobalSearchScope everythingScopeExcludeFileTypes(@NotNull Project $this$everythingScopeExcludeFileTypes, FileType ... fileTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$everythingScopeExcludeFileTypes, (String)"$this$everythingScopeExcludeFileTypes");
        Intrinsics.checkNotNullParameter((Object)fileTypes, (String)"fileTypes");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.everythingScope((Project)$this$everythingScopeExcludeFileTypes), (FileType[])Arrays.copyOf(fileTypes, fileTypes.length));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.getSco\u2026gScope(this), *fileTypes)");
        return SearchUtilKt.not(globalSearchScope);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SearchScope excludeFileTypes(@NotNull SearchScope $this$excludeFileTypes, @NotNull Project project2, FileType ... fileTypes) {
        SearchScope searchScope2;
        Intrinsics.checkNotNullParameter((Object)$this$excludeFileTypes, (String)"$this$excludeFileTypes");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileTypes, (String)"fileTypes");
        if ($this$excludeFileTypes instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = ((GlobalSearchScope)$this$excludeFileTypes).intersectWith(SearchUtilKt.everythingScopeExcludeFileTypes(project2, Arrays.copyOf(fileTypes, fileTypes.length)));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"this.intersectWith(proje\u2026udeFileTypes(*fileTypes))");
            searchScope2 = (SearchScope)globalSearchScope;
        } else {
            LocalSearchScope localSearchScope;
            void $this$filterTo$iv$iv;
            LocalSearchScope cfr_ignored_0 = (LocalSearchScope)$this$excludeFileTypes;
            PsiElement[] psiElementArray = ((LocalSearchScope)$this$excludeFileTypes).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"scope");
            Object $this$filter$iv = psiElementArray;
            boolean $i$f$filter = false;
            PsiElement[] psiElementArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                void v3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                PsiFile psiFile2 = v3.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"it.containingFile");
                if (!(!ArraysKt.contains((Object[])fileTypes, (Object)psiFile2.getFileType()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredElements = (List)destination$iv$iv;
            $this$filter$iv = filteredElements;
            if (!$this$filter$iv.isEmpty()) {
                Collection $this$toTypedArray$iv = filteredElements;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PsiElement[] psiElementArray3 = thisCollection$iv.toArray(new PsiElement[0]);
                Intrinsics.checkNotNull((Object)psiElementArray3, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                localSearchScope = new LocalSearchScope(psiElementArray3);
            } else {
                localSearchScope = LocalSearchScope.EMPTY;
            }
            Intrinsics.checkNotNullExpressionValue((Object)localSearchScope, (String)"if (filteredElements.isN\u2026   LocalSearchScope.EMPTY");
            searchScope2 = (SearchScope)localSearchScope;
        }
        return searchScope2;
    }

    private static final void ifNotEmpty(CharSequence $this$ifNotEmpty, Function1<? super CharSequence, Unit> action2) {
        block0: {
            CharSequence charSequence;
            int $i$f$ifNotEmpty = 0;
            CharSequence p1 = charSequence = $this$ifNotEmpty;
            boolean bl = false;
            CharSequence charSequence2 = p1;
            CharSequence charSequence3 = !StringsKt.isBlank((CharSequence)charSequence2) ? charSequence : null;
            if (charSequence3 == null) break block0;
            charSequence = charSequence3;
            Unit cfr_ignored_0 = (Unit)action2.invoke((Object)charSequence);
        }
    }

    @NotNull
    public static final String toHumanReadableString(@NotNull SearchScope $this$toHumanReadableString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toHumanReadableString, (String)"$this$toHumanReadableString");
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        String scopeText = $this$toHumanReadableString.toString();
        int currentIndent = 0;
        int lastIndex = 0;
        for (MatchResult parenthesis : Regex.findAll$default((Regex)parenthesisRegex, (CharSequence)scopeText, (int)0, (int)2, null)) {
            CharSequence charSequence;
            CharSequence subSequence;
            CharSequence $this$ifNotEmpty$iv = subSequence = scopeText.subSequence(lastIndex, parenthesis.getRange().getFirst());
            boolean $i$f$ifNotEmpty = false;
            CharSequence p1$iv = charSequence = $this$ifNotEmpty$iv;
            boolean bl2 = false;
            CharSequence charSequence2 = p1$iv;
            CharSequence charSequence3 = !StringsKt.isBlank((CharSequence)charSequence2) ? charSequence : null;
            if (charSequence3 != null) {
                CharSequence it = charSequence = charSequence3;
                boolean bl3 = false;
                $this$buildString.append(StringsKt.repeat((CharSequence)" ", (int)currentIndent));
                StringBuilder stringBuilder2 = $this$buildString;
                StringBuilder stringBuilder3 = stringBuilder2.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            }
            String value2 = parenthesis.getValue();
            if (StringsKt.contains$default((CharSequence)value2, (CharSequence)"(", (boolean)false, (int)2, null)) {
                currentIndent += 2;
            } else if (StringsKt.contains$default((CharSequence)value2, (CharSequence)")", (boolean)false, (int)2, null)) {
                currentIndent -= 2;
            }
            lastIndex = parenthesis.getRange().getLast() + 1;
        }
        CharSequence charSequence = $this$buildString;
        if (charSequence.length() == 0) {
            $this$buildString.append(scopeText);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final SearchScope effectiveSearchScope(@NotNull ReferencesSearch.SearchParameters $this$effectiveSearchScope, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)$this$effectiveSearchScope, (String)"$this$effectiveSearchScope");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3, (Object)$this$effectiveSearchScope.getElementToSearch())) {
            SearchScope searchScope2 = $this$effectiveSearchScope.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"effectiveSearchScope");
            return searchScope2;
        }
        if ($this$effectiveSearchScope.isIgnoreAccessScope()) {
            SearchScope searchScope3 = $this$effectiveSearchScope.getScopeDeterminedByUser();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope3, (String)"scopeDeterminedByUser");
            return searchScope3;
        }
        SearchScope accessScope = SearchUtilKt.useScope(element3);
        SearchScope searchScope4 = $this$effectiveSearchScope.getScopeDeterminedByUser().intersectWith(accessScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope4, (String)"scopeDeterminedByUser.intersectWith(accessScope)");
        return searchScope4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOnlyKotlinSearch(@NotNull SearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        if (!(searchScope2 instanceof LocalSearchScope)) return false;
        PsiElement[] psiElementArray = ((LocalSearchScope)searchScope2).getScope();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"searchScope.scope");
        PsiElement[] $this$all$iv = psiElementArray;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            PsiElement element$iv;
            PsiElement it = element$iv = $this$all$iv[n];
            boolean bl = false;
            PsiElement psiElement2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it");
            if (!(psiElement2.getContainingFile() instanceof KtFile)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @NotNull
    public static final SearchScope codeUsageScopeRestrictedToProject(@NotNull PsiElement $this$codeUsageScopeRestrictedToProject) {
        Intrinsics.checkNotNullParameter((Object)$this$codeUsageScopeRestrictedToProject, (String)"$this$codeUsageScopeRestrictedToProject");
        Project project2 = $this$codeUsageScopeRestrictedToProject.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        SearchScope searchScope2 = SearchUtilKt.projectScope(project2).intersectWith(SearchUtilKt.codeUsageScope($this$codeUsageScopeRestrictedToProject));
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"project.projectScope().i\u2026ectWith(codeUsageScope())");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope useScope(@NotNull PsiElement $this$useScope) {
        Intrinsics.checkNotNullParameter((Object)$this$useScope, (String)"$this$useScope");
        SearchScope searchScope2 = PsiSearchHelper.getInstance((Project)$this$useScope.getProject()).getUseScope($this$useScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"PsiSearchHelper.getInsta\u2026roject).getUseScope(this)");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope codeUsageScope(@NotNull PsiElement $this$codeUsageScope) {
        Intrinsics.checkNotNullParameter((Object)$this$codeUsageScope, (String)"$this$codeUsageScope");
        SearchScope searchScope2 = PsiSearchHelper.getInstance((Project)$this$codeUsageScope.getProject()).getCodeUsageScope($this$codeUsageScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"PsiSearchHelper.getInsta\u2026).getCodeUsageScope(this)");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope codeUsageScopeRestrictedToKotlinSources(@NotNull PsiElement $this$codeUsageScopeRestrictedToKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$codeUsageScopeRestrictedToKotlinSources, (String)"$this$codeUsageScopeRestrictedToKotlinSources");
        return SearchUtilKt.restrictToKotlinSources(SearchUtilKt.codeUsageScope($this$codeUsageScopeRestrictedToKotlinSources));
    }

    @NotNull
    public static final PsiSearchHelper.SearchCostResult isCheapEnoughToSearchConsideringOperators(@NotNull PsiSearchHelper $this$isCheapEnoughToSearchConsideringOperators, @NotNull String name2, @NotNull GlobalSearchScope scope2, @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)$this$isCheapEnoughToSearchConsideringOperators, (String)"$this$isCheapEnoughToSearchConsideringOperators");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (OperatorConventions.isConventionName((Name)Name.identifier((String)name2))) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = $this$isCheapEnoughToSearchConsideringOperators.isCheapEnoughToSearch(name2, scope2, fileToIgnoreOccurrencesIn, progress2);
        Intrinsics.checkNotNullExpressionValue((Object)searchCostResult, (String)"isCheapEnoughToSearch(na\u2026eOccurrencesIn, progress)");
        return searchCostResult;
    }

    public static final boolean findScriptsWithUsages(@NotNull KtNamedDeclaration declaration2, @NotNull Function1<? super KtFile, Boolean> processor2) {
        CharSequence charSequence;
        String string;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Project project2 = declaration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"declaration.project");
        Project project3 = project2;
        SearchScope searchScope2 = SearchUtilKt.useScope((PsiElement)declaration2);
        if (!(searchScope2 instanceof GlobalSearchScope)) {
            searchScope2 = null;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope2;
        if (globalSearchScope == null) {
            return true;
        }
        GlobalSearchScope scope2 = globalSearchScope;
        String it = string = declaration2.getName();
        boolean bl = false;
        String string2 = it;
        String string3 = string2 != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string2)) ? string : null;
        if (string3 == null) {
            return true;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"declaration.name.takeIf \u2026 == true } ?: return true");
        String name2 = string3;
        Processor collector2 = new Processor(project3, processor2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Function1 $processor;

            public final boolean process(VirtualFile file2) {
                Object object;
                block5: {
                    block4: {
                        KtFile ktFile;
                        PsiFile psiFile2 = PsiManager.getInstance((Project)this.$project).findFile(file2);
                        if (!(psiFile2 instanceof KtFile)) {
                            psiFile2 = null;
                        }
                        if ((object = (KtFile)psiFile2) == null) break block4;
                        KtFile it = ktFile = object;
                        boolean bl = false;
                        object = KotlinSearchUsagesSupport.Companion.scriptDefinitionExists((PsiFile)it) ? ktFile : null;
                        if (object != null) break block5;
                    }
                    return true;
                }
                KtFile ktFile = object;
                return (Boolean)this.$processor.invoke((Object)ktFile);
            }
            {
                this.$project = project2;
                this.$processor = function1;
            }
        };
        return FileBasedIndex.getInstance().getFilesWithKey(IdIndex.NAME, SetsKt.setOf((Object)new IdIndexEntry(name2, true)), collector2, scope2);
    }

    public static final boolean isImportUsage(@NotNull PsiReference $this$isImportUsage) {
        Intrinsics.checkNotNullParameter((Object)$this$isImportUsage, (String)"$this$isImportUsage");
        PsiElement psiElement2 = $this$isImportUsage.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element");
        PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtImportDirective.class, (boolean)false) != null;
    }

    @Deprecated(message="Use org.jetbrains.kotlin.idea.refactoring.fqName.getKotlinFqName()", level=DeprecationLevel.ERROR, replaceWith=@ReplaceWith(imports={"org.jetbrains.kotlin.idea.refactoring.fqName.getKotlinFqName"}, expression="getKotlinFqName()"))
    @Nullable
    public static final FqName getKotlinFqName(@NotNull PsiElement $this$getKotlinFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$getKotlinFqName, (String)"$this$getKotlinFqName");
        return FqNameUtilKt.getKotlinFqName($this$getKotlinFqName);
    }

    public static final boolean isPotentiallyOperator(@Nullable PsiElement $this$isPotentiallyOperator) {
        PsiElement $this$safeAs$iv = $this$isPotentiallyOperator;
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtNamedFunction)) {
            psiElement2 = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement2;
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction namedFunction = ktNamedFunction;
        if (namedFunction.hasModifier(KtTokens.OPERATOR_KEYWORD)) {
            return true;
        }
        if (!namedFunction.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return false;
        }
        String string = namedFunction.getName();
        if (string == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"namedFunction.name ?: return false");
        String name2 = string;
        return OperatorConventions.isConventionName((Name)Name.identifier((String)name2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getCanBeGetter(PsiMethod $this$canBeGetter) {
        String string = $this$canBeGetter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!JvmAbi.isGetterName((String)string)) return false;
        JvmParameter[] jvmParameterArray = $this$canBeGetter.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"parameters");
        JvmParameter[] jvmParameterArray2 = jvmParameterArray;
        if (jvmParameterArray2.length != 0) return false;
        boolean bl = true;
        if (!bl) return false;
        PsiTypeElement psiTypeElement2 = $this$canBeGetter.getReturnTypeElement();
        if (psiTypeElement2 == null) return true;
        if (psiTypeElement2.textMatches((CharSequence)"void")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getCanBeSetter(PsiMethod $this$canBeSetter) {
        String string = $this$canBeSetter.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!JvmAbi.isSetterName((String)string)) return false;
        if ($this$canBeSetter.getParameters().length != 1) return false;
        PsiTypeElement psiTypeElement2 = $this$canBeSetter.getReturnTypeElement();
        if (psiTypeElement2 == null) return true;
        if (!psiTypeElement2.textMatches((CharSequence)"void")) return false;
        return true;
    }

    private static final boolean getProbablyCanHaveSyntheticAccessors(PsiMethod $this$probablyCanHaveSyntheticAccessors) {
        return SearchUtilKt.getCanHaveOverride($this$probablyCanHaveSyntheticAccessors) && !$this$probablyCanHaveSyntheticAccessors.hasTypeParameters() && !SearchUtilKt.isFinalProperty($this$probablyCanHaveSyntheticAccessors);
    }

    private static final Name getGetterName(PsiMethod $this$getterName) {
        Name name2 = Name.identifier((String)$this$getterName.getName());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(name)");
        return PropertiesConventionUtilKt.propertyNameByGetMethodName((Name)name2);
    }

    private static final Collection<Name> getSetterNames(PsiMethod $this$setterNames) {
        List list2;
        Name name2 = Name.identifier((String)$this$setterNames.getName());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(name)");
        List it = list2 = PropertiesConventionUtilKt.propertyNamesBySetMethodName((Name)name2);
        boolean bl = false;
        Collection collection = it;
        return !collection.isEmpty() ? list2 : null;
    }

    private static final boolean isFinalProperty(PsiMethod $this$isFinalProperty) {
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)$this$isFinalProperty));
        if (!(psiElement2 instanceof KtProperty)) {
            psiElement2 = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement2;
        if (ktProperty == null) {
            return false;
        }
        KtProperty property2 = ktProperty;
        if (property2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return false;
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)property2));
        if (ktClassOrObject == null) {
            return true;
        }
        KtClassOrObject containingClassOrObject = ktClassOrObject;
        return containingClassOrObject instanceof KtObjectDeclaration;
    }

    private static final boolean isTopLevelDeclaration(PsiMethod $this$isTopLevelDeclaration) {
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)$this$isTopLevelDeclaration));
        return psiElement2 != null && KtPsiUtilKt.isTopLevelKtOrJavaMember((PsiElement)psiElement2);
    }

    @NotNull
    public static final Collection<Name> getSyntheticAccessors(@NotNull PsiMethod $this$syntheticAccessors) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$syntheticAccessors, (String)"$this$syntheticAccessors");
        if (!SearchUtilKt.getProbablyCanHaveSyntheticAccessors($this$syntheticAccessors)) {
            return CollectionsKt.emptyList();
        }
        if (SearchUtilKt.getCanBeGetter($this$syntheticAccessors)) {
            collection = CollectionsKt.listOfNotNull((Object)SearchUtilKt.getGetterName($this$syntheticAccessors));
        } else if (SearchUtilKt.getCanBeSetter($this$syntheticAccessors)) {
            Collection collection2 = SearchUtilKt.getSetterNames($this$syntheticAccessors);
            collection = collection2;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public static final boolean getCanHaveSyntheticAccessors(@NotNull PsiMethod $this$canHaveSyntheticAccessors) {
        Intrinsics.checkNotNullParameter((Object)$this$canHaveSyntheticAccessors, (String)"$this$canHaveSyntheticAccessors");
        return SearchUtilKt.getProbablyCanHaveSyntheticAccessors($this$canHaveSyntheticAccessors) && (SearchUtilKt.getCanBeGetter($this$canHaveSyntheticAccessors) || SearchUtilKt.getCanBeSetter($this$canHaveSyntheticAccessors));
    }

    public static final boolean getCanHaveSyntheticGetter(@NotNull PsiMethod $this$canHaveSyntheticGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$canHaveSyntheticGetter, (String)"$this$canHaveSyntheticGetter");
        return SearchUtilKt.getProbablyCanHaveSyntheticAccessors($this$canHaveSyntheticGetter) && SearchUtilKt.getCanBeGetter($this$canHaveSyntheticGetter);
    }

    public static final boolean getCanHaveSyntheticSetter(@NotNull PsiMethod $this$canHaveSyntheticSetter) {
        Intrinsics.checkNotNullParameter((Object)$this$canHaveSyntheticSetter, (String)"$this$canHaveSyntheticSetter");
        return SearchUtilKt.getProbablyCanHaveSyntheticAccessors($this$canHaveSyntheticSetter) && SearchUtilKt.getCanBeSetter($this$canHaveSyntheticSetter);
    }

    @Nullable
    public static final Name getSyntheticGetter(@NotNull PsiMethod $this$syntheticGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$syntheticGetter, (String)"$this$syntheticGetter");
        return SearchUtilKt.getCanHaveSyntheticGetter($this$syntheticGetter) ? SearchUtilKt.getGetterName($this$syntheticGetter) : null;
    }

    @Nullable
    public static final Collection<Name> getSyntheticSetters(@NotNull PsiMethod $this$syntheticSetters) {
        Intrinsics.checkNotNullParameter((Object)$this$syntheticSetters, (String)"$this$syntheticSetters");
        return SearchUtilKt.getCanHaveSyntheticSetter($this$syntheticSetters) ? SearchUtilKt.getSetterNames($this$syntheticSetters) : null;
    }

    public static final boolean getCanHaveOverride(@NotNull PsiMethod $this$canHaveOverride) {
        Intrinsics.checkNotNullParameter((Object)$this$canHaveOverride, (String)"$this$canHaveOverride");
        return !$this$canHaveOverride.hasModifier(JvmModifier.STATIC) && !$this$canHaveOverride.isConstructor() && !SearchUtilKt.isTopLevelDeclaration($this$canHaveOverride);
    }
}

