/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.printing;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.nj2k.JKImportStorage;
import org.jetbrains.kotlin.nj2k.UtilsKt;
import org.jetbrains.kotlin.nj2k.printing.CanBeShortenedCache;
import org.jetbrains.kotlin.nj2k.printing.PrintingUtilsKt;
import org.jetbrains.kotlin.nj2k.symbols.JKClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKSymbol;
import org.jetbrains.kotlin.nj2k.tree.JKClassAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\f\u0010\u0011\u001a\u00020\u0010*\u00020\fH\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/nj2k/printing/JKSymbolRenderer;", "", "importStorage", "Lorg/jetbrains/kotlin/nj2k/JKImportStorage;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/nj2k/JKImportStorage;Lcom/intellij/openapi/project/Project;)V", "canBeShortenedClassNameCache", "Lorg/jetbrains/kotlin/nj2k/printing/CanBeShortenedCache;", "renderSymbol", "", "symbol", "Lorg/jetbrains/kotlin/nj2k/symbols/JKSymbol;", "owner", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "isFqNameExpected", "", "isFromJavaLangPackage", "isSelectorOfQualifiedExpression", "Companion", "kotlin.j2k.new"})
public final class JKSymbolRenderer {
    private final CanBeShortenedCache canBeShortenedClassNameCache;
    private final JKImportStorage importStorage;
    private static final String JAVA_LANG_FQ_PREFIX = "java.lang";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final boolean isFqNameExpected(JKSymbol $this$isFqNameExpected, JKTreeElement owner) {
        JKTreeElement jKTreeElement = owner;
        if (jKTreeElement != null) {
            if (this.isSelectorOfQualifiedExpression(jKTreeElement)) {
                return false;
            }
        }
        return $this$isFqNameExpected instanceof JKClassSymbol || org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isStaticMember($this$isFqNameExpected) || org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isEnumConstant($this$isFqNameExpected);
    }

    private final boolean isFromJavaLangPackage(JKSymbol $this$isFromJavaLangPackage) {
        return StringsKt.startsWith$default((String)$this$isFromJavaLangPackage.getFqName(), (String)JAVA_LANG_FQ_PREFIX, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String renderSymbol(@NotNull JKSymbol symbol, @Nullable JKTreeElement owner) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        String name2 = UtilsKt.escaped(symbol.getName());
        if (!this.isFqNameExpected(symbol, owner)) {
            return name2;
        }
        String fqName2 = PrintingUtilsKt.escapedAsQualifiedName(org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getDisplayFqName(symbol));
        if (owner instanceof JKClassAccessExpression && this.isFromJavaLangPackage(symbol)) {
            return fqName2;
        }
        if (symbol instanceof JKClassSymbol && this.canBeShortenedClassNameCache.canBeShortened((JKClassSymbol)symbol)) {
            this.importStorage.addImport(fqName2);
            object = name2;
            return object;
        }
        if (org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isStaticMember(symbol)) {
            JKClassSymbol jKClassSymbol = org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getContainingClass(symbol);
            if (jKClassSymbol != null) {
                if (org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isUnnamedCompanion(jKClassSymbol)) {
                    JKClassSymbol jKClassSymbol2 = org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getContainingClass(symbol);
                    if (jKClassSymbol2 == null) {
                        return fqName2;
                    }
                    JKClassSymbol containingClass2 = jKClassSymbol2;
                    JKClassSymbol jKClassSymbol3 = org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getContainingClass(containingClass2);
                    if (jKClassSymbol3 == null) {
                        return fqName2;
                    }
                    JKClassSymbol classContainingCompanion = jKClassSymbol3;
                    if (!this.canBeShortenedClassNameCache.canBeShortened(classContainingCompanion)) {
                        return fqName2;
                    }
                    this.importStorage.addImport(org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getDisplayFqName(classContainingCompanion));
                    object = UtilsKt.escaped(classContainingCompanion.getName()) + "." + SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT + "." + name2;
                    return object;
                }
            }
        }
        if (org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isEnumConstant(symbol) || org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isStaticMember(symbol)) {
            JKClassSymbol jKClassSymbol = org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getContainingClass(symbol);
            if (jKClassSymbol == null) {
                return fqName2;
            }
            JKClassSymbol containingClass3 = jKClassSymbol;
            if (!this.canBeShortenedClassNameCache.canBeShortened(containingClass3)) {
                return fqName2;
            }
            this.importStorage.addImport(org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getDisplayFqName(containingClass3));
            object = UtilsKt.escaped(containingClass3.getName()) + "." + name2;
            return object;
        } else {
            object = fqName2;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean isSelectorOfQualifiedExpression(JKTreeElement $this$isSelectorOfQualifiedExpression) {
        JKExpression jKExpression;
        JKElement jKElement = $this$isSelectorOfQualifiedExpression.getParent();
        if (jKElement != null) {
            JKElement $this$safeAs$iv = jKElement;
            boolean $i$f$safeAs = false;
            JKElement jKElement2 = $this$safeAs$iv;
            if (!(jKElement2 instanceof JKQualifiedExpression)) {
                jKElement2 = null;
            }
            if ((jKElement = (JKQualifiedExpression)jKElement2) != null) {
                jKExpression = ((JKQualifiedExpression)jKElement).getSelector();
                return Intrinsics.areEqual(jKExpression, (Object)$this$isSelectorOfQualifiedExpression);
            }
        }
        jKExpression = null;
        return Intrinsics.areEqual(jKExpression, (Object)$this$isSelectorOfQualifiedExpression);
    }

    public JKSymbolRenderer(@NotNull JKImportStorage importStorage, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)importStorage, (String)"importStorage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.importStorage = importStorage;
        this.canBeShortenedClassNameCache = new CanBeShortenedCache(project2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/nj2k/printing/JKSymbolRenderer$Companion;", "", "()V", "JAVA_LANG_FQ_PREFIX", "", "kotlin.j2k.new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

