/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.ClosedTimeInterval;
import circlet.common.calendar.DatesInterval;
import circlet.common.calendar.TimeIntervalDTO;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B!\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004J\u0012\u0010\u0015\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004J\u0013\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u001e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001f\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0015\u0010\u0010\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006'"}, d2={"Lcirclet/common/calendar/TimeInterval;", "", "start", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "endInclusive", "(Lcirclet/platform/api/KotlinXDateTime;Lcirclet/platform/api/KotlinXDateTime;)V", "dto", "Lcirclet/common/calendar/TimeIntervalDTO;", "getDto", "()Lcirclet/common/calendar/TimeIntervalDTO;", "endExclusive", "getEndExclusive", "()Lcirclet/platform/api/KotlinXDateTime;", "getEndInclusive", "getStart", "startExclusive", "getStartExclusive", "contains", "", "time", "endsBefore", "equals", "other", "hashCode", "", "intersects", "interval", "Lcirclet/common/calendar/ClosedTimeInterval;", "remove", "", "startsAfter", "toDates", "Lcirclet/common/calendar/DatesInterval;", "timezone", "Lcirclet/platform/api/ATimeZone;", "toString", "", "Factory", "common"})
public class TimeInterval {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final KotlinXDateTime start;
    @Nullable
    private final KotlinXDateTime endInclusive;
    @NotNull
    private final TimeIntervalDTO dto;
    @NotNull
    private final KotlinXDateTime startExclusive;
    @Nullable
    private final KotlinXDateTime endExclusive;

    public TimeInterval(@NotNull KotlinXDateTime start2, @Nullable KotlinXDateTime endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        this.start = start2;
        this.endInclusive = endInclusive;
        this.dto = new TimeIntervalDTO(this.start, this.endInclusive);
        this.startExclusive = ADateJvmKt.plusMillis(this.start, -1);
        KotlinXDateTime kotlinXDateTime = this.endInclusive;
        this.endExclusive = kotlinXDateTime == null ? null : ADateJvmKt.plusMillis(kotlinXDateTime, 1);
    }

    @NotNull
    public final KotlinXDateTime getStart() {
        return this.start;
    }

    @Nullable
    public final KotlinXDateTime getEndInclusive() {
        return this.endInclusive;
    }

    @NotNull
    public final TimeIntervalDTO getDto() {
        return this.dto;
    }

    @NotNull
    public final KotlinXDateTime getStartExclusive() {
        return this.startExclusive;
    }

    @Nullable
    public final KotlinXDateTime getEndExclusive() {
        return this.endExclusive;
    }

    public final boolean startsAfter(@NotNull KotlinXDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return this.start.compareTo(time) > 0;
    }

    public final boolean endsBefore(@NotNull KotlinXDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return this.endInclusive != null && time.compareTo(this.endInclusive) > 0;
    }

    public final boolean contains(@NotNull KotlinXDateTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return this.start.compareTo(time) <= 0 && (this.endInclusive == null || time.compareTo(this.endInclusive) <= 0);
    }

    public final boolean intersects(@NotNull ClosedTimeInterval interval2) {
        Intrinsics.checkNotNullParameter((Object)interval2, (String)"interval");
        return !this.startsAfter(interval2.getClosedEndInclusive()) && !this.endsBefore(interval2.getStart());
    }

    @NotNull
    public final List<TimeInterval> remove(@NotNull ClosedTimeInterval interval2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)interval2, (String)"interval");
        if (!this.intersects(interval2)) {
            list2 = CollectionsKt.listOf((Object)this);
        } else {
            Object[] objectArray = new TimeInterval[]{Factory.createIfValid(this.start, interval2.getStartExclusive()), Factory.createIfValid(interval2.getClosedEndExclusive(), this.endInclusive)};
            list2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        return list2;
    }

    @NotNull
    public final DatesInterval toDates(@NotNull ATimeZone timezone) {
        Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
        return this.dto.toDates(timezone);
    }

    @NotNull
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append('(').append(ADateJvmKt.formatFullDateTime(this.start)).append(" \u2013 ");
        KotlinXDateTime kotlinXDateTime = this.endInclusive;
        if (kotlinXDateTime == null) {
            string2 = "inf";
        } else {
            string2 = ADateJvmKt.formatFullDateTime(kotlinXDateTime);
            if (string2 == null) {
                string2 = "inf";
            }
        }
        return stringBuilder.append(string2).append(')').toString();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        TimeInterval cfr_ignored_0 = (TimeInterval)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)((TimeInterval)other).start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endInclusive, (Object)((TimeInterval)other).endInclusive);
    }

    public int hashCode() {
        int n;
        int result2 = this.start.hashCode();
        KotlinXDateTime kotlinXDateTime = this.endInclusive;
        result2 = 31 * result2 + (kotlinXDateTime == null ? 0 : (n = kotlinXDateTime.hashCode()));
        return result2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u000e\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a8\u0006\t"}, d2={"Lcirclet/common/calendar/TimeInterval$Factory;", "", "()V", "createIfValid", "Lcirclet/common/calendar/TimeInterval;", "start", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "endInclusive", "common"})
    public static final class Factory {
        private Factory() {
        }

        @Nullable
        public final TimeInterval createIfValid(@NotNull KotlinXDateTime start2, @Nullable KotlinXDateTime endInclusive) {
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            return endInclusive == null || start2.compareTo(endInclusive) <= 0 ? new TimeInterval(start2, endInclusive) : null;
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

