/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs;

import circlet.client.api.ProjectKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.utils.SpaceUrls;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u0082\u0001\u0003\u0014\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/space/vcs/UrlData;", "", "project", "Lcom/intellij/openapi/project/Project;", "info", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "repo", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/space/vcs/SpaceProjectInfo;Ljava/lang/String;)V", "getInfo", "()Lcom/intellij/space/vcs/SpaceProjectInfo;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepo", "()Ljava/lang/String;", "url", "getUrl", "Commit", "File", "FileRevision", "Lcom/intellij/space/vcs/UrlData$Commit;", "Lcom/intellij/space/vcs/UrlData$FileRevision;", "Lcom/intellij/space/vcs/UrlData$File;", "intellij.space.vcs"})
public abstract class UrlData {
    @NotNull
    private final Project project;
    @NotNull
    private final SpaceProjectInfo info;
    @NotNull
    private final String repo;

    @Nullable
    public abstract String getUrl();

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SpaceProjectInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final String getRepo() {
        return this.repo;
    }

    private UrlData(Project project2, SpaceProjectInfo info2, String repo) {
        this.project = project2;
        this.info = info2;
        this.repo = repo;
    }

    public /* synthetic */ UrlData(Project project2, SpaceProjectInfo info2, String repo, DefaultConstructorMarker $constructor_marker) {
        this(project2, info2, repo);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/space/vcs/UrlData$Commit;", "Lcom/intellij/space/vcs/UrlData;", "project", "Lcom/intellij/openapi/project/Project;", "projectKey", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "repo", "", "commit", "Lcom/intellij/vcs/log/CommitId;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/space/vcs/SpaceProjectInfo;Ljava/lang/String;Lcom/intellij/vcs/log/CommitId;)V", "url", "getUrl", "()Ljava/lang/String;", "intellij.space.vcs"})
    public static final class Commit
    extends UrlData {
        private final CommitId commit;

        @Override
        @NotNull
        public String getUrl() {
            ProjectKey projectKey = this.getInfo().getKey();
            String string2 = this.getRepo();
            String string3 = this.commit.getHash().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commit.hash.asString()");
            return SpaceUrls.INSTANCE.revision(projectKey, string2, string3);
        }

        public Commit(@NotNull Project project2, @NotNull SpaceProjectInfo projectKey, @NotNull String repo, @NotNull CommitId commit) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            super(project2, projectKey, repo, null);
            this.commit = commit;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/space/vcs/UrlData$FileRevision;", "Lcom/intellij/space/vcs/UrlData;", "project", "Lcom/intellij/openapi/project/Project;", "projectKey", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "repo", "", "vcsFileRevisionEx", "Lcom/intellij/openapi/vcs/history/VcsFileRevisionEx;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/space/vcs/SpaceProjectInfo;Ljava/lang/String;Lcom/intellij/openapi/vcs/history/VcsFileRevisionEx;)V", "url", "getUrl", "()Ljava/lang/String;", "intellij.space.vcs"})
    public static final class FileRevision
    extends UrlData {
        private final VcsFileRevisionEx vcsFileRevisionEx;

        @Override
        @NotNull
        public String getUrl() {
            ProjectKey projectKey = this.getInfo().getKey();
            String string2 = this.getRepo();
            String string3 = this.vcsFileRevisionEx.getRevisionNumber().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"vcsFileRevisionEx.revisionNumber.asString()");
            return SpaceUrls.INSTANCE.revision(projectKey, string2, string3);
        }

        public FileRevision(@NotNull Project project2, @NotNull SpaceProjectInfo projectKey, @NotNull String repo, @NotNull VcsFileRevisionEx vcsFileRevisionEx) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter((Object)vcsFileRevisionEx, (String)"vcsFileRevisionEx");
            super(project2, projectKey, repo, null);
            this.vcsFileRevisionEx = vcsFileRevisionEx;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\tH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/space/vcs/UrlData$File;", "Lcom/intellij/space/vcs/UrlData;", "project", "Lcom/intellij/openapi/project/Project;", "projectKey", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "repo", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectedLine", "", "gitRepository", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/space/vcs/SpaceProjectInfo;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Integer;Lgit4idea/repo/GitRepository;)V", "Ljava/lang/Integer;", "url", "getUrl", "()Ljava/lang/String;", "getCurrentFileRevisionHash", "file", "intellij.space.vcs"})
    public static final class File
    extends UrlData {
        private final VirtualFile virtualFile;
        private final Integer selectedLine;
        private final GitRepository gitRepository;

        @Override
        @Nullable
        public String getUrl() {
            String string2 = VfsUtilCore.getRelativePath((VirtualFile)this.virtualFile, (VirtualFile)this.gitRepository.getRoot());
            if (string2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VfsUtilCore.getRelativeP\u2026tory.root) ?: return null");
            String relativePath = string2;
            String string3 = this.getCurrentFileRevisionHash(this.getProject(), this.virtualFile);
            if (string3 == null) {
                return null;
            }
            String hash = string3;
            return SpaceUrls.INSTANCE.file(this.getInfo().getKey(), this.getRepo(), hash, relativePath, this.selectedLine);
        }

        private final String getCurrentFileRevisionHash(Project project2, VirtualFile file2) {
            String string2;
            Ref ref2 = new Ref();
            new Task.Modal(ref2, project2, file2, project2, SpaceBundle.message("open.file.on.space.getting.last.revision.indicator.text", new Object[0]), true){
                final /* synthetic */ Ref $ref;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    this.$ref.set((Object)((GitRevisionNumber)GitHistoryUtils.getCurrentRevision((Project)this.$project, (FilePath)VcsUtil.getFilePath((VirtualFile)this.$file), (String)"HEAD")));
                }

                public void onThrowable(@NotNull Throwable error2) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                }
                {
                    this.$ref = $captured_local_variable$0;
                    this.$project = $captured_local_variable$1;
                    this.$file = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                }
            }.queue();
            if (ref2.isNull()) {
                string2 = null;
            } else {
                Object object = ref2.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ref.get()");
                string2 = ((GitRevisionNumber)object).getRev();
            }
            return string2;
        }

        public File(@NotNull Project project2, @NotNull SpaceProjectInfo projectKey, @NotNull String repo, @NotNull VirtualFile virtualFile, @Nullable Integer selectedLine, @NotNull GitRepository gitRepository) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
            Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)gitRepository, (String)"gitRepository");
            super(project2, projectKey, repo, null);
            this.virtualFile = virtualFile;
            this.selectedLine = selectedLine;
            this.gitRepository = gitRepository;
        }

        public /* synthetic */ File(Project project2, SpaceProjectInfo spaceProjectInfo, String string2, VirtualFile virtualFile, Integer n, GitRepository gitRepository, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            this(project2, spaceProjectInfo, string2, virtualFile, n, gitRepository);
        }
    }
}

