/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.AbstractArtifact;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public class MDArtifact
extends AbstractArtifact {
    private ModuleDescriptor md;
    private String name;
    private String type;
    private String ext;
    private final List<String> confs = new ArrayList<String>();
    private Map<String, String> extraAttributes = null;
    private URL url;
    private boolean isMetadata = false;

    public static Artifact newIvyArtifact(ModuleDescriptor md) {
        return new MDArtifact(md, "ivy", "ivy", "xml", true);
    }

    public MDArtifact(ModuleDescriptor md, String name2, String type, String ext2) {
        this(md, name2, type, ext2, null, null);
    }

    public MDArtifact(ModuleDescriptor md, String name2, String type, String ext2, boolean isMetadata) {
        this(md, name2, type, ext2, null, null);
        this.isMetadata = isMetadata;
    }

    public MDArtifact(ModuleDescriptor md, String name2, String type, String ext2, URL url2, Map<String, String> extraAttributes) {
        if (md == null) {
            throw new NullPointerException("null module descriptor not allowed");
        }
        if (name2 == null) {
            throw new NullPointerException("null name not allowed");
        }
        if (type == null) {
            throw new NullPointerException("null type not allowed");
        }
        if (ext2 == null) {
            throw new NullPointerException("null ext not allowed");
        }
        this.md = md;
        this.name = name2;
        this.type = type;
        this.ext = ext2;
        this.url = url2;
        this.extraAttributes = extraAttributes;
    }

    @Override
    public ModuleRevisionId getModuleRevisionId() {
        return this.md.getResolvedModuleRevisionId();
    }

    @Override
    public Date getPublicationDate() {
        return this.md.getResolvedPublicationDate();
    }

    @Override
    public ArtifactRevisionId getId() {
        return ArtifactRevisionId.newInstance(this.md.getResolvedModuleRevisionId(), this.name, this.type, this.ext, this.extraAttributes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getExt() {
        return this.ext;
    }

    @Override
    public String[] getConfigurations() {
        return this.confs.toArray(new String[this.confs.size()]);
    }

    public void addConfiguration(String conf) {
        this.confs.add(conf);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isMetadata() {
        return this.isMetadata;
    }
}

