/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.IMatcher;
import org.eclipse.jgit.ignore.internal.PathMatcher;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

public class DescribeCommand
extends GitCommand<String> {
    private final RevWalk w;
    private RevCommit target;
    private int maxCandidates = 10;
    private boolean longDesc;
    private List<IMatcher> matchers = new ArrayList<IMatcher>();
    private boolean useTags = false;

    protected DescribeCommand(Repository repo) {
        super(repo);
        this.w = new RevWalk(repo);
        this.w.setRetainBody(false);
    }

    public DescribeCommand setTarget(ObjectId target) throws IOException {
        this.target = this.w.parseCommit(target);
        return this;
    }

    public DescribeCommand setTarget(String rev) throws IOException, RefNotFoundException {
        ObjectId id = this.repo.resolve(rev);
        if (id == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, rev));
        }
        return this.setTarget(id);
    }

    public DescribeCommand setLong(boolean longDesc) {
        this.longDesc = longDesc;
        return this;
    }

    public DescribeCommand setTags(boolean tags) {
        this.useTags = tags;
        return this;
    }

    private String longDescription(Ref tag, int depth, ObjectId tip) throws IOException {
        return String.format("%s-%d-g%s", tag.getName().substring("refs/tags/".length()), depth, this.w.getObjectReader().abbreviate(tip).name());
    }

    public DescribeCommand setMatch(String ... patterns) throws InvalidPatternException {
        for (String p : patterns) {
            this.matchers.add(PathMatcher.createPathMatcher(p, null, false));
        }
        return this;
    }

    private Optional<Ref> getBestMatch(List<Ref> tags) {
        if (tags == null || tags.size() == 0) {
            return Optional.empty();
        }
        if (this.matchers.size() == 0) {
            return Optional.of(tags.get(0));
        }
        for (IMatcher matcher : this.matchers) {
            Optional<Ref> match = tags.stream().filter(tag -> matcher.matches(tag.getName(), false, false)).findFirst();
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    private ObjectId getObjectIdFromRef(Ref r) throws JGitInternalException {
        try {
            ObjectId key = this.repo.getRefDatabase().peel(r).getPeeledObjectId();
            if (key == null) {
                key = r.getObjectId();
            }
            return key;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    @Override
    public String call() throws GitAPIException {
        try {
            class Candidate {
                final Ref tag;
                final RevFlag flag;
                int depth;

                Candidate(RevCommit commit2, Ref tag) {
                    this.tag = tag;
                    this.flag = DescribeCommand.this.w.newFlag(tag.getName());
                    allFlags.add(this.flag);
                    DescribeCommand.this.w.carry(this.flag);
                    commit2.add(this.flag);
                    commit2.carry(this.flag);
                }

                boolean reaches(RevCommit c) {
                    return c.has(this.flag);
                }

                String describe(ObjectId tip) throws IOException {
                    return DescribeCommand.this.longDescription(this.tag, this.depth, tip);
                }
            }
            Object cd;
            RevCommit c;
            this.checkCallable();
            if (this.target == null) {
                this.setTarget("HEAD");
            }
            List<Ref> tagList = this.repo.getRefDatabase().getRefsByPrefix("refs/tags/");
            Map<ObjectId, List<Ref>> tags = tagList.stream().filter(this::filterLightweightTags).collect(Collectors.groupingBy(this::getObjectIdFromRef));
            final RevFlagSet allFlags = new RevFlagSet();
            ArrayList<Object> candidates = new ArrayList<Object>();
            Optional<Ref> bestMatch = this.getBestMatch(tags.get(this.target));
            if (bestMatch.isPresent()) {
                String string = this.longDesc ? this.longDescription(bestMatch.get(), 0, this.target) : bestMatch.get().getName().substring("refs/tags/".length());
                return string;
            }
            this.w.markStart(this.target);
            int seen = 0;
            while ((c = this.w.next()) != null) {
                if (!c.hasAny(allFlags) && (bestMatch = this.getBestMatch(tags.get(c))).isPresent()) {
                    cd = new Candidate(c, bestMatch.get());
                    candidates.add(cd);
                    ((Candidate)cd).depth = seen;
                }
                for (Candidate candidate : candidates) {
                    if (candidate.reaches(c)) continue;
                    ++candidate.depth;
                }
                if (candidates.size() >= this.maxCandidates) break;
                ++seen;
            }
            while ((c = this.w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    for (RevCommit p : c.getParents()) {
                        p.add(RevFlag.SEEN);
                    }
                    continue;
                }
                for (Candidate candidate : candidates) {
                    if (candidate.reaches(c)) continue;
                    ++candidate.depth;
                }
            }
            if (candidates.isEmpty()) {
                cd = null;
                return cd;
            }
            Candidate best = Collections.min(candidates, new Comparator<Candidate>(){

                @Override
                public int compare(Candidate o1, Candidate o2) {
                    return o1.depth - o2.depth;
                }
            });
            String string = best.describe(this.target);
            return string;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            this.setCallable(false);
            this.w.close();
        }
    }

    private boolean filterLightweightTags(Ref ref) {
        ObjectId id = ref.getObjectId();
        try {
            return this.useTags || id != null && this.w.parseTag(id) != null;
        }
        catch (IOException e) {
            return false;
        }
    }
}

