/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.highlighting.DomHighlightStatus;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.Highlightable;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DomElementsErrorPanel
extends JPanel
implements CommittablePanel,
Highlightable {
    private static final int ALARM_PERIOD = 241;
    private final Project myProject;
    private final DomElement[] myDomElements;
    private final DomElementsTrafficLightRenderer myErrorStripeRenderer;
    private final DomElementAnnotationsManagerImpl myAnnotationsManager;
    private final Alarm myAlarm = new Alarm();

    public DomElementsErrorPanel(DomElement ... domElements) {
        assert (domElements.length > 0);
        this.myDomElements = domElements;
        DomManager domManager = domElements[0].getManager();
        this.myProject = domManager.getProject();
        this.myAnnotationsManager = (DomElementAnnotationsManagerImpl)DomElementAnnotationsManager.getInstance((Project)this.myProject);
        this.setPreferredSize(DomElementsErrorPanel.getDimension());
        this.myErrorStripeRenderer = new DomElementsTrafficLightRenderer(DomUtil.getFile((DomElement)domElements[0]));
        Disposer.register((Disposable)this, (Disposable)this.myErrorStripeRenderer);
        this.addUpdateRequest();
        domManager.addDomEventListener((DomEventListener)new DomChangeAdapter(){

            protected void elementChanged(DomElement element) {
                DomElementsErrorPanel.this.addUpdateRequest();
            }
        }, (Disposable)this);
    }

    public void updateHighlighting() {
        this.updatePanel();
    }

    private boolean areValid() {
        for (DomElement domElement : this.myDomElements) {
            if (domElement.isValid()) continue;
            return false;
        }
        return true;
    }

    private void updatePanel() {
        this.myAlarm.cancelAllRequests();
        if (!this.areValid()) {
            return;
        }
        this.repaint();
        if (!this.isHighlightingFinished()) {
            this.addUpdateRequest();
        }
    }

    private boolean isHighlightingFinished() {
        return !this.areValid() || this.myAnnotationsManager.isHighlightingFinished(this.myDomElements);
    }

    private void addUpdateRequest() {
        ApplicationManager.getApplication().invokeLater(() -> this.myAlarm.addRequest(() -> {
            if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
                this.updatePanel();
            }
        }, 241));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myErrorStripeRenderer.getStatus().getIcon().paintIcon(this, g, 0, 0);
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
    }

    public JComponent getComponent() {
        return this;
    }

    public void commit() {
    }

    public void reset() {
        this.updatePanel();
    }

    private static Dimension getDimension() {
        return JBUI.size((int)14);
    }

    private class DomElementsTrafficLightRenderer
    extends TrafficLightRenderer {
        DomElementsTrafficLightRenderer(XmlFile xmlFile) {
            if (xmlFile == null) {
                DomElementsTrafficLightRenderer.$$$reportNull$$$0(0);
            }
            super(xmlFile.getProject(), xmlFile.getViewProvider().getDocument());
        }

        @NotNull
        protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
            if (severityRegistrar == null) {
                DomElementsTrafficLightRenderer.$$$reportNull$$$0(1);
            }
            TrafficLightRenderer.DaemonCodeAnalyzerStatus status = super.getDaemonCodeAnalyzerStatus(severityRegistrar);
            if (this.isInspectionCompleted()) {
                status.errorAnalyzingFinished = true;
            }
            TrafficLightRenderer.DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                DomElementsTrafficLightRenderer.$$$reportNull$$$0(2);
            }
            return daemonCodeAnalyzerStatus;
        }

        protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
            if (status == null) {
                DomElementsTrafficLightRenderer.$$$reportNull$$$0(3);
            }
            if (severityRegistrar == null) {
                DomElementsTrafficLightRenderer.$$$reportNull$$$0(4);
            }
            for (int i = 0; i < status.errorCounts.length; ++i) {
                HighlightSeverity minSeverity = severityRegistrar.getSeverityByIndex(i);
                if (minSeverity == null) continue;
                int sum = 0;
                for (DomElement element : DomElementsErrorPanel.this.myDomElements) {
                    DomElementsProblemsHolder holder = DomElementsErrorPanel.this.myAnnotationsManager.getCachedProblemHolder(element);
                    sum += (SeverityRegistrar.getSeverityRegistrar((Project)this.getProject()).compare(minSeverity, HighlightSeverity.WARNING) >= 0 ? holder.getProblems(element, true, true) : holder.getProblems(element, true, minSeverity)).size();
                }
                status.errorCounts[i] = sum;
            }
        }

        boolean isInspectionCompleted() {
            return ContainerUtil.and((Object[])DomElementsErrorPanel.this.myDomElements, element -> DomElementsErrorPanel.this.myAnnotationsManager.getHighlightStatus((DomElement)element) == DomHighlightStatus.INSPECTIONS_FINISHED);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlFile";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severityRegistrar";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementsErrorPanel$DomElementsTrafficLightRenderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementsErrorPanel$DomElementsTrafficLightRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDaemonCodeAnalyzerStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDaemonCodeAnalyzerStatus";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fillDaemonCodeAnalyzerErrorsStatus";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

