/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.meta.impl.YamlDebugUtil;
import org.jetbrains.yaml.meta.impl.YamlKeyInsertHandlerImpl;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlAnyOfType;
import org.jetbrains.yaml.meta.model.YamlMetaClass;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public abstract class YamlMetaTypeCompletionProviderBase
extends CompletionProvider<CompletionParameters> {
    protected static final Logger LOG = Logger.getInstance(YamlMetaTypeCompletionProviderBase.class);

    @Nullable
    protected abstract YamlMetaTypeProvider getMetaTypeProvider(@NotNull CompletionParameters var1);

    protected void addCompletions(@NotNull CompletionParameters params, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        YamlMetaTypeProvider metaTypeProvider;
        if (params == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(1);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(2);
        }
        if ((metaTypeProvider = this.getMetaTypeProvider(params)) == null) {
            return;
        }
        PsiElement position = params.getPosition();
        if (YamlMetaTypeCompletionProviderBase.isOfType(position.getParent(), YAMLElementTypes.SCALAR_PLAIN_VALUE, YAMLElementTypes.SCALAR_QUOTED_STRING)) {
            this.processValueOrInsertedKey(params, result, metaTypeProvider);
        } else if (YamlMetaTypeCompletionProviderBase.isOfType(position, YAMLTokenTypes.SCALAR_KEY) && position.getParent() instanceof YAMLKeyValue) {
            this.processUpdatedKey(params, result, metaTypeProvider);
        }
    }

    private void processUpdatedKey(@NotNull CompletionParameters params, @NotNull CompletionResultSet result, YamlMetaTypeProvider metaTypeProvider) {
        YamlMetaTypeProvider.MetaTypeProxy meta;
        if (params == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(3);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(4);
        }
        if ((meta = metaTypeProvider.getMetaTypeProxy(params.getPosition().getParent())) != null) {
            this.addKeyCompletions(params, metaTypeProvider, meta, result, params.getPosition());
        }
    }

    private void processValueOrInsertedKey(@NotNull CompletionParameters params, @NotNull CompletionResultSet result, YamlMetaTypeProvider metaTypeProvider) {
        YAMLScalar insertedScalar;
        if (params == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(5);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(6);
        }
        if ((insertedScalar = (YAMLScalar)params.getPosition().getParent()).getTextRange().getStartOffset() < params.getOffset()) {
            int positionOffset = params.getOffset() - insertedScalar.getTextRange().getStartOffset();
            assert (positionOffset > 0);
            String combinedText = insertedScalar.getText();
            if (positionOffset >= combinedText.length()) {
                return;
            }
            if (combinedText.charAt(positionOffset - 1) == ':') {
                YamlMetaTypeCompletionProviderBase.trace("Completion rejected: misplaced just after key position : " + YamlDebugUtil.getDebugInfo(params.getPosition()));
            }
        }
        YamlMetaTypeProvider.MetaTypeProxy meta = metaTypeProvider.getMetaTypeProxy((PsiElement)insertedScalar);
        YamlMetaTypeCompletionProviderBase.trace("meta: " + meta);
        if (meta == null) {
            return;
        }
        YamlMetaType metaType = meta.getMetaType();
        if (insertedScalar.getParent() instanceof YAMLKeyValue) {
            boolean hadScalarLookups;
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)insertedScalar);
            if (YamlMetaTypeCompletionProviderBase.isOfType(prevSibling, YAMLTokenTypes.COLON)) {
                prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)prevSibling);
            }
            if (YamlMetaTypeCompletionProviderBase.isOfType(prevSibling, YAMLTokenTypes.SCALAR_KEY) && (hadScalarLookups = YamlMetaTypeCompletionProviderBase.addValueCompletions(insertedScalar, metaType, result, Collections.emptyMap(), params))) {
                return;
            }
        }
        if (insertedScalar.getParent() instanceof YAMLSequenceItem) {
            YAMLSequenceItem currentItem = (YAMLSequenceItem)insertedScalar.getParent();
            List siblingItems = Optional.ofNullable(currentItem.getParent()).filter(YAMLSequence.class::isInstance).map(YAMLSequence.class::cast).map(YAMLSequence::getItems).orElse(Collections.emptyList());
            Map<String, YAMLScalar> siblingValues = siblingItems.stream().filter(i -> i.getKeysValues().isEmpty()).filter(i -> !currentItem.equals(i)).map(YAMLSequenceItem::getValue).filter(Objects::nonNull).filter(YAMLScalar.class::isInstance).map(YAMLScalar.class::cast).collect(Collectors.toMap(scalar -> scalar.getText().trim(), scalar -> scalar, (oldVal, newVal) -> newVal));
            boolean hadScalarInSequenceLookups = YamlMetaTypeCompletionProviderBase.addValueCompletions(insertedScalar, metaType, result, siblingValues, params);
            if (hadScalarInSequenceLookups && !(metaType instanceof YamlAnyOfType)) {
                return;
            }
        }
        if (!(metaType instanceof YamlScalarType)) {
            this.addKeyCompletions(params, metaTypeProvider, meta, result, (PsiElement)insertedScalar);
        }
    }

    private void addKeyCompletions(@NotNull CompletionParameters params, @NotNull YamlMetaTypeProvider metaTypeProvider, @NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull CompletionResultSet result, @NotNull PsiElement insertedScalar) {
        boolean needsSequenceItemMark;
        YamlMetaType metaType;
        if (params == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(7);
        }
        if (metaTypeProvider == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(8);
        }
        if (meta == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(9);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(10);
        }
        if (insertedScalar == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(11);
        }
        if ((metaType = meta.getMetaType()) instanceof YamlScalarType) {
            return;
        }
        YAMLValue metaOwner = metaTypeProvider.getMetaOwner(insertedScalar);
        if (metaOwner instanceof YAMLScalar && metaOwner.getParent() instanceof YAMLMapping) {
            metaOwner = (YAMLValue)metaOwner.getParent();
        }
        YAMLMapping existingMapping = (YAMLMapping)ObjectUtils.tryCast((Object)metaOwner, YAMLMapping.class);
        Collection existingPairs = Optional.ofNullable(existingMapping).map(YAMLMapping::getKeyValues).orElse(Collections.emptyList());
        Map<String, YAMLKeyValue> existingByKey = existingPairs.stream().collect(Collectors.toMap(kv -> kv.getKeyText().trim(), kv -> kv, (oldValue, newValue) -> oldValue));
        List<Field> suggestedFields = metaType.computeKeyCompletions(existingMapping);
        List filteredList = ContainerUtil.filter(suggestedFields, childField -> !existingByKey.containsKey(childField.getName()) && childField.isEditable());
        boolean bl = needsSequenceItemMark = existingPairs.isEmpty() && YamlMetaTypeCompletionProviderBase.needsSequenceItem(meta.getField());
        if (params.getCompletionType() == CompletionType.SMART) {
            String text = insertedScalar.getText();
            int caretPos = text.indexOf(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED);
            String pattern = StringUtil.toLowerCase((String)(caretPos >= 0 ? text.substring(0, caretPos) : text));
            Collection<List<Field>> paths = YamlMetaTypeCompletionProviderBase.collectPaths(filteredList, pattern.length() > 0 ? 10 : 1);
            for (List<Field> pathToInsert : paths) {
                Field lastField = pathToInsert.get(pathToInsert.size() - 1);
                if (!StringUtil.toLowerCase((String)lastField.getName()).startsWith(pattern)) continue;
                YamlMetaType.ForcedCompletionPath completionPath = YamlMetaType.ForcedCompletionPath.forDeepCompletion(pathToInsert);
                LookupElementBuilder l = LookupElementBuilder.create((Object)completionPath, (String)completionPath.getName()).withIcon(lastField.getLookupIcon()).withInsertHandler((InsertHandler)new YamlKeyInsertHandlerImpl(needsSequenceItemMark, pathToInsert.get(0))).withTypeText(lastField.getDefaultType().getDisplayName(), true).withStrikeoutness(lastField.isDeprecated());
                result.addElement((LookupElement)l);
            }
        } else {
            filteredList.stream().filter(childField -> !existingByKey.containsKey(childField.getName())).forEach(childField -> {
                List lookups = ContainerUtil.filter(childField.getKeyLookups(metaType, insertedScalar), l -> !existingByKey.containsKey(l.getLookupString()));
                this.registerBasicKeyCompletion(result, lookups, new YamlKeyInsertHandlerImpl(needsSequenceItemMark, (Field)childField));
            });
        }
    }

    private static boolean needsSequenceItem(@NotNull Field parentField) {
        if (parentField == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(12);
        }
        return parentField.isMany() && !parentField.hasRelationSpecificType(Field.Relation.OBJECT_CONTENTS);
    }

    protected void registerBasicKeyCompletion(@NotNull CompletionResultSet result, @NotNull List<LookupElementBuilder> lookups, @NotNull InsertHandler<LookupElement> insertHandler) {
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(13);
        }
        if (lookups == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(14);
        }
        if (insertHandler == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(15);
        }
        if (!lookups.isEmpty()) {
            lookups.stream().map(l -> l.withInsertHandler(insertHandler)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        }
    }

    @NotNull
    private static Collection<List<Field>> collectPaths(@NotNull Collection<? extends Field> fields, int deepness) {
        if (fields == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(16);
        }
        ArrayList<List<Field>> result = new ArrayList<List<Field>>();
        YamlMetaTypeCompletionProviderBase.doCollectPathsRec(fields, Collections.emptyList(), result, deepness);
        ArrayList<List<Field>> arrayList = result;
        if (arrayList == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static void doCollectPathsRec(@NotNull Collection<? extends Field> fields, @NotNull List<? extends Field> currentPath, @NotNull Collection<? super List<Field>> result, int deepness) {
        if (fields == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(18);
        }
        if (currentPath == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(19);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(20);
        }
        if (currentPath.size() >= deepness) {
            return;
        }
        fields.stream().filter(field -> !field.isAnyNameAllowed()).forEach(field -> {
            List fieldPath = StreamEx.of((Collection)currentPath).append(field).toList();
            result.add(fieldPath);
            YamlMetaType metaType = field.getType(field.getDefaultRelation());
            if (metaType instanceof YamlMetaClass) {
                YamlMetaTypeCompletionProviderBase.doCollectPathsRec(ContainerUtil.filter(((YamlMetaClass)metaType).getFeatures(), Field::isEditable), fieldPath, result, deepness);
            }
        });
    }

    private static boolean addValueCompletions(@NotNull YAMLScalar insertedScalar, @NotNull YamlMetaType meta, @NotNull CompletionResultSet result, @NotNull Map<String, YAMLScalar> siblings, @NotNull CompletionParameters completionParameters) {
        if (insertedScalar == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(21);
        }
        if (meta == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(22);
        }
        if (result == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(23);
        }
        if (siblings == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(24);
        }
        if (completionParameters == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(25);
        }
        List<? extends LookupElement> lookups = meta.getValueLookups(insertedScalar, new CompletionContextImpl(completionParameters, result));
        lookups.stream().filter(lookup -> !siblings.containsKey(lookup.getLookupString())).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
        return !lookups.isEmpty();
    }

    private static void trace(String text) {
        LOG.trace(text);
    }

    private static boolean isOfType(@Nullable PsiElement psi, IElementType ... types) {
        if (types == null) {
            YamlMetaTypeCompletionProviderBase.$$$reportNull$$$0(26);
        }
        if (psi == null) {
            return false;
        }
        IElementType actual = psi.getNode().getElementType();
        return ContainerUtil.exists((Object[])types, actual::equals);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 10: 
            case 13: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaTypeProvider";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedScalar";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentField";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookups";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertHandler";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeCompletionProviderBase";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblings";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionParameters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeCompletionProviderBase";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processUpdatedKey";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processValueOrInsertedKey";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addKeyCompletions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "needsSequenceItem";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerBasicKeyCompletion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
            case 17: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doCollectPathsRec";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addValueCompletions";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompletionContextImpl
    implements CompletionContext {
        private final CompletionType myType;
        private final int myInvocationCount;
        private final String myPrefix;
        private final CompletionResultSet myCompletionResultSet;

        CompletionContextImpl(CompletionParameters completionParameters, CompletionResultSet completionResultSet) {
            this.myType = completionParameters.getCompletionType();
            this.myInvocationCount = completionParameters.getInvocationCount();
            this.myPrefix = CompletionContextImpl.computeCompletionPrefix(completionParameters);
            this.myCompletionResultSet = completionResultSet;
        }

        @Override
        @NotNull
        public CompletionType getCompletionType() {
            CompletionType completionType = this.myType;
            if (completionType == null) {
                CompletionContextImpl.$$$reportNull$$$0(0);
            }
            return completionType;
        }

        @Override
        public int getInvocationCount() {
            return this.myInvocationCount;
        }

        @Override
        @NotNull
        public CompletionResultSet getCompletionResultSet() {
            CompletionResultSet completionResultSet = this.myCompletionResultSet;
            if (completionResultSet == null) {
                CompletionContextImpl.$$$reportNull$$$0(1);
            }
            return completionResultSet;
        }

        @Override
        @NotNull
        public String getCompletionPrefix() {
            String string = this.myPrefix;
            if (string == null) {
                CompletionContextImpl.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private static String computeCompletionPrefix(CompletionParameters parameters) {
            PsiElement position = parameters.getPosition();
            String textWithInsertedPart = parameters.getPosition().getText();
            int positionInRange = parameters.getOffset() - position.getTextRange().getStartOffset();
            if (positionInRange < 0) {
                positionInRange = 0;
            } else if (positionInRange > textWithInsertedPart.length()) {
                positionInRange = textWithInsertedPart.length();
            }
            boolean startsWithQuote = ((Object)((Object)YAMLElementTypes.SCALAR_QUOTED_STRING)).equals(position.getParent().getNode().getElementType());
            String string = textWithInsertedPart.substring(startsWithQuote ? "'".length() : 0, positionInRange);
            if (string == null) {
                CompletionContextImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/yaml/meta/impl/YamlMetaTypeCompletionProviderBase$CompletionContextImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionResultSet";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompletionPrefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeCompletionPrefix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

