/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.collaboration.auth.Account;
import com.intellij.collaboration.auth.ui.AccountsListModel;
import com.intellij.collaboration.auth.ui.AccountsListModelBase;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.awt.RelativePoint;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsHost;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00042\u00020\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsListModel;", "Lcom/intellij/collaboration/auth/ui/AccountsListModelBase;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "Lcom/intellij/collaboration/auth/ui/AccountsListModel$WithDefault;", "Lorg/jetbrains/plugins/github/authentication/ui/GHAccountsHost;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "kotlin.jvm.PlatformType", "defaultAccount", "getDefaultAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "setDefaultAccount", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;)V", "addAccount", "", "parentComponent", "Ljavax/swing/JComponent;", "point", "Lcom/intellij/ui/awt/RelativePoint;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "login", "token", "editAccount", "account", "isAccountUnique", "", "intellij.vcs.github"})
public final class GHAccountsListModel
extends AccountsListModelBase<GithubAccount, String>
implements AccountsListModel.WithDefault<GithubAccount, String>,
GHAccountsHost {
    private final ActionManager actionManager;
    @Nullable
    private GithubAccount defaultAccount;
    private final Project project;

    @Nullable
    public GithubAccount getDefaultAccount() {
        return this.defaultAccount;
    }

    public void setDefaultAccount(@Nullable GithubAccount githubAccount) {
        this.defaultAccount = githubAccount;
    }

    public void addAccount(@NotNull JComponent parentComponent, @Nullable RelativePoint point) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        AnAction anAction = this.actionManager.getAction("Github.Accounts.AddAccount");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup group = (ActionGroup)anAction;
        ActionPopupMenu actionPopupMenu = this.actionManager.createActionPopupMenu("unknown", group);
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"actionManager.createActi\u2026ionPlaces.UNKNOWN, group)");
        ActionPopupMenu popup = actionPopupMenu;
        RelativePoint relativePoint = point;
        if (relativePoint == null) {
            RelativePoint relativePoint2 = RelativePoint.getCenterOf((JComponent)parentComponent);
            relativePoint = relativePoint2;
            Intrinsics.checkNotNullExpressionValue((Object)relativePoint2, (String)"RelativePoint.getCenterOf(parentComponent)");
        }
        RelativePoint actualPoint = relativePoint;
        popup.setTargetComponent(parentComponent);
        JBPopupMenu.showAt((RelativePoint)actualPoint, (JPopupMenu)popup.getComponent());
    }

    public void editAccount(@NotNull JComponent parentComponent, @NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        GHAccountAuthData authData2 = GithubAuthenticationManager.Companion.getInstance().login$intellij_vcs_github(this.project, parentComponent, new GHLoginRequest(null, null, account.getServer(), false, account.getName(), false, false, null, 235, null));
        if (authData2 == null) {
            return;
        }
        String string = authData2.getLogin();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authData.login");
        account.setName(string);
        this.update((Account)authData2.getAccount(), authData2.getToken());
    }

    @Override
    public void addAccount(@NotNull GithubServerPath server, @NotNull String login2, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        GithubAccount account = GHAccountManager.Companion.createAccount(login2, server);
        this.add((Account)account, token);
    }

    @Override
    public boolean isAccountUnique(@NotNull String login2, @NotNull GithubServerPath server) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            List list2 = this.getAccountsListModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"accountsListModel.items");
            Iterable $this$none$iv = list2;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GithubAccount it = (GithubAccount)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)login2) && it.getServer().equals(server, true))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public GHAccountsListModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.actionManager = ActionManager.getInstance();
    }
}

