/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.FileStateKt;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.util.Processor;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.Decompressor;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"SETTINGS_SYNC_LOCAL_SERVER_PATH_PROPERTY", "", "SETTINGS_SYNC_SNAPSHOT", "SETTINGS_SYNC_SNAPSHOT_ZIP", "extractZipFile", "Lcom/intellij/settingsSync/SettingsSnapshot;", "zipFile", "Ljava/nio/file/Path;", "prepareTempZipFile", "snapshot", "intellij.settingsSync"})
public final class LocalDirSettingsSyncRemoteCommunicatorKt {
    @NotNull
    public static final String SETTINGS_SYNC_LOCAL_SERVER_PATH_PROPERTY = "idea.settings.sync.local.server.path";
    @NotNull
    public static final String SETTINGS_SYNC_SNAPSHOT = "settings.sync.snapshot";
    @NotNull
    public static final String SETTINGS_SYNC_SNAPSHOT_ZIP = "settings.sync.snapshot.zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path prepareTempZipFile(@NotNull SettingsSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        File file = FileUtil.createTempFile((String)SETTINGS_SYNC_SNAPSHOT_ZIP, null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\u2026_SYNC_SNAPSHOT_ZIP, null)");
        File file2 = file;
        Closeable closeable = (Closeable)new Compressor.Zip(file2);
        Throwable throwable = null;
        try {
            Compressor.Zip zip = (Compressor.Zip)closeable;
            boolean bl = false;
            for (FileState fileState : snapshot.getFileStates()) {
                byte[] byArray;
                if (fileState instanceof FileState.Modified) {
                    byArray = ((FileState.Modified)fileState).getContent();
                } else {
                    String string = "DELETED";
                    Charset charset = Charsets.UTF_8;
                    byte[] byArray2 = string.getBytes(charset);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                }
                byte[] content = byArray;
                zip.addFile(fileState.getFile(), content);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
        return path;
    }

    @NotNull
    public static final SettingsSnapshot extractZipFile(@NotNull Path zipFile2) {
        Intrinsics.checkNotNullParameter((Object)zipFile2, (String)"zipFile");
        File file = FileUtil.createTempDirectory((String)"settings.sync.updates", null);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempDirec\u2026ings.sync.updates\", null)");
        File tempDir = file;
        new Decompressor.Zip(zipFile2).extract(tempDir);
        Set fileStates = new LinkedHashSet();
        FileUtil.processFilesRecursively((File)tempDir, (Processor)new Processor(fileStates, tempDir){
            final /* synthetic */ Set $fileStates;
            final /* synthetic */ File $tempDir;

            public final boolean process(File it) {
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                if (file.isFile()) {
                    Path path = it.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
                    Path path2 = this.$tempDir.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"tempDir.toPath()");
                    this.$fileStates.add(FileStateKt.getFileStateFromFileWithDeletedMarker(path, path2));
                }
                return true;
            }
            {
                this.$fileStates = set;
                this.$tempDir = file;
            }
        });
        return new SettingsSnapshot(fileStates);
    }
}

