/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class OpenSshConfigFile
implements SshConfigStore {
    private static final String DEFAULT_NAME = "";
    private final File home;
    private final File configFile;
    private final String localUserName;
    private Instant lastModified;
    private State state;

    public OpenSshConfigFile(@NonNull File home, @NonNull File config, @NonNull String localUserName) {
        this.home = home;
        this.configFile = config;
        this.localUserName = localUserName;
        this.state = new State();
    }

    @Override
    @NonNull
    public HostEntry lookup(@NonNull String hostName, int port, String userName) {
        State cache = this.refresh();
        String cacheKey = this.toCacheKey(hostName, port, userName);
        HostEntry h = cache.hosts.get(cacheKey);
        if (h != null) {
            return h;
        }
        HostEntry fullConfig = new HostEntry();
        fullConfig.merge(cache.entries.get(DEFAULT_NAME));
        for (Map.Entry<String, HostEntry> e : cache.entries.entrySet()) {
            String pattern = e.getKey();
            if (!OpenSshConfigFile.isHostMatch(pattern, hostName)) continue;
            fullConfig.merge(e.getValue());
        }
        fullConfig.substitute(hostName, port, userName, this.localUserName, this.home);
        cache.hosts.put(cacheKey, fullConfig);
        return fullConfig;
    }

    @NonNull
    private String toCacheKey(@NonNull String hostName, int port, String userName) {
        String key = hostName;
        if (port > 0) {
            key = String.valueOf(key) + ':' + Integer.toString(port);
        }
        if (userName != null && !userName.isEmpty()) {
            key = String.valueOf(userName) + '@' + key;
        }
        return key;
    }

    private synchronized State refresh() {
        Instant mtime = FS.DETECTED.lastModifiedInstant(this.configFile);
        if (!mtime.equals(this.lastModified)) {
            State newState = new State();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader br = Files.newBufferedReader(this.configFile.toPath(), StandardCharsets.UTF_8);){
                    newState.entries = this.parse(br);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            this.lastModified = mtime;
            this.state = newState;
        }
        return this.state;
    }

    private Map<String, HostEntry> parse(BufferedReader reader) throws IOException {
        String line;
        LinkedHashMap<String, HostEntry> entries = new LinkedHashMap<String, HostEntry>();
        ArrayList<HostEntry> current = new ArrayList<HostEntry>(4);
        HostEntry defaults = new HostEntry();
        current.add(defaults);
        entries.put(DEFAULT_NAME, defaults);
        while ((line = reader.readLine()) != null) {
            String argValue;
            int i = line.indexOf(35);
            if (i >= 0) {
                line = line.substring(0, i);
            }
            if ((line = line.trim()).isEmpty()) continue;
            String[] parts = line.split("[ \t]*[= \t]", 2);
            String keyword = OpenSshConfigFile.dequote(parts[0].trim());
            String string = argValue = parts.length > 1 ? parts[1].trim() : DEFAULT_NAME;
            if (StringUtils.equalsIgnoreCase("Host", keyword)) {
                current.clear();
                for (String name : this.parseList(argValue)) {
                    if (name == null || name.isEmpty()) continue;
                    HostEntry c = (HostEntry)entries.get(name);
                    if (c == null) {
                        c = new HostEntry();
                        entries.put(name, c);
                    }
                    current.add(c);
                }
                continue;
            }
            if (current.isEmpty()) continue;
            if (HostEntry.isListKey(keyword)) {
                List<String> args = this.validate(keyword, this.parseList(argValue));
                for (HostEntry entry : current) {
                    entry.setValue(keyword, args);
                }
                continue;
            }
            if (argValue.isEmpty()) continue;
            argValue = this.validate(keyword, OpenSshConfigFile.dequote(argValue));
            for (HostEntry entry : current) {
                entry.setValue(keyword, argValue);
            }
        }
        return entries;
    }

    private List<String> parseList(String argument) {
        ArrayList<String> result2 = new ArrayList<String>(4);
        int start = 0;
        int length = argument.length();
        while (start < length) {
            int stop;
            if (Character.isSpaceChar(argument.charAt(start))) {
                ++start;
                continue;
            }
            if (argument.charAt(start) == '\"') {
                if ((stop = argument.indexOf(34, ++start)) < start) break;
                result2.add(argument.substring(start, stop));
                start = stop + 1;
                continue;
            }
            stop = start + 1;
            while (stop < length && !Character.isSpaceChar(argument.charAt(stop))) {
                ++stop;
            }
            result2.add(argument.substring(start, stop));
            start = stop + 1;
        }
        return result2;
    }

    protected String validate(String key, String value) {
        if (String.CASE_INSENSITIVE_ORDER.compare(key, "PreferredAuthentications") == 0) {
            return OpenSshConfigFile.stripWhitespace(value);
        }
        return value;
    }

    protected List<String> validate(String key, List<String> value) {
        return value;
    }

    private static boolean isHostMatch(String pattern, String name) {
        if (pattern.startsWith("!")) {
            return !OpenSshConfigFile.patternMatchesHost(pattern.substring(1), name);
        }
        return OpenSshConfigFile.patternMatchesHost(pattern, name);
    }

    private static boolean patternMatchesHost(String pattern, String name) {
        if (pattern.indexOf(42) >= 0 || pattern.indexOf(63) >= 0) {
            FileNameMatcher fn;
            try {
                fn = new FileNameMatcher(pattern, null);
            }
            catch (InvalidPatternException e) {
                return false;
            }
            fn.append(name);
            return fn.isMatch();
        }
        return pattern.equals(name);
    }

    private static String dequote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static String stripWhitespace(String value) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            if (!Character.isSpaceChar(value.charAt(i))) {
                b.append(value.charAt(i));
            }
            ++i;
        }
        return b.toString();
    }

    private static File toFile(String path, File home) {
        if (path.startsWith("~/") || path.startsWith("~" + File.separator)) {
            return new File(home, path.substring(2));
        }
        File ret = new File(path);
        if (ret.isAbsolute()) {
            return ret;
        }
        return new File(home, path);
    }

    public static int positive(String value) {
        if (value != null) {
            try {
                return Integer.parseUnsignedInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean flag(String value) {
        if (value == null) {
            return false;
        }
        return "yes".equals(value) || "on".equals(value) || "true".equals(value);
    }

    public String getLocalUserName() {
        return this.localUserName;
    }

    public String toString() {
        return "OpenSshConfig [home=" + this.home + ", configFile=" + this.configFile + ", lastModified=" + this.lastModified + ", state=" + this.state + "]";
    }

    public static class HostEntry
    implements SshConfigStore.HostConfig {
        private static final Set<String> MULTI_KEYS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        private static final Set<String> LIST_KEYS;
        private static final Map<String, String> ALIASES;
        private Map<String, String> options;
        private Map<String, List<String>> multiOptions;
        private Map<String, List<String>> listOptions;

        static {
            MULTI_KEYS.add("CertificateFile");
            MULTI_KEYS.add("IdentityFile");
            MULTI_KEYS.add("LocalForward");
            MULTI_KEYS.add("RemoteForward");
            MULTI_KEYS.add("SendEnv");
            LIST_KEYS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            LIST_KEYS.add("CanonicalDomains");
            LIST_KEYS.add("GlobalKnownHostsFile");
            LIST_KEYS.add("SendEnv");
            LIST_KEYS.add("UserKnownHostsFile");
            ALIASES = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            ALIASES.put("PubkeyAcceptedKeyTypes", "PubkeyAcceptedAlgorithms");
        }

        private static String toKey(String key) {
            String k = ALIASES.get(key);
            return k != null ? k : key;
        }

        @Override
        public String getValue(String key) {
            String result2;
            String k = HostEntry.toKey(key);
            String string = result2 = this.options != null ? this.options.get(k) : null;
            if (result2 == null) {
                List<String> values;
                List<String> list = values = this.listOptions != null ? this.listOptions.get(k) : null;
                if (values == null) {
                    List<String> list2 = values = this.multiOptions != null ? this.multiOptions.get(k) : null;
                }
                if (values != null && !values.isEmpty()) {
                    result2 = values.get(0);
                }
            }
            return result2;
        }

        @Override
        public List<String> getValues(String key) {
            List<String> values;
            String k = HostEntry.toKey(key);
            List<String> list = values = this.listOptions != null ? this.listOptions.get(k) : null;
            if (values == null) {
                List<String> list2 = values = this.multiOptions != null ? this.multiOptions.get(k) : null;
            }
            if (values == null || values.isEmpty()) {
                return new ArrayList<String>();
            }
            return new ArrayList<String>(values);
        }

        public void setValue(String key, String value) {
            String k = HostEntry.toKey(key);
            if (value == null) {
                if (this.multiOptions != null) {
                    this.multiOptions.remove(k);
                }
                if (this.listOptions != null) {
                    this.listOptions.remove(k);
                }
                if (this.options != null) {
                    this.options.remove(k);
                }
                return;
            }
            if (MULTI_KEYS.contains(k)) {
                List<String> values;
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if ((values = this.multiOptions.get(k)) == null) {
                    values = new ArrayList<String>(4);
                    this.multiOptions.put(k, values);
                }
                values.add(value);
            } else {
                if (this.options == null) {
                    this.options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                }
                if (!this.options.containsKey(k)) {
                    this.options.put(k, value);
                }
            }
        }

        public void setValue(String key, List<String> values) {
            if (values.isEmpty()) {
                return;
            }
            String k = HostEntry.toKey(key);
            if (MULTI_KEYS.contains(k)) {
                List<String> items;
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if ((items = this.multiOptions.get(k)) == null) {
                    items = new ArrayList<String>(values);
                    this.multiOptions.put(k, items);
                } else {
                    items.addAll(values);
                }
            } else {
                if (this.listOptions == null) {
                    this.listOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if (!this.listOptions.containsKey(k)) {
                    this.listOptions.put(k, values);
                }
            }
        }

        public static boolean isListKey(String key) {
            return LIST_KEYS.contains(HostEntry.toKey(key));
        }

        void merge(HostEntry entry) {
            if (entry == null) {
                return;
            }
            if (entry.options != null) {
                if (this.options == null) {
                    this.options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry2 : entry.options.entrySet()) {
                    if (this.options.containsKey(entry2.getKey())) continue;
                    this.options.put(entry2.getKey(), (String)entry2.getValue());
                }
            }
            if (entry.listOptions != null) {
                if (this.listOptions == null) {
                    this.listOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry3 : entry.listOptions.entrySet()) {
                    if (this.listOptions.containsKey(entry3.getKey())) continue;
                    this.listOptions.put(entry3.getKey(), (List)entry3.getValue());
                }
            }
            if (entry.multiOptions != null) {
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry4 : entry.multiOptions.entrySet()) {
                    List<String> values = this.multiOptions.get(entry4.getKey());
                    if (values == null) {
                        values = new ArrayList<String>((Collection)entry4.getValue());
                        this.multiOptions.put(entry4.getKey(), values);
                        continue;
                    }
                    values.addAll((Collection)entry4.getValue());
                }
            }
        }

        private List<String> substitute(List<String> values, String allowed, Replacer r) {
            ArrayList<String> result2 = new ArrayList<String>(values.size());
            for (String value : values) {
                result2.add(r.substitute(value, allowed));
            }
            return result2;
        }

        private List<String> replaceTilde(List<String> values, File home) {
            ArrayList<String> result2 = new ArrayList<String>(values.size());
            for (String value : values) {
                result2.add(OpenSshConfigFile.toFile(value, home).getPath());
            }
            return result2;
        }

        void substitute(String originalHostName, int port, String userName, String localUserName, File home) {
            List<String> values;
            String u;
            int p;
            int n = p = port >= 0 ? port : OpenSshConfigFile.positive(this.getValue("Port"));
            if (p < 0) {
                p = 22;
            }
            String string = u = userName != null && !userName.isEmpty() ? userName : this.getValue("User");
            if (u == null || u.isEmpty()) {
                u = localUserName;
            }
            Replacer r = new Replacer(originalHostName, p, u, localUserName, home);
            if (this.options != null) {
                String hostName = this.options.get("HostName");
                if (hostName == null || hostName.isEmpty()) {
                    this.options.put("HostName", originalHostName);
                } else {
                    hostName = r.substitute(hostName, "h");
                    this.options.put("HostName", hostName);
                    r.update('h', hostName);
                }
            }
            if (this.multiOptions != null) {
                values = this.multiOptions.get("IdentityFile");
                if (values != null) {
                    values = this.substitute(values, "dhlru", r);
                    values = this.replaceTilde(values, home);
                    this.multiOptions.put("IdentityFile", values);
                }
                if ((values = this.multiOptions.get("CertificateFile")) != null) {
                    values = this.substitute(values, "dhlru", r);
                    values = this.replaceTilde(values, home);
                    this.multiOptions.put("CertificateFile", values);
                }
            }
            if (this.listOptions != null && (values = this.listOptions.get("UserKnownHostsFile")) != null) {
                values = this.replaceTilde(values, home);
                this.listOptions.put("UserKnownHostsFile", values);
            }
            if (this.options != null) {
                String value = this.options.get("IdentityAgent");
                if (value != null) {
                    value = r.substitute(value, "dhlru");
                    value = OpenSshConfigFile.toFile(value, home).getPath();
                    this.options.put("IdentityAgent", value);
                }
                if ((value = this.options.get("ControlPath")) != null) {
                    value = r.substitute(value, "ChLlnpru");
                    value = OpenSshConfigFile.toFile(value, home).getPath();
                    this.options.put("ControlPath", value);
                }
                if ((value = this.options.get("LocalCommand")) != null) {
                    value = r.substitute(value, "CdhlnprTu");
                    this.options.put("LocalCommand", value);
                }
                if ((value = this.options.get("RemoteCommand")) != null) {
                    value = r.substitute(value, "Cdhlnpru");
                    this.options.put("RemoteCommand", value);
                }
                if ((value = this.options.get("ProxyCommand")) != null) {
                    value = r.substitute(value, "hpr");
                    this.options.put("ProxyCommand", value);
                }
            }
        }

        @Override
        @NonNull
        public Map<String, String> getOptions() {
            if (this.options == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.options);
        }

        @Override
        @NonNull
        public Map<String, List<String>> getMultiValuedOptions() {
            if (this.listOptions == null && this.multiOptions == null) {
                return Collections.emptyMap();
            }
            TreeMap<String, List<String>> allValues = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (this.multiOptions != null) {
                allValues.putAll(this.multiOptions);
            }
            if (this.listOptions != null) {
                allValues.putAll(this.listOptions);
            }
            return Collections.unmodifiableMap(allValues);
        }

        public String toString() {
            return "HostEntry [options=" + this.options + ", multiOptions=" + this.multiOptions + ", listOptions=" + this.listOptions + "]";
        }
    }

    private static class Replacer {
        private final Map<Character, String> replacements = new HashMap<Character, String>();

        public Replacer(String host, int port, String user, String localUserName, File home) {
            this.replacements.put(Character.valueOf('%'), "%");
            this.replacements.put(Character.valueOf('d'), home.getPath());
            this.replacements.put(Character.valueOf('h'), host);
            String localhost = SystemReader.getInstance().getHostname();
            this.replacements.put(Character.valueOf('l'), localhost);
            int period = localhost.indexOf(46);
            if (period > 0) {
                localhost = localhost.substring(0, period);
            }
            this.replacements.put(Character.valueOf('L'), localhost);
            this.replacements.put(Character.valueOf('n'), host);
            this.replacements.put(Character.valueOf('p'), Integer.toString(port));
            this.replacements.put(Character.valueOf('r'), user == null ? OpenSshConfigFile.DEFAULT_NAME : user);
            this.replacements.put(Character.valueOf('u'), localUserName);
            this.replacements.put(Character.valueOf('C'), this.substitute("%l%h%p%r", "hlpr"));
            this.replacements.put(Character.valueOf('T'), "NONE");
        }

        public void update(char key, String value) {
            this.replacements.put(Character.valueOf(key), value);
            if ("lhpr".indexOf(key) >= 0) {
                this.replacements.put(Character.valueOf('C'), this.substitute("%l%h%p%r", "hlpr"));
            }
        }

        public String substitute(String input, String allowed) {
            if (input == null || input.length() <= 1 || input.indexOf(37) < 0) {
                return input;
            }
            StringBuilder builder = new StringBuilder();
            int start = 0;
            int length = input.length();
            while (start < length) {
                int percent = input.indexOf(37, start);
                if (percent < 0 || percent + 1 >= length) {
                    builder.append(input.substring(start));
                    break;
                }
                String replacement = null;
                char ch = input.charAt(percent + 1);
                if (ch == '%' || allowed.indexOf(ch) >= 0) {
                    replacement = this.replacements.get(Character.valueOf(ch));
                }
                if (replacement == null) {
                    builder.append(input.substring(start, percent + 2));
                } else {
                    builder.append(input.substring(start, percent)).append(replacement);
                }
                start = percent + 2;
            }
            return builder.toString();
        }
    }

    private static class State {
        Map<String, HostEntry> entries = new LinkedHashMap<String, HostEntry>();
        Map<String, HostEntry> hosts = new HashMap<String, HostEntry>();

        private State() {
        }

        public String toString() {
            return "State [entries=" + this.entries + ", hosts=" + this.hosts + "]";
        }
    }
}

