/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtilRt;
import java.io.File;
import java.rmi.RemoteException;
import org.jetbrains.idea.maven.server.Maven3ServerGlobals;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RuntimeRemoteException;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.transfer.TransferResource;

public class Maven30TransferListenerAdapter
implements TransferListener {
    protected final MavenServerProgressIndicator myIndicator;

    public Maven30TransferListenerAdapter(MavenServerProgressIndicator indicator) {
        this.myIndicator = indicator;
    }

    private void checkCanceled() {
        try {
            if (this.myIndicator.isCanceled()) {
                throw new MavenProcessCanceledRuntimeException();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    private static String formatResourceName(TransferEvent event) {
        TransferResource resource = event.getResource();
        File file = resource.getFile();
        return (file == null ? resource.getResourceName() : file.getName()) + " [" + resource.getRepositoryUrl() + "]";
    }

    public void transferInitiated(TransferEvent event) {
        this.checkCanceled();
        try {
            this.myIndicator.startedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, Maven30TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
            this.myIndicator.setText2(Maven30TransferListenerAdapter.formatResourceName(event));
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.transferProgressed(event);
    }

    public void transferProgressed(TransferEvent event) {
        this.checkCanceled();
        TransferResource r = event.getResource();
        long totalLength = r.getContentLength();
        String sizeInfo = totalLength <= 0L ? StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + " / ?" : StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + " / " + StringUtilRt.formatFileSize((long)totalLength);
        try {
            this.myIndicator.setText2(Maven30TransferListenerAdapter.formatResourceName(event) + "  (" + sizeInfo + ')');
            if (totalLength <= 0L) {
                this.myIndicator.setIndeterminate(true);
            } else {
                this.myIndicator.setIndeterminate(false);
                this.myIndicator.setFraction((double)event.getTransferredBytes() / (double)totalLength);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferCorrupted(TransferEvent event) {
        try {
            this.myIndicator.setText2("Checksum failed: " + Maven30TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
            this.myIndicator.failedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, Maven30TransferListenerAdapter.formatResourceName(event), "Checksum failed", null);
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferSucceeded(TransferEvent event) {
        try {
            this.myIndicator.setText2("Finished (" + StringUtilRt.formatFileSize((long)event.getTransferredBytes()) + ") " + Maven30TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
            this.myIndicator.completedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, Maven30TransferListenerAdapter.formatResourceName(event));
            Maven3ServerGlobals.getDownloadListener().artifactDownloaded(event.getResource().getFile(), event.getResource().getResourceName());
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }

    public void transferFailed(TransferEvent event) {
        try {
            if (this.myIndicator.isCanceled()) {
                this.myIndicator.setText2("Canceling...");
                this.myIndicator.failedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, Maven30TransferListenerAdapter.formatResourceName(event), "Cancelled", null);
                return;
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
        try {
            this.myIndicator.setText2("Failed to download " + Maven30TransferListenerAdapter.formatResourceName(event));
            this.myIndicator.setIndeterminate(true);
            if (event.getException() != null) {
                String stackTrace = ExceptionUtilRt.getThrowableText((Throwable)event.getException(), (String)"com.intellij.");
                this.myIndicator.failedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, Maven30TransferListenerAdapter.formatResourceName(event), event.getException().getMessage(), stackTrace);
            } else {
                this.myIndicator.failedDownload(MavenServerProgressIndicator.ResolveType.DEPENDENCY, Maven30TransferListenerAdapter.formatResourceName(event), "Failed to download", null);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeRemoteException(e);
        }
    }
}

