/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.AllowedDuringStartupCollector;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class FUStateUsagesLogger
implements UsagesCollectorConsumer {
    private static final Logger LOG = Logger.getInstance(FUStateUsagesLogger.class);
    private static final Object LOCK = new Object();

    public static FUStateUsagesLogger create() {
        return new FUStateUsagesLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CompletableFuture<Void> logProjectStates(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(0);
        }
        if (indicator == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(1);
        }
        Object object = LOCK;
        // MONITORENTER : object
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        HashMap<String, StatisticsEventLogger> recorderLoggers = new HashMap<String, StatisticsEventLogger>();
        Iterator<ProjectUsagesCollector> iterator = ProjectUsagesCollector.getExtensions(this).iterator();
        while (true) {
            if (!iterator.hasNext()) {
                CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                // MONITOREXIT : object
                if (completableFuture != null) return completableFuture;
                FUStateUsagesLogger.$$$reportNull$$$0(2);
                return completableFuture;
            }
            ProjectUsagesCollector usagesCollector = iterator.next();
            if (!PluginInfoDetectorKt.getPluginInfo(usagesCollector.getClass()).isDevelopedByJetBrains()) {
                LOG.warn("Skip '" + usagesCollector.getGroupId() + "' because its registered in a third-party plugin");
                continue;
            }
            CancellablePromise<? extends Set<MetricEvent>> metrics = usagesCollector.getMetrics(project, indicator);
            futures.add(FUStateUsagesLogger.logMetricsOrError(project, recorderLoggers, usagesCollector, metrics));
        }
    }

    @NotNull
    public CompletableFuture<Void> logApplicationStates() {
        return this.logApplicationStates(false);
    }

    @NotNull
    public CompletableFuture<Void> logApplicationStatesOnStartup() {
        return this.logApplicationStates(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CompletableFuture<Void> logApplicationStates(boolean onStartup) {
        Object object = LOCK;
        // MONITORENTER : object
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        HashMap<String, StatisticsEventLogger> recorderLoggers = new HashMap<String, StatisticsEventLogger>();
        Iterator<ApplicationUsagesCollector> iterator = ApplicationUsagesCollector.getExtensions(this).iterator();
        while (true) {
            if (!iterator.hasNext()) {
                CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
                // MONITOREXIT : object
                if (completableFuture != null) return completableFuture;
                FUStateUsagesLogger.$$$reportNull$$$0(3);
                return completableFuture;
            }
            ApplicationUsagesCollector usagesCollector = iterator.next();
            if (onStartup && !(usagesCollector instanceof AllowedDuringStartupCollector)) continue;
            if (!PluginInfoDetectorKt.getPluginInfo(usagesCollector.getClass()).isDevelopedByJetBrains()) {
                LOG.warn("Skip '" + usagesCollector.getGroupId() + "' because its registered in a third-party plugin");
                continue;
            }
            Promise metrics = Promises.resolvedPromise(usagesCollector.getMetrics());
            futures.add(FUStateUsagesLogger.logMetricsOrError(null, recorderLoggers, usagesCollector, (Promise<? extends Set<MetricEvent>>)metrics));
        }
    }

    private static CompletableFuture<Void> logMetricsOrError(@Nullable Project project, @NotNull Map<String, StatisticsEventLogger> recorderLoggers, @NotNull FeatureUsagesCollector usagesCollector, @NotNull Promise<? extends Set<MetricEvent>> metrics) {
        String recorder;
        StatisticsEventLogger logger2;
        EventLogGroup group;
        if (recorderLoggers == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(4);
        }
        if (usagesCollector == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(5);
        }
        if (metrics == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(6);
        }
        if ((group = usagesCollector.getGroup()) == null) {
            group = new EventLogGroup(usagesCollector.getGroupId(), usagesCollector.getVersion());
        }
        if ((logger2 = recorderLoggers.get(recorder = group.getRecorder())) == null) {
            logger2 = StatisticsEventLogProviderUtil.getEventLogProvider(recorder).getLogger();
            recorderLoggers.put(recorder, logger2);
        }
        try {
            return FUStateUsagesLogger.logUsagesAsStateEvents(project, group, metrics, logger2);
        }
        catch (Throwable th) {
            if (project != null && project.isDisposed()) {
                return CompletableFuture.completedFuture(null);
            }
            FeatureUsageData data = new FeatureUsageData().addProject(project);
            return logger2.logAsync(group, "invocation.failed", data.build(), true);
        }
    }

    @NotNull
    private static CompletableFuture<Void> logUsagesAsStateEvents(@Nullable Project project, @NotNull EventLogGroup group, @NotNull Promise<? extends Set<MetricEvent>> metricsPromise, @NotNull StatisticsEventLogger logger2) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(7);
        }
        if (metricsPromise == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(8);
        }
        if (logger2 == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(9);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        metricsPromise.onSuccess(metrics -> {
            if (project != null && project.isDisposed()) {
                return;
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            if (!metrics.isEmpty()) {
                FeatureUsageData groupData = FUStateUsagesLogger.addProject(project);
                for (MetricEvent metric : metrics) {
                    FeatureUsageData data = FUStateUsagesLogger.mergeWithEventData(groupData, metric.getData());
                    Map<Object, Object> eventData = data != null ? data.build() : Collections.emptyMap();
                    futures.add(logger2.logAsync(group, metric.getEventId(), eventData, true));
                }
            }
            futures.add(logger2.logAsync(group, "invoked", new FeatureUsageData().addProject(project).build(), true));
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((result, throwable) -> future.complete(null));
        });
        CompletableFuture<Void> completableFuture = future;
        if (completableFuture == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    @Nullable
    private static FeatureUsageData addProject(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        return new FeatureUsageData().addProject(project);
    }

    @Nullable
    public static FeatureUsageData mergeWithEventData(@Nullable FeatureUsageData groupData, @Nullable FeatureUsageData data) {
        if (data == null) {
            return groupData;
        }
        FeatureUsageData newData = groupData == null ? new FeatureUsageData() : groupData.copy();
        newData.merge(data, "event_");
        return newData;
    }

    public static void logStateEvent(@NotNull EventLogGroup group, @NotNull String event, @NotNull FeatureUsageData data) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(11);
        }
        if (event == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(12);
        }
        if (data == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(13);
        }
        FeatureUsageLogger.INSTANCE.logState(group, event, data.build());
        FeatureUsageLogger.INSTANCE.logState(group, "invoked");
    }

    @NotNull
    public static CompletableFuture<Void> logStateEventsAsync(@NotNull EventLogGroup group, @NotNull Collection<MetricEvent> events) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(14);
        }
        if (events == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(15);
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        StatisticsEventLogger logger2 = StatisticsEventLogProviderUtil.getEventLogProvider(group.getRecorder()).getLogger();
        for (MetricEvent event : events) {
            futures.add(logger2.logAsync(group, event.getEventId(), event.getData().build(), true));
        }
        futures.add(logger2.logAsync(group, "invoked", true));
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        if (completableFuture == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    public static void logStateEvents(@NotNull EventLogGroup group, @NotNull Collection<MetricEvent> events) {
        if (group == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(17);
        }
        if (events == null) {
            FUStateUsagesLogger.$$$reportNull$$$0(18);
        }
        FUStateUsagesLogger.logStateEventsAsync(group, events);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUStateUsagesLogger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderLoggers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesCollector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metricsPromise";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStateUsagesLogger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "logProjectStates";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "logApplicationStates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "logUsagesAsStateEvents";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "logStateEventsAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logProjectStates";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "logMetricsOrError";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logUsagesAsStateEvents";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logStateEvent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "logStateEventsAsync";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logStateEvents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

