/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.BuiltinSpecialProperties;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a0\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002\u00a8\u0006\u0014"}, d2={"getPropertyNamesCandidatesByAccessorName", "", "Lorg/jetbrains/kotlin/name/Name;", "name", "possibleGetMethodNames", "propertyName", "propertyNameByGetMethodName", "methodName", "propertyNameBySetMethodName", "withIsPrefix", "", "propertyNameFromAccessorMethodName", "prefix", "", "removePrefix", "addPrefix", "propertyNamesByAccessorName", "propertyNamesBySetMethodName", "setMethodName", "getMethodName", "compiler.common.jvm"})
public final class PropertiesConventionUtilKt {
    @Nullable
    public static final Name propertyNameByGetMethodName(@NotNull Name methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Name name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "get", false, null, 12, null);
        if (name == null) {
            name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "is", false, null, 8, null);
        }
        return name;
    }

    @Nullable
    public static final Name propertyNameBySetMethodName(@NotNull Name methodName, boolean withIsPrefix) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "set", false, withIsPrefix ? "is" : null, 4, null);
    }

    @NotNull
    public static final List<Name> propertyNamesBySetMethodName(@NotNull Name methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Object[] objectArray = new Name[]{PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, false), PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, true)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @NotNull
    public static final List<Name> propertyNamesByAccessorName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object[] objectArray = new Name[]{PropertiesConventionUtilKt.propertyNameByGetMethodName(name), PropertiesConventionUtilKt.propertyNameBySetMethodName(name, true), PropertiesConventionUtilKt.propertyNameBySetMethodName(name, false)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final Name propertyNameFromAccessorMethodName(Name methodName, String prefix, boolean removePrefix, String addPrefix) {
        if (methodName.isSpecial()) {
            return null;
        }
        String string = methodName.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodName.identifier");
        String identifier = string;
        if (!StringsKt.startsWith$default((String)identifier, (String)prefix, (boolean)false, (int)2, null)) {
            return null;
        }
        if (identifier.length() == prefix.length()) {
            return null;
        }
        char c = identifier.charAt(prefix.length());
        boolean bl = 'a' <= c ? c < '{' : false;
        if (bl) {
            return null;
        }
        if (addPrefix != null) {
            if (_Assertions.ENABLED && !removePrefix) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return Name.identifier(addPrefix + StringsKt.removePrefix((String)identifier, (CharSequence)prefix));
        }
        if (!removePrefix) {
            return methodName;
        }
        String name = CapitalizeDecapitalizeKt.decapitalizeSmartForCompiler(StringsKt.removePrefix((String)identifier, (CharSequence)prefix), true);
        if (!Name.isValidIdentifier(name)) {
            return null;
        }
        return Name.identifier(name);
    }

    static /* synthetic */ Name propertyNameFromAccessorMethodName$default(Name name, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName(name, string, bl, string2);
    }

    @NotNull
    public static final List<Name> getPropertyNamesCandidatesByAccessorName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.asString()");
        String nameAsString = string;
        if (JvmAbi.isGetterName(nameAsString)) {
            return CollectionsKt.listOfNotNull((Object)PropertiesConventionUtilKt.propertyNameByGetMethodName(name));
        }
        if (JvmAbi.isSetterName(nameAsString)) {
            return PropertiesConventionUtilKt.propertyNamesBySetMethodName(name);
        }
        return BuiltinSpecialProperties.INSTANCE.getPropertyNameCandidatesBySpecialGetterName(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Name> possibleGetMethodNames(@NotNull Name propertyName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String identifier;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                if (propertyName.isSpecial()) {
                    return CollectionsKt.emptyList();
                }
                String string = propertyName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"propertyName.identifier");
                identifier = string;
                if (((CharSequence)identifier).length() == 0) {
                    return CollectionsKt.emptyList();
                }
                char firstChar = identifier.charAt(0);
                if (!Character.isJavaIdentifierStart(firstChar)) break block8;
                boolean bl = 'A' <= firstChar ? firstChar < '[' : false;
                if (!bl) break block9;
            }
            return CollectionsKt.emptyList();
        }
        ArrayList<Name> result2 = new ArrayList<Name>(3);
        if (JvmAbi.startsWithIsPrefix(identifier)) {
            result2.add(propertyName);
        }
        String capitalize1 = CapitalizeDecapitalizeKt.capitalizeAsciiOnly(identifier);
        String capitalize2 = CapitalizeDecapitalizeKt.capitalizeFirstWord(identifier, true);
        result2.add(Name.identifier("get" + capitalize1));
        if (!Intrinsics.areEqual((Object)capitalize2, (Object)capitalize1)) {
            result2.add(Name.identifier("get" + capitalize2));
        }
        Iterable iterable = result2;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Name it = (Name)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)PropertiesConventionUtilKt.propertyNameByGetMethodName(it), (Object)propertyName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Name setMethodName(@NotNull Name getMethodName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)getMethodName, (String)"getMethodName");
        String string2 = getMethodName.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethodName.identifier");
        String identifier = string2;
        if (StringsKt.startsWith$default((String)identifier, (String)"get", (boolean)false, (int)2, null)) {
            string = "get";
        } else if (StringsKt.startsWith$default((String)identifier, (String)"is", (boolean)false, (int)2, null)) {
            string = "is";
        } else {
            throw new IllegalArgumentException();
        }
        String prefix = string;
        Name name = Name.identifier("set" + StringsKt.removePrefix((String)identifier, (CharSequence)prefix));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(\"set\" + ident\u2026ier.removePrefix(prefix))");
        return name;
    }
}

