/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitProtectedBranchesKt;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lgit4idea/rebase/GitSingleCommitEditingAction;", "Lgit4idea/rebase/log/GitCommitEditingActionBase;", "Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "()V", "checkCommitsEditingAvailability", "", "commitEditingData", "createCommitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "repository", "Lgit4idea/repo/GitRepository;", "log", "Lcom/intellij/vcs/log/VcsLog;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "SingleCommitEditingData", "intellij.vcs.git"})
public abstract class GitSingleCommitEditingAction
extends GitCommitEditingActionBase<SingleCommitEditingData> {
    @Override
    @NotNull
    protected GitCommitEditingActionBase.CommitEditingDataCreationResult<SingleCommitEditingData> createCommitEditingData(@NotNull GitRepository repository, @NotNull VcsLog log, @NotNull VcsLogData logData, @NotNull VcsLogUi logUi2) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
        if (log.getSelectedCommits().size() != 1) {
            return new GitCommitEditingActionBase.CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        return new GitCommitEditingActionBase.CommitEditingDataCreationResult.Created<GitCommitEditingActionBase.MultipleCommitEditingData>(new SingleCommitEditingData(repository, log, logData, logUi2));
    }

    @Override
    @Nullable
    protected String checkCommitsEditingAvailability(@NotNull SingleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        VcsShortCommitDetails commit = commitEditingData.getSelectedCommit();
        VcsLogData vcsLogData = commitEditingData.getLogData();
        VirtualFile virtualFile = commit.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"commit.root");
        Hash hash = (Hash)commit.getId();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"commit.id");
        List<String> branches2 = GitCommitEditingActionBase.Companion.findContainingBranches(vcsLogData, virtualFile, hash);
        if (!branches2.contains("HEAD")) {
            return GitBundle.message("rebase.log.commit.editing.action.commit.not.in.head.error.text", new Object[0]);
        }
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(commitEditingData.getRepository(), (Collection<String>)branches2);
        if (protectedBranch != null) {
            return GitBundle.message("rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", protectedBranch);
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgit4idea/rebase/GitSingleCommitEditingAction$SingleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "repository", "Lgit4idea/repo/GitRepository;", "log", "Lcom/intellij/vcs/log/VcsLog;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsLog;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogUi;)V", "isHeadCommit", "", "()Z", "selectedCommit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "getSelectedCommit", "()Lcom/intellij/vcs/log/VcsShortCommitDetails;", "intellij.vcs.git"})
    public static final class SingleCommitEditingData
    extends GitCommitEditingActionBase.MultipleCommitEditingData {
        @NotNull
        private final VcsShortCommitDetails selectedCommit;
        private final boolean isHeadCommit;

        @NotNull
        public final VcsShortCommitDetails getSelectedCommit() {
            return this.selectedCommit;
        }

        public final boolean isHeadCommit() {
            return this.isHeadCommit;
        }

        public SingleCommitEditingData(@NotNull GitRepository repository, @NotNull VcsLog log, @NotNull VcsLogData logData, @NotNull VcsLogUi logUi2) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)log, (String)"log");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
            super(repository, log, logData, logUi2);
            this.selectedCommit = (VcsShortCommitDetails)CollectionsKt.first(this.getSelectedCommitList());
            this.isHeadCommit = Intrinsics.areEqual((Object)((Hash)this.selectedCommit.getId()).asString(), (Object)repository.getCurrentRevision());
        }
    }
}

