/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleConsoleFilterProvider
implements ConsoleFilterProvider {
    @Language(value="RegExp")
    @NonNls
    private static final String EXPRESSION = String.format("%s:%s(?::%s)?", "$FILE_PATH$", "$LINE$", "$COLUMN$");

    @NotNull
    public @NotNull Filter @NotNull [] getDefaultFilters(final @NotNull Project project) {
        if (project == null) {
            GradleConsoleFilterProvider.$$$reportNull$$$0(0);
        }
        Filter[] filterArray = new Filter[]{new GradleConsoleFilter(project), new RegexpFilter(project, EXPRESSION){
            private final CachedValue<@NotNull Boolean> myIsGradleProject;
            {
                super(arg0, arg1);
                this.myIsGradleProject = new CachedValueImpl(() -> CachedValueProvider.Result.create((Object)this.isGradleProject(), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)}));
            }

            @Nullable
            public Filter.Result applyFilter(@NotNull String line, int entireLength) {
                if (line == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!OSAgnosticPathUtil.isAbsolute((String)line)) {
                    return null;
                }
                if (!((Boolean)this.myIsGradleProject.getValue()).booleanValue()) {
                    return null;
                }
                Filter.Result result = super.applyFilter(line, entireLength);
                if (result == null) {
                    return null;
                }
                Pattern pattern = this.getPattern();
                Matcher matcher = pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
                if (!matcher.lookingAt()) {
                    return result;
                }
                int lineStart = entireLength - line.length();
                int start2 = lineStart + matcher.start();
                int end = lineStart + matcher.end();
                return new Filter.Result(start2, end, result.getFirstHyperlinkInfo());
            }

            private boolean isGradleProject() {
                return !GradleSettings.getInstance(project).getLinkedProjectsSettings().isEmpty();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/gradle/execution/GradleConsoleFilterProvider$1", "applyFilter"));
            }
        }};
        if (filterArray == null) {
            GradleConsoleFilterProvider.$$$reportNull$$$0(1);
        }
        return filterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleConsoleFilterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleConsoleFilterProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFilters";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

