/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleBuildParticipant;

public class GradleExecutionWorkspace
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getInstance(GradleExecutionWorkspace.class);
    @NotNull
    private final List<GradleBuildParticipant> myBuildParticipants = new ArrayList<GradleBuildParticipant>();
    private Map<String, List<Pair<DataNode<ModuleData>, IdeaModule>>> myModuleNameIndex = Collections.emptyMap();
    private Map<String, Pair<DataNode<ModuleData>, IdeaModule>> myModuleIdIndex;

    public void addBuildParticipant(GradleBuildParticipant participant) {
        this.myBuildParticipants.add(participant);
    }

    @NotNull
    public List<GradleBuildParticipant> getBuildParticipants() {
        List<GradleBuildParticipant> list2 = Collections.unmodifiableList(this.myBuildParticipants);
        if (list2 == null) {
            GradleExecutionWorkspace.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Nullable
    public ModuleData findModuleDataByArtifacts(Collection<File> artifacts) {
        GradleBuildParticipant buildParticipant;
        ModuleData result = null;
        Iterator<GradleBuildParticipant> iterator = this.myBuildParticipants.iterator();
        while (iterator.hasNext() && (result = (buildParticipant = iterator.next()).findModuleDataByArtifacts(artifacts)) == null) {
        }
        return result;
    }

    @Nullable
    public ModuleData findModuleDataByGradleModuleName(@NotNull String moduleName) {
        GradleBuildParticipant buildParticipant;
        if (moduleName == null) {
            GradleExecutionWorkspace.$$$reportNull$$$0(1);
        }
        ModuleData result = null;
        List<Pair<DataNode<ModuleData>, IdeaModule>> possiblePairs = this.myModuleNameIndex.get(moduleName);
        if (possiblePairs != null) {
            if (possiblePairs.size() == 1) {
                return (ModuleData)((DataNode)possiblePairs.get((int)0).first).getData();
            }
            if (possiblePairs.size() > 1) {
                LOG.warn("Detected duplicate idea module names during import. Use Gradle 4.0+ or consider renaming in Gradle: " + possiblePairs);
                return (ModuleData)((DataNode)possiblePairs.get((int)0).first).getData();
            }
        }
        Iterator<GradleBuildParticipant> iterator = this.myBuildParticipants.iterator();
        while (iterator.hasNext() && (result = (buildParticipant = iterator.next()).findModuleDataByName(moduleName)) == null) {
        }
        return result;
    }

    @Nullable
    @ApiStatus.Experimental
    public ModuleData findModuleDataByModuleId(@NotNull String moduleId) {
        Pair<DataNode<ModuleData>, IdeaModule> pair;
        if (moduleId == null) {
            GradleExecutionWorkspace.$$$reportNull$$$0(2);
        }
        if ((pair = this.myModuleIdIndex.get(moduleId)) != null) {
            return (ModuleData)((DataNode)pair.first).getData();
        }
        return null;
    }

    @Nullable
    public ModuleData findModuleDataByModule(@NotNull ProjectResolverContext resolverContext, @NotNull IdeaModule dependencyModule) {
        String id;
        Pair<DataNode<ModuleData>, IdeaModule> pair;
        if (resolverContext == null) {
            GradleExecutionWorkspace.$$$reportNull$$$0(3);
        }
        if (dependencyModule == null) {
            GradleExecutionWorkspace.$$$reportNull$$$0(4);
        }
        if ((pair = this.myModuleIdIndex.get(id = GradleProjectResolverUtil.getModuleId(resolverContext, dependencyModule))) != null) {
            return (ModuleData)((DataNode)pair.first).getData();
        }
        return null;
    }

    public void setModuleIdIndex(Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleIdIndex) {
        this.myModuleIdIndex = moduleIdIndex;
        this.myModuleNameIndex = moduleIdIndex.values().stream().collect(Collectors.groupingBy(val -> ((IdeaModule)val.second).getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleExecutionWorkspace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildParticipants";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleExecutionWorkspace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findModuleDataByGradleModuleName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findModuleDataByModuleId";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findModuleDataByModule";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

