/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@State(name="GradleLocalSettings", storages={@Storage(value="$CACHE_FILE$")})
public final class GradleLocalSettings
extends AbstractExternalSystemLocalSettings<MyState>
implements PersistentStateComponent<MyState> {
    public GradleLocalSettings(@NotNull Project project) {
        if (project == null) {
            GradleLocalSettings.$$$reportNull$$$0(0);
        }
        super(GradleConstants.SYSTEM_ID, project, (AbstractExternalSystemLocalSettings.State)new MyState());
    }

    @NotNull
    public static GradleLocalSettings getInstance(@NotNull Project project) {
        if (project == null) {
            GradleLocalSettings.$$$reportNull$$$0(1);
        }
        GradleLocalSettings gradleLocalSettings = (GradleLocalSettings)((Object)project.getService(GradleLocalSettings.class));
        if (gradleLocalSettings == null) {
            GradleLocalSettings.$$$reportNull$$$0(2);
        }
        return gradleLocalSettings;
    }

    @Nullable
    public String getGradleHome(String linkedProjectPath) {
        return (String)ContainerUtil.notNullize(((MyState)this.state).myGradleHomes).get(linkedProjectPath);
    }

    @Nullable
    public String getGradleVersion(String linkedProjectPath) {
        return (String)ContainerUtil.notNullize(((MyState)this.state).myGradleVersions).get(linkedProjectPath);
    }

    public void setGradleHome(@NotNull String linkedProjectPath, @NotNull String gradleHome2) {
        if (linkedProjectPath == null) {
            GradleLocalSettings.$$$reportNull$$$0(3);
        }
        if (gradleHome2 == null) {
            GradleLocalSettings.$$$reportNull$$$0(4);
        }
        if (((MyState)this.state).myGradleHomes == null) {
            ((MyState)this.state).myGradleHomes = new HashMap<String, String>();
        }
        ((MyState)this.state).myGradleHomes.put(linkedProjectPath, gradleHome2);
        if (((MyState)this.state).myGradleVersions == null) {
            ((MyState)this.state).myGradleVersions = new HashMap<String, String>();
        }
        ((MyState)this.state).myGradleVersions.put(linkedProjectPath, GradleInstallationManager.getGradleVersion(gradleHome2));
    }

    @ApiStatus.Internal
    @Nullable
    public String getGradleUserHome() {
        return ((MyState)this.state).myGradleUserHome;
    }

    @ApiStatus.Internal
    public void setGradleUserHome(@Nullable String gradleUserHome2) {
        ((MyState)this.state).myGradleUserHome = gradleUserHome2;
        GradleSystemSettings.getInstance().setServiceDirectoryPath(gradleUserHome2);
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        if (linkedProjectPathsToForget == null) {
            GradleLocalSettings.$$$reportNull$$$0(5);
        }
        super.forgetExternalProjects(linkedProjectPathsToForget);
        for (String path : linkedProjectPathsToForget) {
            if (((MyState)this.state).myGradleHomes != null) {
                ((MyState)this.state).myGradleHomes.remove(path);
            }
            if (((MyState)this.state).myGradleVersions == null) continue;
            ((MyState)this.state).myGradleVersions.remove(path);
        }
    }

    public void loadState(@NotNull MyState state) {
        if (state == null) {
            GradleLocalSettings.$$$reportNull$$$0(6);
        }
        super.loadState((AbstractExternalSystemLocalSettings.State)state);
        String serviceDirectoryPath = GradleSystemSettings.getInstance().getServiceDirectoryPath();
        if (state.myGradleUserHome == null && serviceDirectoryPath != null) {
            state.myGradleUserHome = serviceDirectoryPath;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleLocalSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleHome";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPathsToForget";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleLocalSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGradleHome";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forgetExternalProjects";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyState
    extends AbstractExternalSystemLocalSettings.State {
        public String myGradleUserHome;
        public Map<String, String> myGradleHomes;
        public Map<String, String> myGradleVersions;
    }
}

