/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/util/GradleEditorTabTitleProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabTitleProvider;", "()V", "getEditorTabTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.gradle.common"})
public final class GradleEditorTabTitleProvider
implements EditorTabTitleProvider {
    @Nullable
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!GradleConstants.KNOWN_GRADLE_FILES.contains(file.getName())) {
            return null;
        }
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile fileParent = virtualFile;
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(file);
        if (module == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ProjectFileIndex.getInst\u2026File(file) ?: return null");
        Module module2 = module;
        ExternalSystemModulePropertyManager manager = ExternalSystemModulePropertyManager.Companion.getInstance(module2);
        String string2 = manager.getExternalSystemId();
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"GradleConstants.SYSTEM_ID");
        if (Intrinsics.areEqual((Object)string2, (Object)projectSystemId.getId()) ^ true) {
            return null;
        }
        String string3 = manager.getLinkedProjectPath();
        if (string3 == null) {
            return null;
        }
        String projectPath = string3;
        if (FileUtil.pathsEqual((String)projectPath, (String)fileParent.getPath())) {
            return file.getName() + " (" + manager.getLinkedProjectId() + ")";
        }
        return null;
    }
}

