/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateBundlesListPanel;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;

public class TextMateSettingsUI
implements ConfigurableUi<TextMateSettings>,
Disposable {
    private final TextMateBundlesListPanel myBundlesListPanel = new TextMateBundlesListPanel();
    private final JPanel myBundlesList = this.myBundlesListPanel.createMainComponent();

    public TextMateSettingsUI() {
        Disposer.register((Disposable)this, (Disposable)this.myBundlesListPanel);
    }

    public void apply(@NotNull TextMateSettings settings) {
        TextMateSettings.TextMateSettingsState state;
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(0);
        }
        if ((state = settings.getState()) == null) {
            state = new TextMateSettings.TextMateSettingsState();
        }
        List<BundleConfigBean> newBundles = state.getBundles();
        settings.loadState(state);
        if (this.myBundlesListPanel.isModified(newBundles)) {
            state.setBundles(this.myBundlesListPanel.getState());
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, TextMateBundle.message("textmate.loading.bundles.title", new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TextMateService.getInstance().reloadEnabledBundles();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI$1", "run"));
                }
            });
        }
    }

    public void reset(@NotNull TextMateSettings settings) {
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(1);
        }
        this.myBundlesListPanel.setState(settings.getBundles());
    }

    public boolean isModified(@NotNull TextMateSettings settings) {
        TextMateSettings.TextMateSettingsState state;
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(2);
        }
        if ((state = settings.getState()) == null) {
            return !this.myBundlesListPanel.getState().isEmpty();
        }
        return this.myBundlesListPanel.isModified(state.getBundles());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myBundlesList;
        if (jPanel == null) {
            TextMateSettingsUI.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myBundlesList;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

