/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer;

import com.intellij.dev.psiViewer.PsiViewerExtension;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.ide.highlighter.ProjectFileType;
import com.intellij.ide.highlighter.WorkspaceFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiViewerSourceWrapper
implements Comparable<PsiViewerSourceWrapper> {
    final FileType myFileType;
    final PsiViewerExtension myExtension;

    private PsiViewerSourceWrapper(@NotNull FileType fileType) {
        if (fileType == null) {
            PsiViewerSourceWrapper.$$$reportNull$$$0(0);
        }
        this.myFileType = fileType;
        this.myExtension = null;
    }

    private PsiViewerSourceWrapper(@NotNull PsiViewerExtension extension) {
        if (extension == null) {
            PsiViewerSourceWrapper.$$$reportNull$$$0(1);
        }
        this.myFileType = null;
        this.myExtension = extension;
    }

    public String getText() {
        return this.myFileType != null ? this.myFileType.getName() + " file" : this.myExtension.getName();
    }

    @Nullable
    public Icon getIcon() {
        return this.myFileType != null ? this.myFileType.getIcon() : this.myExtension.getIcon();
    }

    @Override
    public int compareTo(@NotNull PsiViewerSourceWrapper o) {
        if (o == null) {
            PsiViewerSourceWrapper.$$$reportNull$$$0(2);
        }
        return this.getText().compareToIgnoreCase(o.getText());
    }

    @NotNull
    static List<PsiViewerSourceWrapper> getExtensionBasedWrappers() {
        List list = ContainerUtil.map((Collection)PsiViewerExtension.EP_NAME.getExtensionList(), el -> new PsiViewerSourceWrapper((PsiViewerExtension)el));
        if (list == null) {
            PsiViewerSourceWrapper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    static List<PsiViewerSourceWrapper> getFileTypeBasedWrappers() {
        HashSet<LanguageFileType> allFileTypes = new HashSet<LanguageFileType>();
        ArrayList<PsiViewerSourceWrapper> sourceWrappers = new ArrayList<PsiViewerSourceWrapper>();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        for (FileType fileType : allFileTypes) {
            if (!PsiViewerSourceWrapper.isAcceptableFileType(fileType)) continue;
            PsiViewerSourceWrapper wrapper = new PsiViewerSourceWrapper(fileType);
            sourceWrappers.add(wrapper);
        }
        ArrayList<PsiViewerSourceWrapper> arrayList = sourceWrappers;
        if (arrayList == null) {
            PsiViewerSourceWrapper.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static boolean isAcceptableFileType(FileType fileType) {
        return fileType != StdFileTypes.GUI_DESIGNER_FORM && fileType != ModuleFileType.INSTANCE && fileType != ProjectFileType.INSTANCE && fileType != WorkspaceFileType.INSTANCE && fileType != ArchiveFileType.INSTANCE && fileType != FileTypes.UNKNOWN && fileType != FileTypes.PLAIN_TEXT && !(fileType instanceof AbstractFileType) && !fileType.isBinary() && !fileType.isReadOnly();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dev/psiViewer/PsiViewerSourceWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dev/psiViewer/PsiViewerSourceWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionBasedWrappers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeBasedWrappers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

