"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_legend_size_1 = require("../../../../state/selectors/get_legend_size");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var crosshair_utils_1 = require("../../crosshair/crosshair_utils");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var get_cursor_band_1 = require("./get_cursor_band");
var get_projected_pointer_position_1 = require("./get_projected_pointer_position");
exports.getTooltipAnchorPositionSelector = re_reselect_1.default([
    compute_chart_dimensions_1.computeChartDimensionsSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    get_cursor_band_1.getCursorBandPositionSelector,
    get_projected_pointer_position_1.getProjectedPointerPositionSelector,
    get_legend_size_1.getLegendSizeSelector,
], function (chartDimensions, settings, cursorBandPosition, projectedPointerPosition) {
    if (!cursorBandPosition) {
        return null;
    }
    return crosshair_utils_1.getTooltipAnchorPosition(chartDimensions, settings.rotation, cursorBandPosition, projectedPointerPosition);
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=get_tooltip_position.js.map