"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiHeader", {
  enumerable: true,
  get: function get() {
    return _header.EuiHeader;
  }
});
exports.OuiHeader = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _header_section = require("./header_section");

var _header_breadcrumbs = require("./header_breadcrumbs");

var _header = require("../../eui_components/header/header");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function createHeaderSection(sections, border) {
  return sections.map(function (section, index) {
    return /*#__PURE__*/_react.default.createElement(_header_section.OuiHeaderSectionItem, {
      key: index,
      border: border
    }, section);
  });
}

// Start a counter to manage the total number of fixed headers that need the body class
var ouiHeaderFixedCounter = 0;

var OuiHeader = function OuiHeader(_ref) {
  var children = _ref.children,
      className = _ref.className,
      sections = _ref.sections,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'static' : _ref$position,
      _ref$theme = _ref.theme,
      theme = _ref$theme === void 0 ? 'default' : _ref$theme,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "sections", "position", "theme"]);
  var classes = (0, _classnames.default)('ouiHeader', "ouiHeader--".concat(theme), "ouiHeader--".concat(position), className);
  (0, _react.useEffect)(function () {
    if (position === 'fixed') {
      // Increment fixed header counter for each fixed header
      ouiHeaderFixedCounter++;
      document.body.classList.add('ouiBody--headerIsFixed');
      return function () {
        // Both decrement the fixed counter AND then check if there are none
        if (--ouiHeaderFixedCounter === 0) {
          // If there are none, THEN remove class
          document.body.classList.remove('ouiBody--headerIsFixed');
        }
      };
    }
  }, [position]);
  var contents;

  if (sections) {
    if (children) {
      // In case both children and sections are passed, warn in the console that the children will be disregarded
      console.warn('OuiHeader cannot accept both `children` and `sections`. It will disregard the `children`.');
    }

    contents = sections.map(function (section, index) {
      var content = [];

      if (section.items) {
        // Items get wrapped in OuiHeaderSection and each item in a OuiHeaderSectionItem
        content.push( /*#__PURE__*/_react.default.createElement(_header_section.OuiHeaderSection, {
          key: "items-".concat(index)
        }, createHeaderSection(section.items, section.borders)));
      }

      if (section.breadcrumbs) {
        content.push(
        /*#__PURE__*/
        // Breadcrumbs are separate and cannot be contained in a OuiHeaderSection
        // in order for truncation to work
        _react.default.createElement(_header_breadcrumbs.OuiHeaderBreadcrumbs, (0, _extends2.default)({
          key: "breadcrumbs-".concat(index),
          breadcrumbs: section.breadcrumbs
        }, section.breadcrumbProps)));
      }

      return content;
    });
  } else {
    contents = children;
  }

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), contents);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiHeader = OuiHeader;
OuiHeader.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * An array of objects to wrap in a #OuiHeaderSection.
       * Each section is spaced using `space-between`.
       * See #OuiHeaderSectionsProp for object details.
       * This prop disregards the prop `children` if both are passed.
       */
  sections: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * An arry of items that will be wrapped in a #OuiHeaderSectionItem
       */
    items: _propTypes.default.arrayOf(_propTypes.default.node.isRequired),

    /**
       * Apply the passed border side to each #OuiHeaderSectionItem
       */
    borders: _propTypes.default.oneOf(["left", "right", "none"]),

    /**
       * Breadcrumbs in the header cannot be wrapped in a #OuiHeaderSection in order for truncation to work.
       * Simply pass the array of OuiBreadcrumb objects
       */
    breadcrumbs: _propTypes.default.arrayOf(_propTypes.default.shape({
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string,

      /**
         * Visible label of the breadcrumb
         */
      text: _propTypes.default.node.isRequired,
      href: _propTypes.default.string,
      onClick: _propTypes.default.func,

      /**
         * Force a max-width on the breadcrumb text
         */
      truncate: _propTypes.default.bool
    }).isRequired),

    /**
       * Other props to pass to #OuiHeaderBreadcrumbs
       */
    breadcrumbProps: _propTypes.default.any
  }).isRequired),

  /**
       * Helper that positions the header against the window body and
       * adds the correct amount of top padding to the window when in `fixed` mode
       */
  position: _propTypes.default.oneOf(["static", "fixed"]),

  /**
       * The `default` will inherit its coloring from the light or dark theme.
       * Or, force the header into pseudo `dark` theme for all themes.
       */
  theme: _propTypes.default.oneOf(["default", "dark"])
};