/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.solr.handler.sql.SolrAggregate;
import org.apache.solr.handler.sql.SolrFilter;
import org.apache.solr.handler.sql.SolrProject;
import org.apache.solr.handler.sql.SolrRel;
import org.apache.solr.handler.sql.SolrSort;

class SolrRules {
    static final RelOptRule[] RULES = new RelOptRule[]{SolrSortRule.SORT_RULE, SolrFilterRule.access$000(), SolrProjectRule.access$100(), SolrAggregateRule.access$200()};

    SolrRules() {
    }

    static List<String> solrFieldNames(final RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }, (boolean)true);
    }

    private static class SolrAggregateRule
    extends SolrConverterRule {
        private static final RelOptRule AGGREGATE_RULE = new SolrAggregateRule();

        private SolrAggregateRule() {
            super(LogicalAggregate.class, "SolrAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)this.out);
            return new SolrAggregate(rel.getCluster(), traitSet, (List<RelHint>)agg.getHints(), SolrAggregateRule.convert((RelNode)agg.getInput(), (RelTraitSet)traitSet.simplify()), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }

        static /* synthetic */ RelOptRule access$200() {
            return AGGREGATE_RULE;
        }
    }

    private static class SolrSortRule
    extends SolrConverterRule {
        static final SolrSortRule SORT_RULE = new SolrSortRule(LogicalSort.class, "SolrSortRule");

        SolrSortRule(Class<? extends RelNode> clazz, String description) {
            super(clazz, description);
        }

        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)this.out).replace((RelTrait)sort.getCollation());
            return new SolrSort(rel.getCluster(), traitSet, SolrSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    private static class SolrProjectRule
    extends SolrConverterRule {
        private static final SolrProjectRule PROJECT_RULE = new SolrProjectRule();

        private SolrProjectRule() {
            super(LogicalProject.class, "SolrProjectRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelNode converted = SolrProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out);
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new SolrProject(rel.getCluster(), traitSet, converted, project.getProjects(), project.getRowType());
        }

        static /* synthetic */ SolrProjectRule access$100() {
            return PROJECT_RULE;
        }
    }

    private static class SolrFilterRule
    extends SolrConverterRule {
        private static final SolrFilterRule FILTER_RULE = new SolrFilterRule();

        private static boolean isNotFilterByExpr(List<RexNode> rexNodes, List<String> fieldNames) {
            boolean result = true;
            for (RexNode rexNode : rexNodes) {
                if (rexNode instanceof RexCall) {
                    result = result && SolrFilterRule.isNotFilterByExpr(((RexCall)rexNode).getOperands(), fieldNames);
                    continue;
                }
                if (!(rexNode instanceof RexInputRef)) continue;
                result = result && !fieldNames.get(((RexInputRef)rexNode).getIndex()).startsWith("EXPR$");
            }
            return result;
        }

        private static boolean filter(RelNode relNode) {
            List filterOperands = ((RexCall)((LogicalFilter)relNode).getCondition()).getOperands();
            return SolrFilterRule.isNotFilterByExpr(filterOperands, SolrRules.solrFieldNames(relNode.getRowType()));
        }

        private SolrFilterRule() {
            super(LogicalFilter.class, SolrFilterRule::filter, "SolrFilterRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)this.out);
            return new SolrFilter(rel.getCluster(), traitSet, SolrFilterRule.convert((RelNode)filter.getInput(), (RelTrait)this.out), filter.getCondition());
        }

        static /* synthetic */ SolrFilterRule access$000() {
            return FILTER_RULE;
        }
    }

    static abstract class SolrConverterRule
    extends ConverterRule {
        final Convention out = SolrRel.CONVENTION;

        SolrConverterRule(Class<? extends RelNode> clazz, String description) {
            this(clazz, relNode -> true, description);
        }

        <R extends RelNode> SolrConverterRule(Class<R> clazz, Predicate<RelNode> predicate, String description) {
            super(clazz, (RelTrait)Convention.NONE, (RelTrait)SolrRel.CONVENTION, description);
        }
    }

    static class RexToSolrTranslator
    extends RexVisitorImpl<String> {
        private final JavaTypeFactory typeFactory;
        private final List<String> inFields;

        RexToSolrTranslator(JavaTypeFactory typeFactory, List<String> inFields) {
            super(true);
            this.typeFactory = typeFactory;
            this.inFields = inFields;
        }

        public String visitInputRef(RexInputRef inputRef) {
            return this.inFields.get(inputRef.getIndex());
        }

        public String visitCall(RexCall call) {
            List<String> strings = this.visitList((List<RexNode>)call.operands);
            if (call.getKind() == SqlKind.CAST) {
                return strings.get(0);
            }
            return (String)super.visitCall(call);
        }

        private List<String> visitList(List<RexNode> list) {
            ArrayList<String> strings = new ArrayList<String>();
            for (RexNode node : list) {
                strings.add((String)node.accept((RexVisitor)this));
            }
            return strings;
        }
    }
}

