/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;
import org.apache.batik.util.HaltingThread;

public class TileRed
extends AbstractRed
implements TileGenerator {
    static final AffineTransform IDENTITY = new AffineTransform();
    Rectangle tiledRegion;
    int xStep;
    int yStep;
    TileStore tiles;
    private RenderingHints hints;
    final boolean is_INT_PACK;
    final boolean alphaPremult;
    RenderedImage tile = null;
    WritableRaster raster = null;

    public TileRed(RenderedImage renderedImage, Rectangle rectangle) {
        this(renderedImage, rectangle, renderedImage.getWidth(), renderedImage.getHeight(), null);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, RenderingHints renderingHints) {
        this(renderedImage, rectangle, renderedImage.getWidth(), renderedImage.getHeight(), renderingHints);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, int n, int n2) {
        this(renderedImage, rectangle, n, n2, null);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, int n, int n2, RenderingHints renderingHints) {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        if (renderedImage == null) {
            throw new IllegalArgumentException();
        }
        this.tiledRegion = rectangle;
        this.xStep = n;
        this.yStep = n2;
        this.hints = renderingHints;
        this.alphaPremult = false;
        SampleModel sampleModel = TileRed.fixSampleModel(renderedImage, n, n2, rectangle.width, rectangle.height);
        ColorModel colorModel = TileRed.fixColorModel(renderedImage, this.alphaPremult);
        double d = AbstractTiledRed.getDefaultTileSize();
        double d2 = (double)n * (double)n2;
        if (16.1 * (d *= d) > d2) {
            int n3 = n;
            int n4 = n2;
            if (4.0 * d2 <= d) {
                int n5 = (int)Math.ceil(Math.sqrt(d / d2));
                n3 *= n5;
                n4 *= n5;
            }
            sampleModel = sampleModel.createCompatibleSampleModel(n3, n4);
            this.raster = Raster.createWritableRaster(sampleModel, new Point(renderedImage.getMinX(), renderedImage.getMinY()));
        }
        this.is_INT_PACK = GraphicsUtil.is_INT_PACK_Data(sampleModel, false);
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, renderedImage.getMinX(), renderedImage.getMinY(), null);
        if (this.raster != null) {
            WritableRaster writableRaster = this.raster.createWritableChild(renderedImage.getMinX(), renderedImage.getMinY(), n, n2, renderedImage.getMinX(), renderedImage.getMinY(), null);
            this.fillRasterFrom(writableRaster, renderedImage);
            this.fillOutRaster(this.raster);
        } else {
            this.tile = new TileCacheRed(GraphicsUtil.wrap(renderedImage));
        }
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        int n = (int)Math.floor(writableRaster.getMinX() / this.xStep) * this.xStep;
        int n2 = (int)Math.floor(writableRaster.getMinY() / this.yStep) * this.yStep;
        int n3 = writableRaster.getMinX() - n;
        int n4 = writableRaster.getMinY() - n2;
        int n5 = this.getXTile(n3);
        int n6 = this.getYTile(n4);
        int n7 = this.getXTile(n3 + writableRaster.getWidth() - 1);
        int n8 = this.getYTile(n4 + writableRaster.getHeight() - 1);
        int n9 = n6;
        while (n9 <= n8) {
            int n10 = n5;
            while (n10 <= n7) {
                Raster raster = this.getTile(n10, n9);
                raster = raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX() + n, raster.getMinY() + n2, null);
                if (this.is_INT_PACK) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                } else {
                    GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                }
                ++n10;
            }
            ++n9;
        }
        return writableRaster;
    }

    public Raster getTile(int n, int n2) {
        if (this.raster != null) {
            int n3 = this.tileGridXOff + n * this.tileWidth;
            int n4 = this.tileGridYOff + n2 * this.tileHeight;
            return this.raster.createTranslatedChild(n3, n4);
        }
        return this.genTile(n, n2);
    }

    public Raster genTile(int n, int n2) {
        int n3 = this.tileGridXOff + n * this.tileWidth;
        int n4 = this.tileGridYOff + n2 * this.tileHeight;
        if (this.raster != null) {
            return this.raster.createTranslatedChild(n3, n4);
        }
        Point point = new Point(n3, n4);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        this.fillRasterFrom(writableRaster, this.tile);
        return writableRaster;
    }

    /*
     * Unable to fully structure code
     */
    public WritableRaster fillRasterFrom(WritableRaster var1_1, RenderedImage var2_2) {
        var3_3 = this.getColorModel();
        var4_4 = new BufferedImage(var3_3, var1_1.createWritableTranslatedChild(0, 0), var3_3.isAlphaPremultiplied(), null);
        var5_5 = GraphicsUtil.createGraphics(var4_4, this.hints);
        var6_6 = var1_1.getMinX();
        var7_7 = var1_1.getMinY();
        var8_8 = var1_1.getWidth();
        var9_9 = var1_1.getHeight();
        var5_5.setComposite(AlphaComposite.Clear);
        var5_5.setColor(new Color(0, 0, 0, 0));
        var5_5.fillRect(0, 0, var8_8, var9_9);
        var5_5.setComposite(AlphaComposite.SrcOver);
        var5_5.translate(-var6_6, -var7_7);
        var10_10 = var2_2.getMinX() + var2_2.getWidth() - 1;
        var11_11 = var2_2.getMinY() + var2_2.getHeight() - 1;
        var12_12 = (int)Math.ceil((var6_6 - var10_10) / this.xStep) * this.xStep;
        var13_13 = (int)Math.ceil((var7_7 - var11_11) / this.yStep) * this.yStep;
        var5_5.translate(var12_12, var13_13);
        var14_14 = var12_12 - var1_1.getMinX() + var2_2.getMinX();
        var15_15 = var13_13 - var1_1.getMinY() + var2_2.getMinY();
        var6_6 = var14_14;
        while (var15_15 < var9_9) {
            if (!HaltingThread.hasBeenHalted()) ** GOTO lbl27
            return var1_1;
lbl-1000:
            // 1 sources

            {
                GraphicsUtil.drawImage(var5_5, var2_2);
                var14_14 += this.xStep;
                var5_5.translate(this.xStep, 0);
lbl27:
                // 2 sources

                ** while (var14_14 < var8_8)
            }
lbl28:
            // 1 sources

            var15_15 += this.yStep;
            var5_5.translate(var6_6 - var14_14, this.yStep);
            var14_14 = var6_6;
        }
        GraphicsUtil.coerceData(var1_1, var2_2.getColorModel(), this.alphaPremult);
        return var1_1;
    }

    protected void fillOutRaster(WritableRaster writableRaster) {
        if (this.is_INT_PACK) {
            this.fillOutRaster_INT_PACK(writableRaster);
        } else {
            this.fillOutRaster_FALLBACK(writableRaster);
        }
    }

    protected void fillOutRaster_INT_PACK(WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        int n6 = writableRaster.getWidth();
        int n7 = writableRaster.getHeight();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n8 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n9 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n4 - writableRaster.getSampleModelTranslateX(), n5 - writableRaster.getSampleModelTranslateY());
        int n10 = this.xStep;
        int n11 = this.xStep;
        while (n11 < n6) {
            int n12;
            n3 = n10;
            if (n11 + n3 > n6) {
                n3 = n6 - n11;
            }
            if (n3 >= 128) {
                n2 = n9;
                n = n9 + n11;
                n12 = 0;
                while (n12 < this.yStep) {
                    System.arraycopy(nArray, n2, nArray, n, n3);
                    n2 += n8;
                    n += n8;
                    ++n12;
                }
            } else {
                n2 = n9;
                n = n9 + n11;
                n12 = 0;
                while (n12 < this.yStep) {
                    int n13 = n2;
                    n2 += n3 - 1;
                    n += n3 - 1;
                    while (n2 >= n13) {
                        nArray[n--] = nArray[n2--];
                    }
                    n2 += n8 + 1;
                    n += n8 + 1;
                    ++n12;
                }
            }
            n11 += n10;
            n10 *= 2;
        }
        n10 = this.yStep;
        n3 = this.yStep;
        while (n3 < n7) {
            n2 = n10;
            if (n3 + n2 > n7) {
                n2 = n7 - n3;
            }
            n = n9 + n3 * n8;
            System.arraycopy(nArray, n9, nArray, n, n2 * n8);
            n3 += n10;
            n10 *= 2;
        }
    }

    protected void fillOutRaster_FALLBACK(WritableRaster writableRaster) {
        int n;
        int n2 = writableRaster.getWidth();
        int n3 = writableRaster.getHeight();
        Object object = null;
        int n4 = this.xStep;
        int n5 = this.xStep;
        while (n5 < n2) {
            n = n4;
            if (n5 + n > n2) {
                n = n2 - n5;
            }
            object = writableRaster.getDataElements(0, 0, n, this.yStep, object);
            writableRaster.setDataElements(n5, 0, n, this.yStep, object);
            if ((n5 += n) >= n2) break;
            if (n5 + n > n2) {
                n = n2 - n5;
            }
            writableRaster.setDataElements(n5, 0, n, this.yStep, object);
            if ((n5 += n) >= n2) break;
            if (n5 + n > n2) {
                n = n2 - n5;
            }
            writableRaster.setDataElements(n5, 0, n, this.yStep, object);
            n5 += n4;
            n4 *= 4;
        }
        n4 = this.yStep;
        n = this.yStep;
        while (n < n3) {
            int n6 = n4;
            if (n + n6 > n3) {
                n6 = n3 - n;
            }
            object = writableRaster.getDataElements(0, 0, n2, n6, object);
            writableRaster.setDataElements(0, n, n2, n6, object);
            n += n6;
            if (n6 >= n3) break;
            if (n + n6 > n3) {
                n6 = n3 - n;
            }
            writableRaster.setDataElements(0, n, n2, n6, object);
            n += n6;
            if (n6 >= n3) break;
            if (n + n6 > n3) {
                n6 = n3 - n;
            }
            writableRaster.setDataElements(0, n, n2, n6, object);
            n += n6;
            n += n4;
            n4 *= 4;
        }
    }

    protected static ColorModel fixColorModel(RenderedImage renderedImage, boolean bl) {
        return GraphicsUtil.coerceColorModel(renderedImage.getColorModel(), bl);
    }

    protected static SampleModel fixSampleModel(RenderedImage renderedImage, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = AbstractTiledRed.getDefaultTileSize();
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n7 = sampleModel.getWidth();
        if (n7 < n6) {
            n7 = n6;
        }
        if (n7 > n) {
            n7 = n;
        }
        if ((n5 = sampleModel.getHeight()) < n6) {
            n5 = n6;
        }
        if (n5 > n2) {
            n5 = n2;
        }
        return sampleModel.createCompatibleSampleModel(n7, n5);
    }
}

