/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import org.netbeans.core.windows.view.ui.MultiSplitCell;
import org.netbeans.core.windows.view.ui.MultiSplitPane;

public class MultiSplitDivider
implements Accessible {
    MultiSplitPane splitPane;
    Rectangle rect = new Rectangle();
    MultiSplitCell first;
    MultiSplitCell second;
    Point currentDragLocation;
    int dragMin;
    int dragMax;
    int cursorPositionCompensation;
    private AccessibleContext accessibleContext;

    public MultiSplitDivider(MultiSplitPane multiSplitPane, MultiSplitCell multiSplitCell, MultiSplitCell multiSplitCell2) {
        assert (null != multiSplitPane);
        assert (null != multiSplitCell);
        assert (null != multiSplitCell2);
        this.splitPane = multiSplitPane;
        this.first = multiSplitCell;
        this.second = multiSplitCell2;
        this.reshape();
    }

    boolean isHorizontal() {
        return this.splitPane.isHorizontalSplit();
    }

    boolean isVertical() {
        return this.splitPane.isVerticalSplit();
    }

    int getDividerSize() {
        return this.splitPane.getDividerSize();
    }

    boolean containsPoint(Point point) {
        return this.rect.contains(point);
    }

    void paint(Graphics graphics) {
        if (null != this.currentDragLocation) {
            Color color = graphics.getColor();
            graphics.setColor(Color.BLACK);
            if (this.isHorizontal()) {
                if (this.currentDragLocation.x != this.rect.x) {
                    graphics.fillRect(this.currentDragLocation.x, this.rect.y, this.rect.width, this.rect.height);
                }
            } else if (this.currentDragLocation.y != this.rect.y) {
                graphics.fillRect(this.rect.x, this.currentDragLocation.y, this.rect.width, this.rect.height);
            }
            graphics.setColor(color);
        }
    }

    void startDragging(Point point) {
        this.currentDragLocation = new Point(this.rect.x, this.rect.y);
        this.cursorPositionCompensation = this.isHorizontal() ? point.x - this.rect.x : point.y - this.rect.y;
        this.initDragMinMax();
    }

    void dragTo(Point point) {
        if (this.isHorizontal()) {
            if (point.x < this.dragMin) {
                point.x = this.dragMin;
            }
            if (point.x > this.dragMax) {
                point.x = this.dragMax;
            }
        } else {
            if (point.y < this.dragMin) {
                point.y = this.dragMin;
            }
            if (point.y > this.dragMax) {
                point.y = this.dragMax;
            }
        }
        Point point2 = this.currentDragLocation;
        this.currentDragLocation = point;
        this.repaintSplitPane(point2);
        this.repaintSplitPane(this.currentDragLocation);
    }

    private void repaintSplitPane(Point point) {
        if (this.isHorizontal()) {
            this.splitPane.repaint(point.x, this.rect.y, this.rect.width, this.rect.height);
        } else {
            this.splitPane.repaint(this.rect.x, point.y, this.rect.width, this.rect.height);
        }
    }

    void finishDraggingTo(Point point) {
        if (this.isHorizontal()) {
            point.x -= this.cursorPositionCompensation;
            if (point.x < this.dragMin) {
                point.x = this.dragMin;
            }
            if (point.x > this.dragMax) {
                point.x = this.dragMax;
            }
            if (point.x == this.rect.x) {
                return;
            }
        } else {
            point.y -= this.cursorPositionCompensation;
            if (point.y < this.dragMin) {
                point.y = this.dragMin;
            }
            if (point.y > this.dragMax) {
                point.y = this.dragMax;
            }
            if (point.y == this.rect.y) {
                return;
            }
        }
        this.currentDragLocation = null;
        int n = this.getDividerSize();
        if (this.isHorizontal()) {
            int n2 = point.x - this.rect.x;
            int n3 = this.first.getLocation();
            int n4 = 0;
            int n5 = this.first.getSize() + n2;
            int n6 = this.rect.height;
            this.first.layout(n3, n4, n5, n6);
            n3 = this.second.getLocation() + n2;
            n5 = this.second.getSize() - n2;
            this.second.layout(n3, n4, n5, n6);
            this.rect.x = point.x;
        } else {
            int n7 = point.y - this.rect.y;
            int n8 = 0;
            int n9 = this.first.getLocation();
            int n10 = this.rect.width;
            int n11 = this.first.getSize() + n7;
            this.first.layout(n8, n9, n10, n11);
            n9 = this.second.getLocation() + n7;
            n11 = this.second.getSize() - n7;
            this.second.layout(n8, n9, n10, n11);
            this.rect.y = point.y;
        }
        this.splitPane.splitterMoved();
    }

    private void initDragMinMax() {
        int n = this.getDividerSize();
        int n2 = this.first.getSize();
        int n3 = this.second.getSize();
        int n4 = this.first.getMinimumSize();
        int n5 = this.second.getMinimumSize();
        if (this.isHorizontal()) {
            this.dragMin = this.rect.x;
            this.dragMax = this.rect.x;
        } else {
            this.dragMin = this.rect.y;
            this.dragMax = this.rect.y;
        }
        if (n2 >= n4) {
            this.dragMin -= n2 - n4;
        }
        if (n3 >= n5) {
            this.dragMax += n3 - n5;
        }
    }

    void reshape() {
        Dimension dimension = this.splitPane.getSize();
        int n = this.second.getLocation();
        if (this.isHorizontal()) {
            this.rect.x = n - this.getDividerSize();
            this.rect.y = 0;
            this.rect.width = this.getDividerSize();
            this.rect.height = dimension.height;
        } else {
            this.rect.x = 0;
            this.rect.y = n - this.getDividerSize();
            this.rect.width = dimension.width;
            this.rect.height = this.getDividerSize();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (null == this.accessibleContext) {
            this.accessibleContext = new AccessibleMultiSplitDivider();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultiSplitDivider
    extends AccessibleContext
    implements AccessibleValue {
        public AccessibleMultiSplitDivider() {
            this.setAccessibleParent(MultiSplitDivider.this.splitPane);
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public int getAccessibleIndexInParent() {
            return MultiSplitDivider.this.splitPane.getDividerAccessibleIndex(MultiSplitDivider.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            if (MultiSplitDivider.this.isHorizontal()) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }

        public boolean setCurrentAccessibleValue(Number number) {
            MultiSplitDivider.this.initDragMinMax();
            int n = number.intValue();
            if (n < MultiSplitDivider.this.dragMin || n > MultiSplitDivider.this.dragMax) {
                return false;
            }
            if (MultiSplitDivider.this.isHorizontal()) {
                MultiSplitDivider.this.finishDraggingTo(new Point(n, 0));
            } else {
                MultiSplitDivider.this.finishDraggingTo(new Point(0, n));
            }
            return true;
        }

        public Number getMinimumAccessibleValue() {
            MultiSplitDivider.this.initDragMinMax();
            return MultiSplitDivider.this.dragMin;
        }

        public Number getMaximumAccessibleValue() {
            MultiSplitDivider.this.initDragMinMax();
            return MultiSplitDivider.this.dragMax;
        }

        public Number getCurrentAccessibleValue() {
            if (MultiSplitDivider.this.isHorizontal()) {
                return MultiSplitDivider.this.rect.x;
            }
            return MultiSplitDivider.this.rect.y;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }
    }
}

