/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.internal.util.Strings;
import org.jparsec.pattern.CharPredicate;

public final class CharPredicates {
    public static final CharPredicate NEVER = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return false;
        }

        public String toString() {
            return "none";
        }
    };
    public static final CharPredicate ALWAYS = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return true;
        }

        public String toString() {
            return "any character";
        }
    };
    public static final CharPredicate IS_HEX_DIGIT = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        public String toString() {
            return "[0-9a-fA-F]";
        }
    };
    public static final CharPredicate IS_UPPER_CASE = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return Character.isUpperCase(c);
        }

        public String toString() {
            return "uppercase";
        }
    };
    public static final CharPredicate IS_LOWER_CASE = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return Character.isLowerCase(c);
        }

        public String toString() {
            return "lowercase";
        }
    };
    public static final CharPredicate IS_WHITESPACE = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return Character.isWhitespace(c);
        }

        public String toString() {
            return "whitespace";
        }
    };
    public static final CharPredicate IS_ALPHA = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A';
        }

        public String toString() {
            return "[a-zA-Z]";
        }
    };
    public static final CharPredicate IS_ALPHA_ = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return c == '_' || c <= 'z' && c >= 'a' || c <= 'Z' && c >= 'A';
        }

        public String toString() {
            return "[a-zA-Z_]";
        }
    };
    public static final CharPredicate IS_LETTER = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return Character.isLetter(c);
        }

        public String toString() {
            return "letter";
        }
    };
    public static final CharPredicate IS_ALPHA_NUMERIC = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
        }

        public String toString() {
            return "[0-9a-zA-Z]";
        }
    };
    public static final CharPredicate IS_ALPHA_NUMERIC_ = new CharPredicate(){

        @Override
        public boolean isChar(char c) {
            return c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
        }

        public String toString() {
            return "[0-9a-zA-Z_]";
        }
    };
    public static final CharPredicate IS_DIGIT = CharPredicates.range('0', '9');

    private CharPredicates() {
    }

    public static CharPredicate isChar(final char c) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char x) {
                return x == c;
            }

            public String toString() {
                return Character.toString(c);
            }
        };
    }

    public static CharPredicate notChar(final char c) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char x) {
                return x != c;
            }

            public String toString() {
                return "^" + Character.toString(c);
            }
        };
    }

    public static CharPredicate range(final char a, final char b) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                return c >= a && c <= b;
            }

            public String toString() {
                return "[" + a + '-' + b + "]";
            }
        };
    }

    public static CharPredicate notRange(final char a, final char b) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                return c < a || c > b;
            }

            public String toString() {
                return "[^" + a + '-' + b + "]";
            }
        };
    }

    public static CharPredicate among(final String chars) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                return chars.indexOf(c) >= 0;
            }

            public String toString() {
                return '[' + chars + ']';
            }
        };
    }

    public static CharPredicate notAmong(final String chars) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                return chars.indexOf(c) < 0;
            }

            public String toString() {
                return "^[" + chars + ']';
            }
        };
    }

    public static CharPredicate not(final CharPredicate predicate) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                return !predicate.isChar(c);
            }

            public String toString() {
                return "^" + predicate;
            }
        };
    }

    public static CharPredicate and(final CharPredicate predicate1, final CharPredicate predicate2) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                return predicate1.isChar(c) && predicate2.isChar(c);
            }

            public String toString() {
                return predicate1 + " and " + predicate2;
            }
        };
    }

    public static CharPredicate or(final CharPredicate predicate1, final CharPredicate predicate2) {
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                return predicate1.isChar(c) || predicate2.isChar(c);
            }

            public String toString() {
                return predicate1 + " or " + predicate2;
            }
        };
    }

    public static CharPredicate and(final CharPredicate ... predicates) {
        if (predicates.length == 0) {
            return ALWAYS;
        }
        if (predicates.length == 1) {
            return predicates[0];
        }
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                for (int i = 0; i < predicates.length; ++i) {
                    if (predicates[i].isChar(c)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return Strings.join(" and ", predicates);
            }
        };
    }

    public static CharPredicate or(final CharPredicate ... predicates) {
        if (predicates.length == 0) {
            return NEVER;
        }
        if (predicates.length == 1) {
            return predicates[0];
        }
        return new CharPredicate(){

            @Override
            public boolean isChar(char c) {
                for (int i = 0; i < predicates.length; ++i) {
                    if (!predicates[i].isChar(c)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return Strings.join(" or ", predicates);
            }
        };
    }
}

