/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public class CorsResponseFilter
implements ContainerResponseFilter {
    private final String allowed;
    private static final String ORIGIN_ALL = "*";
    private static final String HEADERS_ALL = "origin, content-type, accept, authorization";
    private static final String METHODS_ALL = "GET, POST, PUT, DELETE, OPTIONS";

    @Inject
    public CorsResponseFilter(Config config) {
        this.allowed = config.getString(Keys.WEB_ORIGIN);
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        if (!response.getHeaders().containsKey((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString())) {
            response.getHeaders().add((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), (Object)HEADERS_ALL);
        }
        if (!response.getHeaders().containsKey((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString())) {
            response.getHeaders().add((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString(), (Object)true);
        }
        if (!response.getHeaders().containsKey((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString())) {
            response.getHeaders().add((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), (Object)METHODS_ALL);
        }
        if (!response.getHeaders().containsKey((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString())) {
            String origin = request.getHeaderString(HttpHeaderNames.ORIGIN.toString());
            if (origin == null) {
                response.getHeaders().add((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), (Object)ORIGIN_ALL);
            } else if (this.allowed == null || this.allowed.equals(ORIGIN_ALL) || this.allowed.contains(origin)) {
                response.getHeaders().add((Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), (Object)origin);
            }
        }
    }
}

