/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharing.user;

import com.google.inject.Inject;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.sharing.connection.SharedConnectionDirectory;
import org.apache.guacamole.auth.jdbc.sharing.connectiongroup.SharedRootConnectionGroup;
import org.apache.guacamole.auth.jdbc.sharing.user.SharedUser;
import org.apache.guacamole.auth.jdbc.user.RemoteAuthenticatedUser;
import org.apache.guacamole.net.auth.AbstractUserContext;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.User;

public class SharedUserContext
extends AbstractUserContext {
    private AuthenticationProvider authProvider;
    private User self;
    @Inject
    private SharedConnectionDirectory connectionDirectory;
    private ConnectionGroup rootGroup;

    public void init(AuthenticationProvider authProvider, RemoteAuthenticatedUser user) {
        this.authProvider = authProvider;
        this.connectionDirectory.init(user);
        this.rootGroup = new SharedRootConnectionGroup(this);
        this.self = new SharedUser(user, this);
    }

    public void registerShareKey(String shareKey) {
        this.connectionDirectory.registerShareKey(shareKey);
    }

    public User self() {
        return this.self;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authProvider;
    }

    public Directory<Connection> getConnectionDirectory() throws GuacamoleException {
        return this.connectionDirectory;
    }

    public ConnectionGroup getRootConnectionGroup() {
        return this.rootGroup;
    }
}

