/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.annotation.ProviderContext;

public interface ProviderMethodResolver {
    default public Method resolveMethod(ProviderContext context) {
        List sameNameMethods = Arrays.stream(this.getClass().getMethods()).filter(m3 -> m3.getName().equals(context.getMapperMethod().getName())).collect(Collectors.toList());
        if (sameNameMethods.isEmpty()) {
            throw new BuilderException("Cannot resolve the provider method because '" + context.getMapperMethod().getName() + "' not found in SqlProvider '" + this.getClass().getName() + "'.");
        }
        List targetMethods = sameNameMethods.stream().filter(m3 -> CharSequence.class.isAssignableFrom(m3.getReturnType())).collect(Collectors.toList());
        if (targetMethods.size() == 1) {
            return (Method)targetMethods.get(0);
        }
        if (targetMethods.isEmpty()) {
            throw new BuilderException("Cannot resolve the provider method because '" + context.getMapperMethod().getName() + "' does not return the CharSequence or its subclass in SqlProvider '" + this.getClass().getName() + "'.");
        }
        throw new BuilderException("Cannot resolve the provider method because '" + context.getMapperMethod().getName() + "' is found multiple in SqlProvider '" + this.getClass().getName() + "'.");
    }
}

