/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.Cache;
import ca.sqlpower.util.CacheStats;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCache
extends HashMap
implements Cache,
Serializable {
    protected int maxMembers;
    protected Date lastFlushDate;
    protected CacheStats stats;

    public AbstractCache(int initialMaxMembers) {
        this.maxMembers = initialMaxMembers;
        this.lastFlushDate = new Date();
        this.stats = new CacheStats();
    }

    protected abstract void itemsInserted(Object[] var1);

    protected abstract void itemRequested(Object var1, boolean var2);

    @Override
    public void setMaxMembers(int argMaxMembers) {
        this.maxMembers = argMaxMembers;
    }

    @Override
    public int getMaxMembers() {
        return this.maxMembers;
    }

    @Override
    public Object put(Object key, Object value) {
        Object retval = super.put(key, value);
        Object[] theKey = new Object[]{key};
        this.internalItemsInserted(theKey);
        return retval;
    }

    @Override
    public void putAll(Map t) {
        super.putAll(t);
        this.internalItemsInserted(t.keySet().toArray());
    }

    @Override
    public Object get(Object key) {
        Object retval = super.get(key);
        this.internalItemRequested(key, retval != null);
        return retval;
    }

    @Override
    public Date getLastFlushDate() {
        return this.lastFlushDate;
    }

    @Override
    public void flush() {
        super.clear();
        this.stats.cacheFlush();
        this.lastFlushDate = new Date();
    }

    @Override
    public CacheStats getStats() {
        return this.stats;
    }

    private void internalItemsInserted(Object[] keys) {
        this.stats.totalInserted += keys.length;
        this.itemsInserted(keys);
    }

    private void internalItemRequested(Object key, boolean wasPresent) {
        ++this.stats.totalRequested;
        if (wasPresent) {
            ++this.stats.totalHits;
        } else {
            ++this.stats.totalMisses;
        }
        this.itemRequested(key, wasPresent);
    }
}

