/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.systemdata;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.systemdata.SystemDataData;
import org.pentaho.di.trans.steps.systemdata.SystemDataMeta;
import org.pentaho.di.version.BuildVersion;

public class SystemData
extends BaseStep
implements StepInterface {
    private SystemDataMeta meta;
    private SystemDataData data;

    public SystemData(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.setName(stepMeta.getName());
    }

    private Object[] getSystemData(RowMetaInterface inputRowMeta, Object[] inputRowData) throws KettleException {
        int i;
        Object[] row = new Object[this.data.outputRowMeta.size()];
        for (i = 0; i < inputRowMeta.size(); ++i) {
            row[i] = inputRowData[i];
        }
        i = 0;
        int index = inputRowMeta.size();
        while (i < this.meta.getFieldName().length) {
            int argnr = 0;
            switch (this.meta.getFieldType()[i]) {
                case 2: {
                    row[index] = this.getTrans().getCurrentDate();
                    break;
                }
                case 1: {
                    row[index] = new Date();
                    break;
                }
                case 3: {
                    row[index] = this.getTrans().getStartDate();
                    break;
                }
                case 4: {
                    row[index] = this.getTrans().getEndDate();
                    break;
                }
                case 5: {
                    row[index] = this.getTrans().getJobStartDate();
                    break;
                }
                case 6: {
                    row[index] = this.getTrans().getJobEndDate();
                    break;
                }
                case 7: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 8: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, -1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 9: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 10: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 11: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 12: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 1);
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 13: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 14: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, -1);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 15: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 16: {
                    Calendar cal = Calendar.getInstance();
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 17: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    row[index] = cal.getTime();
                    break;
                }
                case 18: {
                    Calendar cal = Calendar.getInstance();
                    cal.add(2, 1);
                    cal.set(5, cal.getActualMaximum(5));
                    cal.set(11, 23);
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(14, 999);
                    row[index] = cal.getTime();
                    break;
                }
                case 19: {
                    row[index] = new Long(this.getCopy());
                    break;
                }
                case 20: {
                    row[index] = this.getTransMeta().getName();
                    break;
                }
                case 22: {
                    row[index] = this.getTransMeta().getModifiedUser();
                    break;
                }
                case 23: {
                    row[index] = this.getTransMeta().getModifiedDate();
                    break;
                }
                case 24: {
                    row[index] = new Long(this.getTrans().getBatchId());
                    break;
                }
                case 25: {
                    row[index] = new Long(this.getTrans().getPassedBatchId());
                    break;
                }
                case 26: {
                    row[index] = Const.getHostname();
                    break;
                }
                case 27: {
                    try {
                        row[index] = Const.getIPAddress();
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                }
                case 21: {
                    row[index] = this.getTransMeta().getFilename();
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    argnr = this.meta.getFieldType()[i] - 28;
                    if (argnr < this.getTransMeta().getArguments().length) {
                        row[index] = this.getTransMeta().getArguments()[argnr];
                        break;
                    }
                    row[index] = null;
                    break;
                }
                case 38: {
                    row[index] = "3.2.2";
                    break;
                }
                case 39: {
                    row[index] = new Long(BuildVersion.getInstance().getVersion());
                    break;
                }
                case 40: {
                    row[index] = BuildVersion.getInstance().getBuildDate();
                    break;
                }
                case 41: {
                    RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
                    String pid = mx.getName();
                    int indexOf = pid.indexOf("@");
                    if (indexOf > 0) {
                        pid = pid.substring(0, indexOf);
                    }
                    row[index] = new Long(pid);
                    break;
                }
            }
            ++i;
            ++index;
        }
        return row;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        RowMetaInterface imeta;
        Object[] row;
        if (this.data.readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        row = this.getSystemData(imeta, row);
        if (this.log.isRowLevel()) {
            this.logRowlevel("System info returned: " + this.data.outputRowMeta.getString(row));
        }
        this.putRow(this.data.outputRowMeta, row);
        if (!this.data.readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SystemDataMeta)smi;
        this.data = (SystemDataData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readsRows = false;
            List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (previous != null && previous.size() > 0) {
                this.data.readsRows = true;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

