/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.db.DatabaseEntry;

public class ByteArrayBinding
implements EntryBinding {
    private static byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];

    @Override
    public Object entryToObject(DatabaseEntry databaseEntry) {
        int n = databaseEntry.getSize();
        if (n == 0) {
            return ZERO_LENGTH_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(databaseEntry.getData(), databaseEntry.getOffset(), byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public void objectToEntry(Object object, DatabaseEntry databaseEntry) {
        byte[] byArray = (byte[])object;
        databaseEntry.setData(byArray, 0, byArray.length);
    }
}

