/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.examples;

import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.List;

public class SpellCheckExample2
implements SpellCheckListener {
    private static String dictFile = "dict/english.0";
    private SpellChecker spellCheck = null;

    public SpellCheckExample2(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader("example2.txt"));
            File file = null;
            if (string != null) {
                file = new File(string);
            }
            SpellDictionaryHashMap spellDictionaryHashMap = new SpellDictionaryHashMap(new File(dictFile), file);
            this.spellCheck = new SpellChecker(spellDictionaryHashMap);
            this.spellCheck.addSpellCheckListener(this);
            while ((string2 = bufferedReader.readLine()) != null && string2.length() != -1) {
                this.spellCheck.checkSpelling(new StringWordTokenizer(string2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void spellingError(SpellCheckEvent spellCheckEvent) {
        List list = spellCheckEvent.getSuggestions();
        if (list.size() > 0) {
            System.out.println("MISSPELT WORD: " + spellCheckEvent.getInvalidWord());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                System.out.println("\tSuggested Word: " + iterator.next());
            }
        } else {
            System.out.println("MISSPELT WORD: " + spellCheckEvent.getInvalidWord());
            System.out.println("\tNo suggestions");
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Running spell check against DoubleMeta");
        new SpellCheckExample2(null);
        System.out.println("\n\nRunning spell check against GenericTransformator");
        new SpellCheckExample2("dict/phonet.en");
    }
}

