/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.TunnelId;

public class DeliveryInstructions
extends DataStructureImpl {
    private int _deliveryMode = -1;
    public static final int DELIVERY_MODE_LOCAL = 0;
    public static final int DELIVERY_MODE_DESTINATION = 1;
    public static final int DELIVERY_MODE_ROUTER = 2;
    public static final int DELIVERY_MODE_TUNNEL = 3;
    private Hash _destinationHash;
    private Hash _routerHash;
    private TunnelId _tunnelId;
    private boolean _delayRequested;
    private long _delaySeconds;
    private static final int FLAG_MODE_LOCAL = 0;
    private static final int FLAG_MODE_DESTINATION = 1;
    private static final int FLAG_MODE_ROUTER = 2;
    private static final int FLAG_MODE_TUNNEL = 3;
    @Deprecated
    private static final int FLAG_ENCRYPTED = 128;
    private static final int FLAG_MODE = 96;
    private static final int FLAG_DELAY = 16;
    public static final DeliveryInstructions LOCAL = new LocalInstructions();

    public static DeliveryInstructions create(byte[] data, int offset) throws DataFormatException {
        if (data[offset] == 0) {
            return LOCAL;
        }
        DeliveryInstructions rv = new DeliveryInstructions();
        rv.readBytes(data, offset);
        return rv;
    }

    @Deprecated
    public boolean getEncrypted() {
        return false;
    }

    @Deprecated
    public void setEncrypted(boolean encrypted) {
    }

    @Deprecated
    public SessionKey getEncryptionKey() {
        return null;
    }

    @Deprecated
    public void setEncryptionKey(SessionKey key) {
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setDeliveryMode(int mode) {
        this._deliveryMode = mode;
    }

    public Hash getDestination() {
        return this._destinationHash;
    }

    public void setDestination(Hash dest) {
        this._destinationHash = dest;
    }

    public Hash getRouter() {
        return this._routerHash;
    }

    public void setRouter(Hash router) {
        this._routerHash = router;
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(TunnelId id) {
        this._tunnelId = id;
    }

    @Deprecated
    public boolean getDelayRequested() {
        return this._delayRequested;
    }

    @Deprecated
    public void setDelayRequested(boolean req) {
        this._delayRequested = req;
    }

    @Deprecated
    public long getDelaySeconds() {
        return this._delaySeconds;
    }

    @Deprecated
    public void setDelaySeconds(long seconds) {
        this._delaySeconds = seconds;
    }

    @Override
    @Deprecated
    public void readBytes(InputStream in) {
        throw new UnsupportedOperationException();
    }

    public int readBytes(byte[] data, int offset) throws DataFormatException {
        int cur = offset;
        int flags = data[cur] & 0xFF;
        ++cur;
        this.setDeliveryMode(DeliveryInstructions.flagMode(flags));
        switch (DeliveryInstructions.flagMode(flags)) {
            case 0: {
                break;
            }
            case 1: {
                Hash dh = Hash.create(data, cur);
                cur += 32;
                this.setDestination(dh);
                break;
            }
            case 2: {
                Hash rh = Hash.create(data, cur);
                cur += 32;
                this.setRouter(rh);
                break;
            }
            case 3: {
                Hash trh = Hash.create(data, cur);
                this.setRouter(trh);
                this.setTunnelId(new TunnelId(DataHelper.fromLong(data, cur += 32, 4)));
                cur += 4;
            }
        }
        if (DeliveryInstructions.flagDelay(flags)) {
            long delay = DataHelper.fromLong(data, cur, 4);
            cur += 4;
            this.setDelayRequested(true);
            this.setDelaySeconds(delay);
        } else {
            this.setDelayRequested(false);
        }
        return cur - offset;
    }

    private static int flagMode(int flags) {
        int v = flags & 0x60;
        return v >>>= 5;
    }

    private static boolean flagDelay(int flags) {
        return 0 != (flags & 0x10);
    }

    private int getFlags() {
        int val = 0;
        switch (this.getDeliveryMode()) {
            case 0: {
                break;
            }
            case 1: {
                val = 32;
                break;
            }
            case 2: {
                val = 64;
                break;
            }
            case 3: {
                val = 96;
            }
        }
        if (this.getDelayRequested()) {
            val |= 0x10;
        }
        return val;
    }

    private int getAdditionalInfoSize() {
        int additionalSize = 0;
        switch (this.getDeliveryMode()) {
            case 0: {
                break;
            }
            case 1: {
                if (this._destinationHash == null) {
                    throw new IllegalStateException("Destination hash is not set");
                }
                additionalSize += 32;
                break;
            }
            case 2: {
                if (this._routerHash == null) {
                    throw new IllegalStateException("Router hash is not set");
                }
                additionalSize += 32;
                break;
            }
            case 3: {
                if (this._routerHash == null || this._tunnelId == null) {
                    throw new IllegalStateException("Router hash or tunnel ID is not set");
                }
                additionalSize += 32;
                additionalSize += 4;
            }
        }
        if (this.getDelayRequested()) {
            additionalSize += 4;
        }
        return additionalSize;
    }

    private int getAdditionalInfo(byte[] rv, int offset) {
        int origOffset = offset;
        switch (this.getDeliveryMode()) {
            case 0: {
                break;
            }
            case 1: {
                if (this._destinationHash == null) {
                    throw new IllegalStateException("Destination hash is not set");
                }
                System.arraycopy(this._destinationHash.getData(), 0, rv, offset, 32);
                offset += 32;
                break;
            }
            case 2: {
                if (this._routerHash == null) {
                    throw new IllegalStateException("Router hash is not set");
                }
                System.arraycopy(this._routerHash.getData(), 0, rv, offset, 32);
                offset += 32;
                break;
            }
            case 3: {
                if (this._routerHash == null || this._tunnelId == null) {
                    throw new IllegalStateException("Router hash or tunnel ID is not set");
                }
                System.arraycopy(this._routerHash.getData(), 0, rv, offset, 32);
                DataHelper.toLong(rv, offset += 32, 4, this._tunnelId.getTunnelId());
                offset += 4;
            }
        }
        if (this.getDelayRequested()) {
            DataHelper.toLong(rv, offset, 4, this.getDelaySeconds());
            offset += 4;
        }
        return offset - origOffset;
    }

    @Override
    @Deprecated
    public void writeBytes(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    public int writeBytes(byte[] target, int offset) {
        if (this._deliveryMode < 0 || this._deliveryMode > 3) {
            throw new IllegalStateException("Invalid data: mode = " + this._deliveryMode);
        }
        int flags = this.getFlags();
        int origOffset = offset;
        target[offset++] = (byte)flags;
        offset += this.getAdditionalInfo(target, offset);
        return offset - origOffset;
    }

    public int getSize() {
        return 1 + this.getAdditionalInfoSize();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DeliveryInstructions)) {
            return false;
        }
        DeliveryInstructions instr = (DeliveryInstructions)obj;
        return this.getDelayRequested() == instr.getDelayRequested() && this.getDelaySeconds() == instr.getDelaySeconds() && this.getDeliveryMode() == instr.getDeliveryMode() && DataHelper.eq(this.getDestination(), instr.getDestination()) && DataHelper.eq(this.getEncryptionKey(), instr.getEncryptionKey()) && DataHelper.eq(this.getRouter(), instr.getRouter()) && DataHelper.eq(this.getTunnelId(), instr.getTunnelId());
    }

    public int hashCode() {
        return (int)this.getDelaySeconds() + this.getDeliveryMode() + DataHelper.hashCode(this.getDestination()) + DataHelper.hashCode(this.getEncryptionKey()) + DataHelper.hashCode(this.getRouter()) + DataHelper.hashCode(this.getTunnelId());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[DeliveryInstructions: ");
        buf.append("\n\tDelivery mode: ");
        switch (this.getDeliveryMode()) {
            case 0: {
                buf.append("Local");
                break;
            }
            case 1: {
                buf.append("Destination");
                break;
            }
            case 2: {
                buf.append("Router");
                break;
            }
            case 3: {
                buf.append("Tunnel");
            }
        }
        if (this._delayRequested) {
            buf.append("\n\tDelay seconds: ").append(this._delaySeconds);
        }
        if (this._destinationHash != null) {
            buf.append("\n\tDestination: ").append(this._destinationHash.toBase32());
        }
        if (this._routerHash != null) {
            buf.append("\n\tRouter: ").append(this._routerHash.toBase64());
        }
        if (this._tunnelId != null) {
            buf.append("\n\tTunnelId: ").append(this._tunnelId);
        }
        return buf.toString();
    }

    private static final class LocalInstructions
    extends DeliveryInstructions {
        private LocalInstructions() {
        }

        @Override
        public void setEncrypted(boolean encrypted) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setEncryptionKey(SessionKey key) {
            throw new RuntimeException("immutable");
        }

        @Override
        public int getDeliveryMode() {
            return 0;
        }

        @Override
        public void setDeliveryMode(int mode) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setDestination(Hash dest) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setRouter(Hash router) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setTunnelId(TunnelId id) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setDelayRequested(boolean req) {
            throw new RuntimeException("immutable");
        }

        @Override
        public void setDelaySeconds(long seconds) {
            throw new RuntimeException("immutable");
        }

        @Override
        public int readBytes(byte[] data, int offset) throws DataFormatException {
            throw new RuntimeException("immutable");
        }

        @Override
        public int writeBytes(byte[] target, int offset) {
            target[offset] = 0;
            return 1;
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String toString() {
            return "[DeliveryInstructions: \n\tDelivery mode: local]";
        }
    }
}

