/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.lib;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Config;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RepositoryCache;

public class RepositoryCacheConfig {
    public static final long NO_CLEANUP = 0L;
    public static final long AUTO_CLEANUP_DELAY = -1L;
    private long expireAfterMillis = TimeUnit.HOURS.toMillis(1L);
    private long cleanupDelayMillis = -1L;

    public long getExpireAfter() {
        return this.expireAfterMillis;
    }

    public void setExpireAfter(long expireAfterMillis) {
        this.expireAfterMillis = expireAfterMillis;
    }

    public long getCleanupDelay() {
        if (this.cleanupDelayMillis < 0L) {
            return Math.min(this.expireAfterMillis / 10L, TimeUnit.MINUTES.toMillis(10L));
        }
        return this.cleanupDelayMillis;
    }

    public void setCleanupDelay(long cleanupDelayMillis) {
        this.cleanupDelayMillis = cleanupDelayMillis;
    }

    public RepositoryCacheConfig fromConfig(Config config) {
        this.setExpireAfter(config.getTimeUnit("core", null, "repositoryCacheExpireAfter", this.getExpireAfter(), TimeUnit.MILLISECONDS));
        this.setCleanupDelay(config.getTimeUnit("core", null, "repositoryCacheCleanupDelay", -1L, TimeUnit.MILLISECONDS));
        return this;
    }

    public void install() {
        RepositoryCache.reconfigure(this);
    }
}

