/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.P4MoveToChangeListOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceChangeListListener
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance(PerforceChangeListListener.class);
    private final Project myProject;
    private final PerforceNumberNameSynchronizer mySynchronizer;

    public PerforceChangeListListener(Project project, PerforceNumberNameSynchronizer synchronizer) {
        this.myProject = project;
        this.mySynchronizer = synchronizer;
    }

    public void changeListRemoved(ChangeList list) {
        String name = list.getName();
        this.applyToAllMatching(name, new MyCallback(){

            @Override
            public void call(Long number, P4Connection connection, ConnectionKey connectionKey) throws VcsException {
                PerforceRunner.getInstance(PerforceChangeListListener.this.myProject).deleteChangeList(connection, number, true, false, true);
                PerforceChangeListListener.this.mySynchronizer.removeList(number);
            }
        }, PerforceBundle.message("changelist.delete.error", new Object[0]));
    }

    private void applyToAllMatching(String listName, MyCallback numberConsumer, @Nls String errorPrefix) {
        PerforceSettings settings = PerforceSettings.getSettings(this.myProject);
        if (!settings.ENABLED) {
            return;
        }
        for (P4Connection connection : settings.getAllConnections()) {
            try {
                PerforceManager.ensureValidClient(this.myProject, connection);
            }
            catch (VcsException e) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showError(e, errorPrefix);
                LOG.info((Throwable)e);
                continue;
            }
            ConnectionKey connectionKey = connection.getConnectionKey();
            Long number = this.mySynchronizer.getNumber(connectionKey, listName);
            if (number == null) continue;
            try {
                numberConsumer.call(number, connection, connectionKey);
            }
            catch (VcsException e) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showError(e, errorPrefix);
                LOG.info((Throwable)e);
            }
        }
    }

    public void changeListRenamed(ChangeList list, String oldName) {
        this.handleChangeListRename(list, oldName);
    }

    public void changeListCommentChanged(ChangeList list, String oldComment) {
        this.handleChangeListRename(list, list.getName());
    }

    private void handleChangeListRename(final ChangeList list, String oldName) {
        final PerforceRunner runner = PerforceRunner.getInstance(this.myProject);
        this.applyToAllMatching(oldName, new MyCallback(){

            @Override
            public void call(Long number, P4Connection connection, ConnectionKey connectionKey) throws VcsException {
                runner.renameChangeList(number, PerforceChangeListListener.getP4Description(list), connection);
            }
        }, PerforceBundle.message("changelist.rename.error", new Object[0]));
        String newName = list.getName();
        if (!oldName.equals(newName)) {
            this.mySynchronizer.renameList(oldName, newName);
        }
    }

    private static String getP4Description(ChangeList list) {
        String description = list.getComment().trim();
        if (description.length() == 0) {
            description = list.getName();
        }
        return description;
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        ArrayList<Change> changesUnderPerforce = new ArrayList<Change>();
        for (Change change : changes) {
            AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)this.myProject);
            if (vcs == null || !PerforceVcs.getKey().equals((Object)vcs.getKeyInstanceMethod())) continue;
            changesUnderPerforce.add(change);
        }
        ArrayList<P4MoveToChangeListOperation> operations = new ArrayList<P4MoveToChangeListOperation>();
        String toListName = toList.getName();
        for (Change change : changesUnderPerforce) {
            operations.add(new P4MoveToChangeListOperation(change, toListName));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, PerforceBundle.message("changelist.moving.to.another", new Object[0]), PerformInBackgroundOption.ALWAYS_BACKGROUND);
    }

    private static interface MyCallback {
        public void call(Long var1, P4Connection var2, ConnectionKey var3) throws VcsException;
    }
}

