/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceBinaryContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public final class PerforceCachingContentRevision
extends PerforceContentRevision {
    private final FilePath myCurrentPath;
    private final boolean myOffline;
    private static final Logger LOG = Logger.getInstance(PerforceCachingContentRevision.class);
    private static final FileAttribute PERFORCE_CONTENT_ATTRIBUTE = new FileAttribute("p4.content", 3, false);

    private PerforceCachingContentRevision(Project project, FilePath path, FilePath currentPath, long revision, boolean offline) {
        super(project, path, revision);
        this.myCurrentPath = currentPath;
        this.myOffline = offline;
    }

    @Override
    protected byte @NotNull [] loadContent() throws VcsException {
        VirtualFile vFile;
        assert (this.myFilePath != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadContent: " + this.myCurrentPath);
        }
        if ((vFile = this.myCurrentPath.getVirtualFile()) == null) {
            byte[] byArray = super.loadContent();
            if (byArray == null) {
                PerforceCachingContentRevision.$$$reportNull$$$0(0);
            }
            return byArray;
        }
        byte[] content = null;
        try {
            content = this.loadCachedContent(vFile);
        }
        catch (InvalidVirtualFileAccessException e) {
            throw new VcsException(PerforceBundle.message("error.file.has.been.deleted", vFile.getPath()));
        }
        catch (IOException e) {
            // empty catch block
        }
        if (content == null) {
            if (!PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
                throw new VcsException(PerforceBundle.message("error.can.t.load.content.perforce.is.offline", new Object[0]));
            }
            content = super.loadContent();
            try {
                PerforceCachingContentRevision.saveCachedContent(vFile, this.myRevision, content);
            }
            catch (InvalidVirtualFileAccessException e) {
                throw new VcsException(PerforceBundle.message("error.file.has.been.deleted", vFile.getPath()));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (content == null) {
            PerforceCachingContentRevision.$$$reportNull$$$0(1);
        }
        return content;
    }

    private byte @Nullable [] loadCachedContent(VirtualFile vFile) throws IOException {
        byte[] content;
        if (LOG.isDebugEnabled()) {
            LOG.debug("loadCachedContent: " + vFile + ", offline=" + this.myOffline);
        }
        if (this.myOffline && (content = LastUnchangedContentTracker.getLastUnchangedContent((VirtualFile)vFile)) != null) {
            return content;
        }
        try (AttributeInputStream stream = PERFORCE_CONTENT_ATTRIBUTE.readFileAttribute(vFile);){
            if (stream == null) {
                byte[] byArray = null;
                return byArray;
            }
            long cachedRevision = stream.readLong();
            if (cachedRevision != this.myRevision) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = FileUtil.loadBytes((InputStream)stream, (int)stream.readInt());
            return byArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void saveCachedContent(VirtualFile vFile, long revision, byte @NotNull [] byArray) throws IOException {
        if (byArray == null) {
            PerforceCachingContentRevision.$$$reportNull$$$0(2);
        }
        try (AttributeOutputStream stream = PERFORCE_CONTENT_ATTRIBUTE.writeFileAttribute(vFile);){
            void content;
            stream.writeLong(revision);
            stream.writeInt(((void)content).length);
            stream.write((byte[])content);
        }
    }

    public static void removeCachedContent(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            PerforceCachingContentRevision.$$$reportNull$$$0(3);
        }
        try {
            PerforceCachingContentRevision.saveCachedContent(vFile, -1L, ArrayUtilRt.EMPTY_BYTE_ARRAY);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static ContentRevision create(Project project, FilePath path, long haveRevision) {
        if (path.getFileType().isBinary()) {
            return new PerforceBinaryContentRevision(project, path, haveRevision);
        }
        return new PerforceCachingContentRevision(project, path, path, haveRevision, false);
    }

    public static ContentRevision createOffline(Project project, FilePath path, FilePath currentPath) {
        if (path.getFileType().isBinary()) {
            return new PerforceBinaryContentRevision(project, path, -1L);
        }
        return new PerforceCachingContentRevision(project, path, currentPath, -1L, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/PerforceCachingContentRevision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/PerforceCachingContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveCachedContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeCachedContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

