/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyTypeCheckVisitorHelper {
    @Contract(value="null -> false")
    static boolean hasTupleInitializer(@Nullable GrExpression initializer) {
        return initializer instanceof GrListOrMap && ((GrListOrMap)initializer).getConstructorReference() != null;
    }

    @NotNull
    public static PsiElement getExpressionPartToHighlight(@NotNull GrExpression expr) {
        if (expr == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(0);
        }
        GrExpression grExpression = expr instanceof GrClosableBlock ? ((GrClosableBlock)expr).getLBrace() : expr;
        if (grExpression == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(1);
        }
        return grExpression;
    }

    public static boolean hasErrorElements(@Nullable PsiElement e) {
        if (e == null) {
            return false;
        }
        for (PsiElement child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOperatorWithSimpleTypes(GrBinaryExpression binary, GroovyResolveResult result2) {
        if (result2.getElement() != null && result2.isApplicable()) {
            return false;
        }
        GrExpression left = binary.getLeftOperand();
        GrExpression right = binary.getRightOperand();
        PsiType ltype = left.getType();
        PsiType rtype = right != null ? right.getType() : null;
        return TypesUtil.isNumericType(ltype) && (rtype == null || TypesUtil.isNumericType(rtype));
    }

    @Nullable
    public static String getLValueVarName(@NotNull PsiElement highlight) {
        PsiElement resolved;
        PsiElement parent2;
        if (highlight == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(2);
        }
        if ((parent2 = highlight.getParent()) instanceof GrVariable) {
            return ((GrVariable)parent2).getName();
        }
        if (highlight instanceof GrReferenceExpression && parent2 instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent2).getLValue() == highlight && (resolved = ((GrReferenceExpression)highlight).resolve()) instanceof GrVariable && PsiUtil.isLocalVariable(resolved)) {
            return ((GrVariable)resolved).getName();
        }
        return null;
    }

    @Nullable
    public static List<GrExpression> getExpressionArgumentsOfCall(@NotNull GrArgumentList argumentList) {
        if (argumentList == null) {
            GroovyTypeCheckVisitorHelper.$$$reportNull$$$0(3);
        }
        ArrayList<GrExpression> args = new ArrayList<GrExpression>();
        for (GroovyPsiElement arg : argumentList.getAllArguments()) {
            if (arg instanceof GrSpreadArgument) {
                GrExpression spreaded = ((GrSpreadArgument)arg).getArgument();
                if (spreaded instanceof GrListOrMap && !((GrListOrMap)spreaded).isMap()) {
                    Collections.addAll(args, ((GrListOrMap)spreaded).getInitializers());
                    continue;
                }
                return null;
            }
            if (arg instanceof GrExpression) {
                args.add((GrExpression)arg);
                continue;
            }
            if (!(arg instanceof GrNamedArgument)) continue;
            args.add(((GrNamedArgument)arg).getExpression());
        }
        PsiElement parent2 = argumentList.getParent();
        if (parent2 instanceof GrIndexProperty && PsiUtil.isLValue((GroovyPsiElement)parent2)) {
            args.add(TypeInferenceHelper.getInitializerFor((GrExpression)parent2));
        } else if (parent2 instanceof GrMethodCallExpression) {
            ContainerUtil.addAll(args, (Object[])((GrMethodCallExpression)parent2).getClosureArguments());
        }
        return args;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitorHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitorHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionPartToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionPartToHighlight";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLValueVarName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionArgumentsOfCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

