/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style.inference;

import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.UnreachableException;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u00a2\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a0\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a@\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00060\u0001\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0011\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0001\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u0004\u001a,\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00182\u0006\u0010\u0003\u001a\u00020\t2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\tH\u0002\u001a\u0010\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\t\u001a\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00012\b\u0010$\u001a\u0004\u0018\u00010#H\u0002\u001a\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0003\u001a\u00020\tH\u0002\u001a\u0018\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0014\u001a\u0010\u0010,\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\tH\u0000\u001a\u0018\u0010-\u001a\u0004\u0018\u00010&2\u0006\u0010\u0003\u001a\u00020\t2\u0006\u0010.\u001a\u00020\f\u001a\"\u0010/\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\t2\u0006\u00100\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u001a\u00101\u001a\u0004\u0018\u00010\t2\u0006\u00102\u001a\u0002032\u0006\u0010\u0003\u001a\u00020\tH\u0002\u001a\u0018\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\tH\u0002\u001a\u0006\u00107\u001a\u000208\u001a\u001c\u00109\u001a\u00020\u0002*\u00020:2\u0006\u0010;\u001a\u00020\u00072\b\u0010<\u001a\u0004\u0018\u00010\u0014\u001a\f\u0010=\u001a\u00020\u0014*\u00020\u0014H\u0002\u001a\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011*\b\u0012\u0004\u0012\u00020\u00140\u0011\u001a\n\u0010?\u001a\u00020\u0014*\u00020\u0014\u001a\u001c\u0010@\u001a\u00020\u0007*\u00020\u00072\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\u0007H\u0002\u001a\f\u0010C\u001a\u00020\f*\u0004\u0018\u00010\u0014\u001a\f\u0010D\u001a\u00020\f*\u0004\u0018\u00010\u0014\u001a\f\u0010E\u001a\u0004\u0018\u00010F*\u00020G\u001a\u001f\u0010H\u001a\u00020\u0014*\u00020\u001c2\u0006\u0010I\u001a\u00020\u00142\b\b\u0002\u0010J\u001a\u00020\bH\u0086\u0010\u001a\u0012\u0010K\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010\u0003\u001a\u00020\t\u001a\u000e\u0010L\u001a\u0004\u0018\u00010#*\u0004\u0018\u00010\u0014\u001a\u000e\u0010M\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u0014\u001a\n\u0010N\u001a\u00020\u0014*\u00020\u0002*\u0016\u0010O\"\b\u0012\u0004\u0012\u00020Q0P2\b\u0012\u0004\u0012\u00020Q0P\u00a8\u0006R"}, d2={"allOuterTypeParameters", "", "Lcom/intellij/psi/PsiTypeParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "buildVirtualEnvironmentForMethod", "Lkotlin/Pair;", "", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "newTypeParameterListText", "omitBody", "", "cartesianProduct", "T", "U", "leftRange", "", "rightRange", "compress", "Lcom/intellij/psi/PsiType;", "types", "convertToGroovyMethod", "createVirtualMethod", "Lcom/intellij/psi/SmartPsiElementPointer;", "typeParameterList", "Lcom/intellij/psi/PsiTypeParameterList;", "createVirtualToActualSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "virtualMethod", "originalMethod", "disableInteriorReturnTypeInference", "", "findOverridableMethod", "getContainingClasses", "Lcom/intellij/psi/PsiClass;", "startClass", "getFileScope", "Lcom/intellij/psi/search/SearchScope;", "getInferenceVariable", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceVariable;", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "variableType", "getOriginalMethod", "getSearchScope", "shouldUseReducedScope", "insertTypeParameterList", "methodText", "locateMethod", "file", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyFileBase;", "methodsAgree", "pattern", "tested", "unreachable", "", "createProperTypeParameter", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;", "name", "superType", "erasure", "flattenIntersections", "forceWildcardsAsTypeArguments", "insert", "position", "content", "isClosureTypeDeep", "isTypeParameter", "properResolve", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "Lcom/intellij/psi/PsiElement;", "recursiveSubstitute", "type", "recursionDepth", "removeForeignTypeParameters", "resolve", "typeParameter", "upperBound", "InferenceGraphNode", "Lcom/intellij/psi/impl/source/resolve/graphInference/InferenceVariablesOrder$InferenceGraphNode;", "Lorg/jetbrains/plugins/groovy/intentions/style/inference/graph/InferenceUnitNode;", "intellij.groovy"})
public final class InferenceProcessUtilKt {
    @Nullable
    public static final InferenceVariable getInferenceVariable(@NotNull GroovyInferenceSession session, @NotNull PsiType variableType) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter((Object)variableType, (String)"variableType");
        return session.getInferenceVariable(session.substituteWithInferenceVariables(variableType));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Iterable<PsiType> flattenIntersections(@NotNull Iterable<? extends PsiType> $this$flattenIntersections) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$flattenIntersections, (String)"$this$flattenIntersections");
        Iterable<? extends PsiType> $this$flatMap$iv = $this$flattenIntersections;
        boolean $i$f$flatMap = false;
        Iterable<? extends PsiType> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Collection collection;
            PsiType it = (PsiType)element$iv$iv;
            boolean bl = false;
            if (it instanceof PsiIntersectionType) {
                Set set = PsiIntersectionType.flatten((PsiType[])((PsiIntersectionType)it).getConjuncts(), (Set)new LinkedHashSet());
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"PsiIntersectionType.flat\u2026onjuncts, mutableSetOf())");
                collection = set;
            } else {
                collection = CollectionsKt.listOf((Object)it);
            }
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final PsiTypeParameter createProperTypeParameter(@NotNull GroovyPsiElementFactory $this$createProperTypeParameter, @NotNull String name, @Nullable PsiType superType) {
        Intrinsics.checkNotNullParameter((Object)$this$createProperTypeParameter, (String)"$this$createProperTypeParameter");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (superType instanceof PsiIntersectionType) {
            v0 = ((PsiIntersectionType)superType).getConjuncts();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"superType.conjuncts");
            v1 = ArraysKt.asList((Object[])v0);
        } else {
            v1 = superType != null ? CollectionsKt.listOf((Object)superType) : CollectionsKt.emptyList();
        }
        extendsTypes = v1;
        $this$filter$iv = extendsTypes;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (PsiType)element$iv$iv;
            $i$a$-filter-InferenceProcessUtilKt$createProperTypeParameter$filteredSupertypes$1 = false;
            if (it.equalsToText("java.lang.Object") || it.equalsToText("groovy.lang.GroovyObject")) ** GOTO lbl-1000
            v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            v3 = v2.getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.canonicalText");
            if (!StringsKt.contains$default((CharSequence)v3, (char)'-', (boolean)false, (int)2, null)) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        filteredSupertypes = (List)destination$iv$iv;
        $i$f$filter = filteredSupertypes;
        extendsBound = $i$f$filter.isEmpty() == false != false ? " extends " + CollectionsKt.joinToString$default((Iterable)filteredSupertypes, (CharSequence)"&", null, null, (int)0, null, (Function1)createProperTypeParameter.extendsBound.1.INSTANCE, (int)30, null) : "";
        method = "public <" + name + " " + extendsBound + "> void foo(){}";
        v5 = $this$createProperTypeParameter.createMethodFromText(method, null);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"createMethodFromText(method, null)");
        v6 = v5.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"createMethodFromText(method, null).typeParameters");
        v7 = ArraysKt.single((Object[])v6);
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"createMethodFromText(met\u2026).typeParameters.single()");
        return (PsiTypeParameter)v7;
    }

    @NotNull
    public static final PsiType forceWildcardsAsTypeArguments(@NotNull PsiType $this$forceWildcardsAsTypeArguments) {
        Intrinsics.checkNotNullParameter((Object)$this$forceWildcardsAsTypeArguments, (String)"$this$forceWildcardsAsTypeArguments");
        PsiClass psiClass = InferenceProcessUtilKt.resolve($this$forceWildcardsAsTypeArguments);
        if (psiClass == null || (psiClass = psiClass.getManager()) == null) {
            return $this$forceWildcardsAsTypeArguments;
        }
        PsiClass manager = psiClass;
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(manager.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026Instance(manager.project)");
        GroovyPsiElementFactory factory = groovyPsiElementFactory;
        Object object = $this$forceWildcardsAsTypeArguments.accept((PsiTypeVisitor)new PsiTypeMapper((PsiManager)manager, factory){
            final /* synthetic */ PsiManager $manager;
            final /* synthetic */ GroovyPsiElementFactory $factory;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public PsiType visitClassType(@NotNull PsiClassType classType) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
                PsiType[] psiTypeArray = classType.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"classType.parameters");
                PsiType[] $this$map$iv = psiTypeArray;
                boolean $i$f$map = false;
                PsiType[] psiTypeArray2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    PsiWildcardType psiWildcardType;
                    void it;
                    void item$iv$iv;
                    void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    PsiType accepted = (PsiType)it.accept((PsiTypeVisitor)this);
                    if (accepted instanceof PsiWildcardType) {
                        psiWildcardType = (PsiWildcardType)accepted;
                    } else if (accepted != null && Intrinsics.areEqual((Object)accepted, (Object)PsiType.NULL) ^ true) {
                        PsiWildcardType psiWildcardType2 = PsiWildcardType.createExtends((PsiManager)this.$manager, (PsiType)accepted);
                        psiWildcardType = psiWildcardType2;
                        Intrinsics.checkNotNullExpressionValue((Object)psiWildcardType2, (String)"PsiWildcardType.createExtends(manager, accepted)");
                    } else {
                        PsiWildcardType psiWildcardType3 = PsiWildcardType.createUnbounded((PsiManager)this.$manager);
                        psiWildcardType = psiWildcardType3;
                        Intrinsics.checkNotNullExpressionValue((Object)psiWildcardType3, (String)"PsiWildcardType.createUnbounded(manager)");
                    }
                    PsiWildcardType psiWildcardType4 = psiWildcardType;
                    collection.add(psiWildcardType4);
                }
                List mappedParameters = (List)destination$iv$iv;
                PsiClass resolvedClass = classType.resolve();
                if (resolvedClass != null) {
                    Collection $this$toTypedArray$iv = mappedParameters;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    PsiWildcardType[] psiWildcardTypeArray = thisCollection$iv.toArray(new PsiWildcardType[0]);
                    if (psiWildcardTypeArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    PsiType[] psiTypeArray3 = (PsiType[])psiWildcardTypeArray;
                    PsiClassType psiClassType = this.$factory.createType(resolvedClass, Arrays.copyOf(psiTypeArray3, psiTypeArray3.length));
                    Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"factory.createType(resol\u2026arameters.toTypedArray())");
                    return (PsiType)psiClassType;
                }
                return (PsiType)classType;
            }
            {
                this.$manager = $captured_local_variable$0;
                this.$factory = $captured_local_variable$1;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"accept(object : PsiTypeM\u2026sType\n      }\n    }\n\n  })");
        return (PsiType)object;
    }

    public static final boolean isClosureTypeDeep(@Nullable PsiType $this$isClosureTypeDeep) {
        PsiClassType psiClassType;
        PsiClassType psiClassType2;
        PsiClassType psiClassType3 = $this$isClosureTypeDeep;
        if (!(psiClassType3 instanceof PsiClassType)) {
            psiClassType3 = null;
        }
        return ((psiClassType2 = (PsiClassType)psiClassType3) != null && (psiClassType2 = psiClassType2.rawType()) != null ? psiClassType2.equalsToText("groovy.lang.Closure") : false) || ((psiClassType = $this$isClosureTypeDeep) != null && (psiClassType = InferenceProcessUtilKt.typeParameter((PsiType)psiClassType)) != null && (psiClassType = psiClassType.getExtendsListTypes()) != null && (psiClassType = (PsiClassType)ArraysKt.singleOrNull((Object[])psiClassType)) != null && (psiClassType = psiClassType.rawType()) != null ? psiClassType.equalsToText("groovy.lang.Closure") : false);
    }

    @NotNull
    public static final PsiType recursiveSubstitute(@NotNull PsiSubstitutor $this$recursiveSubstitute, @NotNull PsiType type2, int recursionDepth) {
        while (true) {
            Intrinsics.checkNotNullParameter((Object)$this$recursiveSubstitute, (String)"$this$recursiveSubstitute");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            if (recursionDepth == 0) {
                Object object = type2.accept((PsiTypeVisitor)new PsiTypeMapper(){

                    @NotNull
                    public PsiType visitClassType(@NotNull PsiClassType classType) {
                        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
                        PsiClassType psiClassType = classType.rawType();
                        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"classType.rawType()");
                        return (PsiType)psiClassType;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"type.accept(object : Psi\u2026.rawType()\n      }\n    })");
                return (PsiType)object;
            }
            PsiType substituted = $this$recursiveSubstitute.substitute(type2);
            if (Intrinsics.areEqual((Object)substituted, (Object)type2)) break;
            Intrinsics.checkNotNullExpressionValue((Object)substituted, (String)"substituted");
            --recursionDepth;
        }
        return type2;
    }

    public static /* synthetic */ PsiType recursiveSubstitute$default(PsiSubstitutor psiSubstitutor, PsiType psiType, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 20;
        }
        return InferenceProcessUtilKt.recursiveSubstitute(psiSubstitutor, psiType, n);
    }

    @NotNull
    public static final Void unreachable() {
        throw (Throwable)new UnreachableException();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, U> List<Pair<T, U>> cartesianProduct(@NotNull Iterable<? extends T> leftRange, @NotNull Iterable<? extends U> rightRange) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(leftRange, (String)"leftRange");
        Intrinsics.checkNotNullParameter(rightRange, (String)"rightRange");
        Iterable<? extends T> $this$flatMap$iv = leftRange;
        boolean $i$f$flatMap = false;
        Iterable<? extends T> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Object element$iv$iv;
            Object left = element$iv$iv = iterator2.next();
            boolean bl = false;
            Iterable<? extends U> $this$map$iv = rightRange;
            boolean $i$f$map = false;
            Iterable<? extends U> iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Pair pair = TuplesKt.to(left, (Object)it);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isTypeParameter(@Nullable PsiType $this$isTypeParameter) {
        return InferenceProcessUtilKt.resolve($this$isTypeParameter) instanceof PsiTypeParameter;
    }

    @Nullable
    public static final PsiTypeParameter typeParameter(@Nullable PsiType $this$typeParameter) {
        PsiClass psiClass = InferenceProcessUtilKt.resolve($this$typeParameter);
        if (!(psiClass instanceof PsiTypeParameter)) {
            psiClass = null;
        }
        return (PsiTypeParameter)psiClass;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiMethod findOverridableMethod(@NotNull GrMethod method) {
        Object v10;
        block10: {
            void $this$firstOrNull$iv;
            boolean bl;
            PsiClass[] $this$flatMapTo$iv$iv;
            Object $this$flatMap$iv;
            boolean hasJavaLangOverride;
            PsiAnnotation element$iv;
            PsiAnnotation[] $this$any$iv;
            Object[] superMethods;
            PsiClass clazz;
            block9: {
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                PsiClass psiClass = method.getContainingClass();
                if (psiClass == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"method.containingClass ?: return null");
                clazz = psiClass;
                Project project = method.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"method.project");
                if (project.isDefault()) {
                    return null;
                }
                superMethods = method.findSuperMethods();
                PsiAnnotation[] psiAnnotationArray = method.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"method.annotations");
                $this$any$iv = psiAnnotationArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiAnnotation it = element$iv = $this$any$iv[i];
                    boolean bl22 = false;
                    PsiAnnotation psiAnnotation = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"it");
                    if (!Intrinsics.areEqual((Object)psiAnnotation.getQualifiedName(), (Object)"java.lang.Override")) continue;
                    bl2 = true;
                    break block9;
                }
                bl2 = hasJavaLangOverride = false;
            }
            if (hasJavaLangOverride) {
                Intrinsics.checkNotNullExpressionValue((Object)superMethods, (String)"superMethods");
                $this$any$iv = superMethods;
                if (!($this$any$iv.length == 0)) {
                    return (PsiMethod)ArraysKt.first((Object[])superMethods);
                }
            }
            PsiClass[] candidateMethodsDomain = hasJavaLangOverride ? clazz.getSupers() : clazz.getInterfaces();
            Object[] objectArray = clazz.getSupers();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"clazz.supers");
            Object[] objectArray2 = ArraysKt.plus((Object[])objectArray, (Object)clazz);
            boolean $i$f$flatMap = false;
            element$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (PsiClass element$iv$iv : $this$flatMapTo$iv$iv) {
                PsiClass it = element$iv$iv;
                bl = false;
                Object[] objectArray3 = it.findMethodsByName(method.getName(), true);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"it.findMethodsByName(method.name, true)");
                Iterable list$iv$iv = ArraysKt.asIterable((Object[])objectArray3);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (PsiClass[])((List)destination$iv$iv);
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object t : $this$flatMapTo$iv$iv) {
                PsiMethod it = (PsiMethod)t;
                boolean bl3 = false;
                Object[] objectArray4 = it.findSuperMethods();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray4, (String)"it.findSuperMethods()");
                Iterable list$iv$iv = ArraysKt.asIterable((Object[])objectArray4);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List alreadyOverriddenMethods = (List)destination$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)candidateMethodsDomain, (String)"candidateMethodsDomain");
            $this$flatMap$iv = candidateMethodsDomain;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            int n = $this$flatMapTo$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                PsiClass element$iv$iv;
                PsiClass it = element$iv$iv = $this$flatMapTo$iv$iv[i];
                bl = false;
                Object[] objectArray5 = it.findMethodsByName(method.getName(), true);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray5, (String)"it.findMethodsByName(method.name, true)");
                Iterable list$iv$iv = ArraysKt.asIterable((Object[])objectArray5);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = CollectionsKt.subtract((Iterable)((List)destination$iv$iv), (Iterable)alreadyOverriddenMethods);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                PsiMethod it = (PsiMethod)element$iv2;
                boolean bl4 = false;
                PsiMethod psiMethod = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"it");
                if (!InferenceProcessUtilKt.methodsAgree(psiMethod, method)) continue;
                v10 = element$iv2;
                break block10;
            }
            v10 = null;
        }
        return v10;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean methodsAgree(PsiMethod pattern, GrMethod tested) {
        boolean bl;
        block9: {
            block11: {
                block10: {
                    if (Intrinsics.areEqual((Object)pattern.getName(), (Object)tested.getName()) ^ true) break block10;
                    GrParameterList grParameterList = tested.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)grParameterList, (String)"tested.parameterList");
                    int n = grParameterList.getParametersCount();
                    PsiParameterList psiParameterList = pattern.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"pattern.parameterList");
                    if (n == psiParameterList.getParametersCount()) break block11;
                }
                return false;
            }
            Object[] objectArray = pattern.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"pattern.parameters");
            Object[] objectArray2 = tested.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"tested.parameters");
            List parameterList = ArraysKt.zip((Object[])objectArray, (Object[])objectArray2);
            Iterable $this$all$iv = parameterList;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    GrParameter testedParameter;
                    Pair $dstr$patternParameter$testedParameter = (Pair)element$iv;
                    boolean bl3 = false;
                    JvmParameter jvmParameter = (JvmParameter)$dstr$patternParameter$testedParameter.component1();
                    GrParameter grParameter = testedParameter = (GrParameter)$dstr$patternParameter$testedParameter.component2();
                    if ((grParameter != null ? grParameter.getTypeElement() : null) == null) {
                        bl2 = true;
                    } else {
                        void patternParameter;
                        void v8 = patternParameter;
                        JvmType patternType = v8 != null ? v8.getType() : null;
                        JvmType erasedPatternType = patternType instanceof PsiType ? (JvmType)InferenceProcessUtilKt.erasure((PsiType)patternType) : patternType;
                        PsiType psiType = testedParameter.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"testedParameter.type");
                        PsiType erasedTestedType = InferenceProcessUtilKt.erasure(psiType);
                        bl2 = Intrinsics.areEqual((Object)erasedPatternType, (Object)erasedTestedType);
                    }
                    if (bl2) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final PsiType erasure(PsiType $this$erasure) {
        PsiType psiType = TypeConversionUtil.erasure((PsiType)$this$erasure);
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"TypeConversionUtil.erasure(this)");
        return psiType;
    }

    private static final List<PsiClass> getContainingClasses(PsiClass startClass) {
        getContainingClasses.1 $fun$getContainingClassesMutable$1 = getContainingClasses.1.INSTANCE;
        return $fun$getContainingClassesMutable$1.invoke(startClass);
    }

    private static final Pair<String, Integer> buildVirtualEnvironmentForMethod(GrMethod method, String newTypeParameterListText, boolean omitBody) {
        String string;
        Object object;
        block11: {
            block10: {
                PsiFile psiFile;
                object = method.getContainingFile();
                if (object == null) break block10;
                PsiFile it = psiFile = object;
                boolean bl = false;
                object = it instanceof GroovyFile ? psiFile : null;
                if (object != null && (object = object.getText()) != null) break block11;
            }
            return null;
        }
        Object text = object;
        List<PsiClass> containingClasses = InferenceProcessUtilKt.getContainingClasses(method.getContainingClass());
        List classRepresentations = new ArrayList();
        List fieldRepresentations = new ArrayList();
        for (PsiClass containingClass : containingClasses) {
            Object[] objectArray = containingClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"containingClass.fields");
            fieldRepresentations.add(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"\n", null, null, (int)0, null, (Function1)buildVirtualEnvironmentForMethod.1.INSTANCE, (int)30, null));
            TextRange textRange = containingClass.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"containingClass.textRange");
            int startOffset = textRange.getStartOffset();
            PsiElement psiElement = containingClass.getLBrace();
            int lBraceOffset = psiElement != null ? psiElement.getTextOffset() : startOffset;
            classRepresentations.add(StringsKt.substring((String)text, (IntRange)RangesKt.until((int)startOffset, (int)lBraceOffset)));
        }
        String header2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.zip((Iterable)classRepresentations, (Iterable)fieldRepresentations), (CharSequence)"", null, null, (int)0, null, (Function1)buildVirtualEnvironmentForMethod.header.1.INSTANCE, (int)30, null);
        String footer = StringsKt.repeat((CharSequence)" } ", (int)containingClasses.size());
        if (omitBody) {
            String string2 = method.getText();
            if (string2 != null) {
                Object object2 = method.getBlock();
                if (object2 == null || (object2 = object2.getText()) == null) {
                    object2 = "";
                }
                string = StringsKt.removeSuffix((String)string2, (CharSequence)((CharSequence)object2));
            } else {
                string = null;
            }
        } else {
            string = method.getText();
        }
        if (string == null) {
            return null;
        }
        String methodText = string;
        String resultMethodText = InferenceProcessUtilKt.insertTypeParameterList(method, methodText, newTypeParameterListText);
        return TuplesKt.to((Object)(header2 + resultMethodText + footer), (Object)header2.length());
    }

    private static final String insertTypeParameterList(GrMethod method, String methodText, String newTypeParameterListText) {
        String string;
        PsiTypeParameterList typeParameterList;
        Object object;
        int methodStartOffset = UtilsKt.getStartOffset((PsiElement)method);
        PsiTypeParameterList psiTypeParameterList = method.getTypeParameterList();
        if (psiTypeParameterList != null && (psiTypeParameterList = psiTypeParameterList.getTextRange()) != null) {
            PsiTypeParameterList psiTypeParameterList2;
            PsiTypeParameterList it = psiTypeParameterList2 = psiTypeParameterList;
            boolean bl = false;
            object = !it.isEmpty() ? psiTypeParameterList2 : null;
        } else {
            object = typeParameterList = null;
        }
        if (typeParameterList != null && newTypeParameterListText != null) {
            int startOffset = typeParameterList.getStartOffset() - methodStartOffset;
            String string2 = methodText;
            int n = typeParameterList.getEndOffset() - methodStartOffset;
            String erasedText = ((Object)StringsKt.removeRange((CharSequence)string2, (int)startOffset, (int)n)).toString();
            string = InferenceProcessUtilKt.insert(erasedText, startOffset, newTypeParameterListText);
        } else if (typeParameterList == null) {
            String string3;
            int insertionOffset;
            int n;
            Object curtext = methodText;
            GrModifierList grModifierList = method.getModifierList();
            Intrinsics.checkNotNullExpressionValue((Object)grModifierList, (String)"method.modifierList");
            if (grModifierList.getModifierFlags() == 0) {
                curtext = "def " + (String)curtext;
                n = 3;
            } else {
                PsiElement psiElement = method.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"method.firstChild");
                n = insertionOffset = UtilsKt.getEndOffset((PsiElement)psiElement) - methodStartOffset;
            }
            if ((string3 = newTypeParameterListText) == null) {
                string3 = "<>";
            }
            String actualTypeParameterListText = string3;
            string = InferenceProcessUtilKt.insert((String)curtext, insertionOffset, actualTypeParameterListText);
        } else {
            string = methodText;
        }
        String resultMethodText = string;
        return resultMethodText;
    }

    private static final String insert(String $this$insert, int position, String content) {
        return StringsKt.take((String)$this$insert, (int)position) + content + StringsKt.drop((String)$this$insert, (int)position);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SmartPsiElementPointer<GrMethod> createVirtualMethod(@NotNull GrMethod method, @Nullable PsiTypeParameterList typeParameterList, boolean omitBody) {
        PsiElement psiElement;
        block5: {
            block4: {
                void fileText;
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                PsiTypeParameterList psiTypeParameterList = typeParameterList;
                Pair<String, Integer> pair = InferenceProcessUtilKt.buildVirtualEnvironmentForMethod(method, psiTypeParameterList != null ? psiTypeParameterList.getText() : null, omitBody);
                if (pair == null) {
                    return null;
                }
                Pair<String, Integer> pair2 = pair;
                String string = (String)pair2.component1();
                int offset = ((Number)pair2.component2()).intValue();
                GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(method.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026tInstance(method.project)");
                GroovyPsiElementFactory factory = groovyPsiElementFactory;
                GroovyFile groovyFile = factory.createGroovyFile((CharSequence)fileText, false, method);
                Intrinsics.checkNotNullExpressionValue((Object)groovyFile, (String)"factory.createGroovyFile(fileText, false, method)");
                GroovyFile newFile = groovyFile;
                psiElement = newFile.findElementAt(offset);
                if (psiElement == null) break block4;
                PsiElement $this$parentOfType$iv = psiElement;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                psiElement = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrMethod.class, (boolean)true);
                if (psiElement != null) break block5;
            }
            return null;
        }
        PsiElement virtualMethod = psiElement;
        InferenceProcessUtilKt.disableInteriorReturnTypeInference((GrMethod)virtualMethod);
        return SmartPointerManager.createPointer((PsiElement)virtualMethod);
    }

    public static /* synthetic */ SmartPsiElementPointer createVirtualMethod$default(GrMethod grMethod, PsiTypeParameterList psiTypeParameterList, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            psiTypeParameterList = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return InferenceProcessUtilKt.createVirtualMethod(grMethod, psiTypeParameterList, bl);
    }

    private static final void disableInteriorReturnTypeInference(GrMethod virtualMethod) {
        virtualMethod.putUserData(InferenceKt.getForbidInteriorReturnTypeInference(), Unit.INSTANCE);
    }

    @Nullable
    public static final GrMethod convertToGroovyMethod(@NotNull PsiMethod method) {
        GrMethod grMethod;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(method.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026tInstance(method.project)");
        GroovyPsiElementFactory factory = groovyPsiElementFactory;
        if (method.isConstructor()) {
            Object object = method.getBody();
            if (object == null || (object = object.getText()) == null) {
                return null;
            }
            Object constructorBody = object;
            grMethod = factory.createConstructorFromText(method.getName(), (CharSequence)constructorBody, (PsiElement)method);
        } else {
            String string = method.getText();
            if (string == null) {
                return null;
            }
            String methodText = string;
            grMethod = factory.createMethodFromText(methodText, (PsiElement)method);
        }
        return grMethod;
    }

    @Nullable
    public static final PsiClass resolve(@Nullable PsiType $this$resolve) {
        PsiType psiType = $this$resolve;
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiSubstitutor removeForeignTypeParameters(@NotNull PsiSubstitutor $this$removeForeignTypeParameters, @NotNull GrMethod method) {
        Intrinsics.checkNotNullParameter((Object)$this$removeForeignTypeParameters, (String)"$this$removeForeignTypeParameters");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List typeParameters = new ArrayList();
        List substitutions = new ArrayList();
        Object[] objectArray = method.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"method.typeParameters");
        List allowedTypeParameters = ArraysKt.asList((Object[])objectArray);
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(method.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"GroovyPsiElementFactory.\u2026tInstance(method.project)");
        GroovyPsiElementFactory factory = groovyPsiElementFactory;
        PsiWildcardType psiWildcardType = PsiWildcardType.createUnbounded((PsiManager)method.getManager());
        Intrinsics.checkNotNullExpressionValue((Object)psiWildcardType, (String)"PsiWildcardType.createUnbounded(method.manager)");
        PsiWildcardType unboundedWildcard = psiWildcardType;
        Iterator iterator2 = $this$removeForeignTypeParameters.getSubstitutionMap().entrySet().iterator();
        while (iterator2.hasNext()) {
            void typeParameter;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            PsiTypeParameter psiTypeParameter = (PsiTypeParameter)entry2.getKey();
            entry2 = entry;
            PsiType type2 = (PsiType)entry2.getValue();
            void v3 = typeParameter;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"typeParameter");
            typeParameters.add(v3);
            @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"org/jetbrains/plugins/groovy/intentions/style/inference/InferenceProcessUtilKt$removeForeignTypeParameters$ForeignTypeParameterEraser", "Lcom/intellij/psi/PsiTypeMapper;", "(Ljava/util/List;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;Lcom/intellij/psi/PsiWildcardType;Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElementFactory;)V", "visitClassType", "Lcom/intellij/psi/PsiType;", "classType", "Lcom/intellij/psi/PsiClassType;", "visitIntersectionType", "intersectionType", "Lcom/intellij/psi/PsiIntersectionType;", "visitWildcardType", "wildcardType", "Lcom/intellij/psi/PsiWildcardType;", "intellij.groovy"})
            public final class ForeignTypeParameterEraser
            extends PsiTypeMapper {
                final /* synthetic */ List $allowedTypeParameters;
                final /* synthetic */ GrMethod $method;
                final /* synthetic */ PsiWildcardType $unboundedWildcard;
                final /* synthetic */ GroovyPsiElementFactory $factory;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public PsiType visitClassType(@NotNull PsiClassType classType) {
                    void $this$toTypedArray$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
                    PsiTypeParameter typeParameter = InferenceProcessUtilKt.typeParameter((PsiType)classType);
                    if (typeParameter != null && !this.$allowedTypeParameters.contains(typeParameter)) {
                        Object[] objectArray = typeParameter.getExtendsListTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"typeParameter.extendsListTypes");
                        PsiType psiType = InferenceProcessUtilKt.compress(ArraysKt.asList((Object[])objectArray));
                        if (psiType == null) {
                            psiType = (PsiType)InferenceDriverUtilKt.getJavaLangObject(this.$method);
                        }
                        return (PsiType)psiType.accept((PsiTypeVisitor)this);
                    }
                    PsiClass psiClass = classType.resolve();
                    if (psiClass == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"classType.resolve() ?: return null");
                    PsiClass resolvedClass = psiClass;
                    PsiType[] psiTypeArray = classType.getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"classType.parameters");
                    Object $this$map$iv = psiTypeArray;
                    boolean $i$f$map = false;
                    PsiType[] psiTypeArray2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((PsiType[])$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var13_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        PsiType psiType = it;
                        if (psiType == null || (psiType = (PsiType)psiType.accept((PsiTypeVisitor)this)) == null) {
                            psiType = (PsiType)this.$unboundedWildcard;
                        }
                        PsiType psiType2 = psiType;
                        collection.add(psiType2);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    PsiType[] psiTypeArray3 = thisCollection$iv.toArray(new PsiType[0]);
                    if (psiTypeArray3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    PsiType[] classParameters = psiTypeArray3;
                    return (PsiType)this.$factory.createType(resolvedClass, Arrays.copyOf(classParameters, classParameters.length));
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public PsiType visitIntersectionType(@NotNull PsiIntersectionType intersectionType) {
                    void $this$mapNotNullTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)intersectionType, (String)"intersectionType");
                    Object[] objectArray = intersectionType.getConjuncts();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"intersectionType.conjuncts");
                    Iterable $this$mapNotNull$iv = ArraysKt.filterNotNull((Object[])objectArray);
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        PsiType psiType;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        PsiType it = (PsiType)element$iv$iv;
                        boolean bl2 = false;
                        if ((PsiType)it.accept((PsiTypeVisitor)this) == null) continue;
                        PsiType it$iv$iv = psiType;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    return InferenceProcessUtilKt.compress((List)destination$iv$iv);
                }

                @NotNull
                public PsiType visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                    PsiType psiType;
                    Intrinsics.checkNotNullParameter((Object)wildcardType, (String)"wildcardType");
                    PsiType psiType2 = wildcardType.getBound();
                    if (psiType2 == null || (psiType2 = (PsiType)psiType2.accept((PsiTypeVisitor)this)) == null) {
                        return (PsiType)wildcardType;
                    }
                    PsiType bound = psiType2;
                    if (wildcardType.isExtends()) {
                        PsiWildcardType psiWildcardType = PsiWildcardType.createExtends((PsiManager)this.$method.getManager(), (PsiType)bound);
                        Intrinsics.checkNotNullExpressionValue((Object)psiWildcardType, (String)"PsiWildcardType.createEx\u2026ds(method.manager, bound)");
                        psiType = (PsiType)psiWildcardType;
                    } else if (wildcardType.isSuper()) {
                        PsiWildcardType psiWildcardType = PsiWildcardType.createSuper((PsiManager)this.$method.getManager(), (PsiType)bound);
                        Intrinsics.checkNotNullExpressionValue((Object)psiWildcardType, (String)"PsiWildcardType.createSuper(method.manager, bound)");
                        psiType = (PsiType)psiWildcardType;
                    } else {
                        psiType = (PsiType)wildcardType;
                    }
                    return psiType;
                }

                public ForeignTypeParameterEraser(List $captured_local_variable$0, GrMethod $captured_local_variable$1, PsiWildcardType $captured_local_variable$2, GroovyPsiElementFactory $captured_local_variable$3) {
                    this.$allowedTypeParameters = $captured_local_variable$0;
                    this.$method = $captured_local_variable$1;
                    this.$unboundedWildcard = $captured_local_variable$2;
                    this.$factory = $captured_local_variable$3;
                }
            }
            PsiType psiType = (PsiType)type2.accept((PsiTypeVisitor)new ForeignTypeParameterEraser(allowedTypeParameters, method, unboundedWildcard, factory));
            if (psiType == null) {
                psiType = (PsiType)PsiType.NULL;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"type.accept(ForeignTypeP\u2026Eraser()) ?: PsiType.NULL");
            substitutions.add(psiType);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        Collection $this$toTypedArray$iv = typeParameters;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiTypeParameter[] psiTypeParameterArray = thisCollection$iv.toArray(new PsiTypeParameter[0]);
        if (psiTypeParameterArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        $this$toTypedArray$iv = substitutions;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[0]);
        if (psiTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return InferenceKt.putAll(psiSubstitutor, psiTypeParameterArray, psiTypeArray);
    }

    @Nullable
    public static final PsiType compress(@Nullable List<? extends PsiType> types) {
        if (types == null) {
            return null;
        }
        return types.isEmpty() ? (PsiType)PsiType.NULL : (types.size() == 1 ? (PsiType)CollectionsKt.single(types) : PsiIntersectionType.createIntersection(types));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiTypeParameter> allOuterTypeParameters(@NotNull PsiMethod method) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object[] objectArray = method.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"method.typeParameters");
        Iterable iterable = InferenceProcessUtilKt.getContainingClasses(method.getContainingClass());
        Collection collection = ArraysKt.asList((Object[])objectArray);
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiClass it = (PsiClass)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = it.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"it.typeParameters");
            Iterable list$iv$iv = ArraysKt.asList((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @NotNull
    public static final PsiSubstitutor createVirtualToActualSubstitutor(@NotNull GrMethod virtualMethod, @NotNull GrMethod originalMethod) {
        Intrinsics.checkNotNullParameter((Object)virtualMethod, (String)"virtualMethod");
        Intrinsics.checkNotNullParameter((Object)originalMethod, (String)"originalMethod");
        List<PsiTypeParameter> virtualTypeParameters = InferenceProcessUtilKt.allOuterTypeParameters(virtualMethod);
        List<PsiTypeParameter> originalTypeParameters = InferenceProcessUtilKt.allOuterTypeParameters(originalMethod);
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        PsiSubstitutor substitutor2 = psiSubstitutor;
        Iterable $this$forEach$iv = virtualTypeParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiTypeParameter originalParameter;
            Object v1;
            PsiTypeParameter virtualParameter;
            block3: {
                Iterable iterable;
                virtualParameter = (PsiTypeParameter)element$iv;
                boolean bl = false;
                Iterable iterable2 = iterable = (Iterable)originalTypeParameters;
                for (Object t : iterable2) {
                    PsiTypeParameter it = (PsiTypeParameter)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)virtualParameter.getName())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            if ((PsiTypeParameter)v1 == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)substitutor2.put(virtualParameter, (PsiType)InferenceKt.type((PsiClass)originalParameter)), (String)"substitutor.put(virtualP\u2026originalParameter.type())");
        }
        return substitutor2;
    }

    @NotNull
    public static final PsiType upperBound(@NotNull PsiTypeParameter $this$upperBound) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)$this$upperBound, (String)"$this$upperBound");
        switch ($this$upperBound.getExtendsListTypes().length) {
            case 0: {
                psiType = (PsiType)InferenceDriverUtilKt.getJavaLangObject((PsiElement)$this$upperBound);
                break;
            }
            case 1: {
                Object[] objectArray = $this$upperBound.getExtendsListTypes();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"extendsListTypes");
                Object object = ArraysKt.single((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extendsListTypes.single()");
                psiType = (PsiType)object;
                break;
            }
            default: {
                PsiType[] psiTypeArray = (PsiType[])$this$upperBound.getExtendsListTypes();
                PsiType psiType2 = PsiIntersectionType.createIntersection((PsiType[])Arrays.copyOf(psiTypeArray, psiTypeArray.length));
                psiType = psiType2;
                Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"PsiIntersectionType.crea\u2026ection(*extendsListTypes)");
            }
        }
        return psiType;
    }

    @Nullable
    public static final GroovyResolveResult properResolve(@NotNull PsiElement $this$properResolve) {
        GroovyResolveResult groovyResolveResult;
        Intrinsics.checkNotNullParameter((Object)$this$properResolve, (String)"$this$properResolve");
        PsiElement psiElement = $this$properResolve;
        if (psiElement instanceof GrAssignmentExpression) {
            GroovyReference groovyReference;
            GrExpression grExpression = ((GrAssignmentExpression)$this$properResolve).getLValue();
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            groovyResolveResult = (groovyReference = (GrReferenceExpression)grExpression) != null && (groovyReference = groovyReference.getLValueReference()) != null ? groovyReference.advancedResolve() : null;
        } else if (psiElement instanceof GrConstructorInvocation) {
            groovyResolveResult = ((GrConstructorInvocation)$this$properResolve).advancedResolve();
        } else {
            PsiElement psiElement2 = $this$properResolve;
            if (!(psiElement2 instanceof GrCall)) {
                psiElement2 = null;
            }
            GrCall grCall = (GrCall)psiElement2;
            groovyResolveResult = grCall != null ? grCall.advancedResolve() : null;
        }
        return groovyResolveResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final GrMethod locateMethod(GroovyFileBase file, GrMethod method) {
        PsiMethod psiMethod;
        PsiMethod psiMethod2;
        block12: {
            PsiMethod[] psiMethodArray;
            PsiClass psiClass;
            List outerClasses;
            block10: {
                void $this$parentsOfType$iv;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    GrMethod grMethod;
                    block9: {
                        GrMethod[] grMethodArray;
                        GrMethod[] grMethodArray2 = file.getMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)grMethodArray2, (String)"file.methods");
                        GrMethod[] grMethodArray3 = grMethodArray = grMethodArray2;
                        int n = grMethodArray3.length;
                        for (int i = 0; i < n; ++i) {
                            GrMethod grMethod2;
                            GrMethod it = grMethod2 = grMethodArray3[i];
                            boolean bl = false;
                            GrMethod grMethod3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)grMethod3, (String)"it");
                            if (!InferenceProcessUtilKt.methodsAgree(grMethod3, method)) continue;
                            grMethod = grMethod2;
                            break block9;
                        }
                        grMethod = null;
                    }
                    return grMethod;
                }
                PsiElement psiElement = (PsiElement)containingClass;
                boolean withSelf$iv = true;
                boolean $i$f$parentsOfType = false;
                outerClasses = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, PsiClass.class, (boolean)withSelf$iv)));
                PsiClass[] psiClassArray = file.getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"file.classes");
                for (PsiClass psiClass2 : withSelf$iv = psiClassArray) {
                    PsiClass it = psiClass2;
                    boolean bl = false;
                    PsiClass psiClass3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiClass3, (String)"it");
                    if (!Intrinsics.areEqual((Object)psiClass3.getName(), (Object)((PsiClass)CollectionsKt.first((List)outerClasses)).getName())) continue;
                    psiClass = psiClass2;
                    break block10;
                }
                psiClass = null;
            }
            if (psiClass == null) {
                return null;
            }
            Object initialClass = psiClass;
            Iterable $this$fold$iv = CollectionsKt.drop((Iterable)outerClasses, (int)1);
            boolean $i$f$fold = false;
            Object accumulator$iv = initialClass;
            for (Object element$iv : $this$fold$iv) {
                PsiClass psiClass4;
                block11: {
                    PsiClass[] psiClassArray;
                    PsiClass bl = (PsiClass)element$iv;
                    Object currentOriginalClass = accumulator$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)currentOriginalClass.getInnerClasses(), (String)"currentOriginalClass.innerClasses");
                    PsiClass[] psiClassArray2 = psiClassArray;
                    int n = psiClassArray2.length;
                    for (int i = 0; i < n; ++i) {
                        void psiClass5;
                        PsiClass psiClass6;
                        PsiClass it = psiClass6 = psiClassArray2[i];
                        boolean bl3 = false;
                        PsiClass psiClass7 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiClass7, (String)"it");
                        if (!Intrinsics.areEqual((Object)psiClass7.getName(), (Object)psiClass5.getName())) continue;
                        psiClass4 = psiClass6;
                        break block11;
                    }
                    psiClass4 = null;
                }
                if (psiClass4 == null) {
                    return null;
                }
                accumulator$iv = psiClass4;
            }
            Object innermostClass = accumulator$iv;
            PsiMethod[] psiMethodArray2 = innermostClass.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray2, (String)"innermostClass.methods");
            PsiMethod[] psiMethodArray3 = psiMethodArray = psiMethodArray2;
            int n = psiMethodArray3.length;
            for (int i = 0; i < n; ++i) {
                PsiMethod psiMethod3;
                PsiMethod it = psiMethod3 = psiMethodArray3[i];
                boolean bl = false;
                PsiMethod psiMethod4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiMethod4, (String)"it");
                if (!Intrinsics.areEqual((Object)psiMethod4.getName(), (Object)method.getName())) continue;
                psiMethod2 = psiMethod3;
                break block12;
            }
            psiMethod2 = psiMethod = null;
        }
        if (!(psiMethod2 instanceof GrMethod)) {
            psiMethod = null;
        }
        return (GrMethod)psiMethod;
    }

    @NotNull
    public static final GrMethod getOriginalMethod(@NotNull GrMethod method) {
        GrMethod grMethod;
        block6: {
            block9: {
                GrMethod grMethod2;
                PsiFile originalFile;
                block8: {
                    block7: {
                        block5: {
                            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                            PsiFile psiFile = method.getContainingFile();
                            Object object = originalFile = psiFile != null ? psiFile.getOriginalFile() : null;
                            if (originalFile != null) break block5;
                            grMethod = method;
                            break block6;
                        }
                        if (!Intrinsics.areEqual((Object)originalFile, (Object)method.getContainingFile())) break block7;
                        grMethod = method;
                        break block6;
                    }
                    if (!(originalFile instanceof GroovyFileBase)) break block8;
                    grMethod = InferenceProcessUtilKt.locateMethod((GroovyFileBase)originalFile, method);
                    if (grMethod == null) {
                        grMethod = method;
                    }
                    break block6;
                }
                grMethod = originalFile.findElementAt(method.getTextOffset());
                if (grMethod == null) break block9;
                GrMethod $this$parentOfType$iv = grMethod;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                grMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, GrMethod.class, (boolean)true);
                if (grMethod == null) break block9;
                GrMethod it = grMethod2 = grMethod;
                boolean bl = false;
                grMethod = Intrinsics.areEqual((Object)it.getName(), (Object)method.getName()) ? grMethod2 : null;
                if (grMethod != null) break block6;
            }
            grMethod = method;
        }
        return grMethod;
    }

    private static final SearchScope getFileScope(GrMethod method) {
        LocalSearchScope localSearchScope;
        GrMethod originalMethod = InferenceProcessUtilKt.getOriginalMethod(method);
        PsiFile psiFile = originalMethod.getContainingFile();
        if (psiFile != null) {
            PsiFile psiFile2;
            PsiFile it = psiFile2 = psiFile;
            boolean bl = false;
            localSearchScope = new LocalSearchScope((PsiElement[])new PsiFile[]{it}, null, true);
        } else {
            localSearchScope = null;
        }
        return (SearchScope)localSearchScope;
    }

    @Nullable
    public static final SearchScope getSearchScope(@NotNull GrMethod method, boolean shouldUseReducedScope) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return shouldUseReducedScope ? InferenceProcessUtilKt.getFileScope(method) : (SearchScope)GlobalSearchScope.allScope((Project)method.getProject());
    }
}

