/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.api.statements;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GrNamedArgumentSearchVisitor
extends GroovyRecursiveElementVisitor {
    public static final NamedArgumentDescriptor CODE_NAMED_ARGUMENTS_DESCR = NamedArgumentDescriptor.SIMPLE_AS_LOCAL_VAR;
    private static final List<String> METHOD_NAMES = Arrays.asList("containsKey", "remove", "get");
    private final Map<String, NamedArgumentDescriptor> myResult = new HashMap<String, NamedArgumentDescriptor>();
    private final String myFirstArgumentName;

    public GrNamedArgumentSearchVisitor(String firstArgumentName) {
        this.myFirstArgumentName = firstArgumentName;
    }

    public Map<String, NamedArgumentDescriptor> getResult() {
        return this.myResult;
    }

    private void extractArguments(@NotNull GrArgumentList argumentList) {
        String s;
        Object value;
        GrExpression[] expr;
        if (argumentList == null) {
            GrNamedArgumentSearchVisitor.$$$reportNull$$$0(0);
        }
        if ((expr = argumentList.getExpressionArguments()).length == 1 && expr[0] instanceof GrLiteral && (value = ((GrLiteral)expr[0]).getValue()) instanceof String && StringUtil.isJavaIdentifier((String)(s = (String)value))) {
            this.add((String)value);
        }
    }

    private void add(String refName) {
        this.myResult.put(refName, CODE_NAMED_ARGUMENTS_DESCR);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            GrNamedArgumentSearchVisitor.$$$reportNull$$$0(1);
        }
        if (this.myFirstArgumentName.equals(referenceExpression.getReferenceName()) && !referenceExpression.isQualified()) {
            PsiElement parent2 = referenceExpression.getParent();
            if (parent2 instanceof GrReferenceExpression) {
                GrReferenceExpression parentRef = (GrReferenceExpression)parent2;
                PsiElement parentParent = parentRef.getParent();
                if (parentParent instanceof GrMethodCallExpression) {
                    if (METHOD_NAMES.contains(parentRef.getReferenceName())) {
                        this.extractArguments(((GrMethodCallExpression)parentParent).getArgumentList());
                    }
                } else {
                    this.add(parentRef.getReferenceName());
                }
            } else if (parent2 instanceof GrIndexProperty) {
                GrIndexProperty indexProperty = (GrIndexProperty)parent2;
                this.extractArguments(indexProperty.getArgumentList());
            }
        }
        super.visitReferenceExpression(referenceExpression);
    }

    public static Map<String, NamedArgumentDescriptor> find(GrVariable variable) {
        GrExpression initializerGroovy = variable.getInitializerGroovy();
        if (!(initializerGroovy instanceof GrFunctionalExpression)) {
            return Collections.emptyMap();
        }
        GrFunctionalExpression expression = (GrFunctionalExpression)initializerGroovy;
        GrParameter[] parameters2 = expression.getAllParameters();
        if (parameters2.length == 0) {
            return Collections.emptyMap();
        }
        GrParameter parameter = parameters2[0];
        GrNamedArgumentSearchVisitor visitor2 = new GrNamedArgumentSearchVisitor(parameter.getName());
        expression.accept(visitor2);
        return visitor2.getResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/api/statements/GrNamedArgumentSearchVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractArguments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

