/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.ast;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiQualifiedReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.GrVisibilityUtils$WhenMappings;
import org.jetbrains.plugins.groovy.lang.resolve.ast.Visibility;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"extractVisibility", "Lorg/jetbrains/plugins/groovy/lang/resolve/ast/Visibility;", "element", "Lcom/intellij/psi/PsiModifierListOwner;", "getVisibility", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "sourceElement", "Lcom/intellij/psi/PsiElement;", "defaultVisibility", "inferGroovyVisibility", "Lgroovy/transform/options/Visibility;", "attributeName", "", "intellij.groovy.psi"})
@JvmName(name="GrVisibilityUtils")
public final class GrVisibilityUtils {
    @NotNull
    public static final Visibility extractVisibility(@NotNull PsiModifierListOwner element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiModifierList psiModifierList = element.getModifierList();
        if (!(psiModifierList instanceof GrModifierList)) {
            psiModifierList = null;
        }
        GrModifierList grModifierList = (GrModifierList)psiModifierList;
        if (grModifierList == null) {
            return Visibility.PUBLIC;
        }
        GrModifierList modifierList = grModifierList;
        return GrModifierListUtil.hasModifierProperty(modifierList, "public", false) ? Visibility.PUBLIC : (GrModifierListUtil.hasModifierProperty(modifierList, "private", false) ? Visibility.PRIVATE : (GrModifierListUtil.hasModifierProperty(modifierList, "protected", false) ? Visibility.PROTECTED : Visibility.PACKAGE_PRIVATE));
    }

    @NotNull
    public static final Visibility getVisibility(@NotNull PsiAnnotation annotation, @NotNull PsiElement sourceElement, @NotNull Visibility defaultVisibility) {
        Visibility visibility;
        Object object;
        block17: {
            groovy.transform.options.Visibility it;
            PsiAnnotation targetAnnotation;
            block16: {
                groovy.transform.options.Visibility visibility2;
                Object v1;
                block15: {
                    Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                    Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
                    Intrinsics.checkNotNullParameter((Object)((Object)defaultVisibility), (String)"defaultVisibility");
                    List<PsiAnnotation> list = PsiUtil.getAllAnnotations(sourceElement.getNavigationElement(), "groovy.transform.VisibilityOptions");
                    Intrinsics.checkNotNullExpressionValue(list, (String)"PsiUtil.getAllAnnotation\u2026SFORM_VISIBILITY_OPTIONS)");
                    List<PsiAnnotation> visAnnotations = list;
                    String visAnnotationId = GrAnnotationUtil.inferStringAttribute(annotation, "visibilityId");
                    Iterable $this$firstOrNull$iv = visAnnotations;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiAnnotation it2 = (PsiAnnotation)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)GrAnnotationUtil.inferStringAttribute(it2, "id"), (Object)visAnnotationId)) continue;
                        v1 = element$iv;
                        break block15;
                    }
                    v1 = null;
                }
                targetAnnotation = v1;
                if (targetAnnotation == null) {
                    return defaultVisibility;
                }
                if ((sourceElement instanceof PsiMethod && ((PsiMethod)sourceElement).isConstructor() ? GrVisibilityUtils.inferGroovyVisibility(targetAnnotation, "constructor") : (sourceElement instanceof PsiMethod ? GrVisibilityUtils.inferGroovyVisibility(targetAnnotation, "method") : (object = sourceElement instanceof PsiClass ? GrVisibilityUtils.inferGroovyVisibility(targetAnnotation, "type") : null))) == null) break block16;
                it = visibility2 = object;
                boolean bl = false;
                object = !(it == groovy.transform.options.Visibility.UNDEFINED) ? visibility2 : null;
                if (object != null) break block17;
            }
            groovy.transform.options.Visibility visibility3 = GrVisibilityUtils.inferGroovyVisibility(targetAnnotation, "value");
            if (visibility3 != null) {
                groovy.transform.options.Visibility visibility4;
                it = visibility4 = visibility3;
                boolean bl = false;
                object = !(it == groovy.transform.options.Visibility.UNDEFINED) ? visibility4 : null;
            } else {
                object = null;
            }
        }
        if (object == null) {
            return defaultVisibility;
        }
        groovy.transform.options.Visibility visibility5 = object;
        switch (GrVisibilityUtils$WhenMappings.$EnumSwitchMapping$0[visibility5.ordinal()]) {
            case 1: {
                visibility = defaultVisibility;
                break;
            }
            case 2: {
                visibility = Visibility.PUBLIC;
                break;
            }
            case 3: {
                visibility = Visibility.PROTECTED;
                break;
            }
            case 4: {
                visibility = Visibility.PACKAGE_PRIVATE;
                break;
            }
            case 5: {
                visibility = Visibility.PRIVATE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return visibility;
    }

    private static final groovy.transform.options.Visibility inferGroovyVisibility(PsiAnnotation annotation, String attributeName) {
        String string;
        block7: {
            block4: {
                String string2;
                PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
                if (!(targetValue instanceof PsiQualifiedReference)) break block4;
                try {
                    String string3;
                    block6: {
                        block5: {
                            string3 = ((PsiQualifiedReference)targetValue).getReferenceName();
                            if (string3 == null) break block5;
                            String p1 = string2 = string3;
                            boolean bl = false;
                            string3 = groovy.transform.options.Visibility.valueOf((String)p1);
                            if (string3 != null) break block6;
                        }
                        return null;
                    }
                    string2 = string3;
                }
                catch (IllegalArgumentException e) {
                    string2 = null;
                }
                string = string2;
                break block7;
            }
            string = null;
        }
        return string;
    }
}

