/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToStatic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.VisitorCallback;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.ConvertToStatic;
import org.jetbrains.plugins.groovy.refactoring.convertToStatic.DynamicFeaturesVisitor;

public class ConvertToStaticProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ConvertToStaticProcessor.class);
    private final GroovyFile[] myFiles;

    public ConvertToStaticProcessor(Project project, GroovyFile ... files) {
        super(project);
        this.myFiles = files;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(0);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                if (ConvertToStaticProcessor.this.myFiles == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ConvertToStaticProcessor.this.myFiles;
            }

            public String getProcessedElementsHeader() {
                return GroovyRefactoringBundle.message("files.to.be.converted", new Object[0]);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor$1", "getElements"));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (UsageInfo.EMPTY_ARRAY == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(1);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(2);
        }
        int counter = 0;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        LOG.assertTrue(progressIndicator != null);
        progressIndicator.setIndeterminate(false);
        for (GroovyFile file : this.myFiles) {
            this.commitFile(file);
            progressIndicator.setText2(file.getName());
            progressIndicator.setFraction((double)(++counter) / (double)this.myFiles.length);
            try {
                ConvertToStatic.applyDeclarationFixes(file);
                this.putCompileAnnotations(file);
                ConvertToStatic.applyErrorFixes(file);
                this.commitFile(file);
            }
            catch (Exception e) {
                LOG.error("Error in converting file: " + file.getName(), (Throwable)e);
            }
        }
    }

    private void commitFile(@NotNull GroovyFile file) {
        if (file == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(3);
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)file);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        LOG.assertTrue(document != null);
        psiDocumentManager.commitDocument(document);
        LOG.assertTrue(file.isValid());
    }

    private void putCompileAnnotations(@NotNull GroovyFile file) {
        if (file == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(4);
        }
        final HashSet classesWithUnresolvedRef = new HashSet();
        final HashSet methodsWithUnresolvedRef = new HashSet();
        VisitorCallback callback = (element, info) -> {
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
            if (containingMethod != null) {
                methodsWithUnresolvedRef.add(containingMethod);
                return;
            }
            GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, GrTypeDefinition.class);
            if (containingClass != null) {
                classesWithUnresolvedRef.add(containingClass);
            }
        };
        file.accept(new DynamicFeaturesVisitor(file, this.myProject, callback));
        file.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDef) {
                if (typeDef == null) {
                    2.$$$reportNull$$$0(0);
                }
                ConvertToStaticProcessor.this.processDefinitions(typeDef, classesWithUnresolvedRef);
                super.visitTypeDefinition(typeDef);
            }

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(1);
                }
                ConvertToStaticProcessor.this.processMethods(method, methodsWithUnresolvedRef);
                super.visitMethod(method);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeDef";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeDefinition";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void processMethods(@NotNull GrMethod method, Set<GrMethod> dynamicMethods) {
        PsiClass containingClass;
        if (method == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(5);
        }
        boolean isOuterStatic = (containingClass = method.getContainingClass()) != null && CompileStaticUtil.isCompileStatic((PsiElement)containingClass);
        boolean isStatic = dynamicMethods.stream().noneMatch(arg_0 -> ((GrMethod)method).isEquivalentTo(arg_0));
        if (isOuterStatic != isStatic) {
            this.addAnnotation(method, isStatic);
        }
    }

    private void processDefinitions(GrTypeDefinition typeDef, Set<GrTypeDefinition> dynamicClasses) {
        boolean isStatic;
        PsiClass containingClass = typeDef.getContainingClass();
        boolean isOuterStatic = containingClass != null && CompileStaticUtil.isCompileStatic((PsiElement)containingClass);
        boolean bl = isStatic = !dynamicClasses.contains(typeDef);
        if (isOuterStatic && !isStatic) {
            this.addAnnotation(typeDef, false);
        }
        if (!isOuterStatic && isStatic) {
            this.addAnnotation(typeDef, true);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = GroovyRefactoringBundle.message("converting.files.to.static", new Object[0]);
        if (string == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    void addAnnotation(@NotNull PsiMember owner, boolean isStatic) {
        PsiModifierList modifierList;
        if (owner == null) {
            ConvertToStaticProcessor.$$$reportNull$$$0(7);
        }
        if ((modifierList = owner.getModifierList()) != null && CompileStaticUtil.getCompileStaticAnnotation(owner) == null) {
            String annotation = isStatic ? "groovy.transform.CompileStatic" : "groovy.transform.CompileDynamic";
            modifierList.addAnnotation(annotation);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToStatic/ConvertToStaticProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "commitFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putCompileAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processMethods";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

