/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.method;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractInfoHelperBase;
import org.jetbrains.plugins.groovy.refactoring.extract.InitialInfo;

public class ExtractMethodInfoHelper
extends ExtractInfoHelperBase {
    private final boolean myIsStatic;
    private boolean mySpecifyType = true;
    private String myVisibility;
    private String myName;
    private final PsiClass myOwner;
    private boolean myForceReturn;

    public ExtractMethodInfoHelper(InitialInfo initialInfo, String name, PsiClass owner, boolean forceReturn) {
        super(initialInfo);
        this.myOwner = owner;
        this.myForceReturn = forceReturn;
        this.myVisibility = "private";
        this.myName = name;
        this.myIsStatic = ExtractMethodInfoHelper.canBeStatic(initialInfo.getContext());
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    public String getVisibility() {
        return this.myVisibility;
    }

    public void setVisibility(String visibility) {
        this.myVisibility = visibility;
    }

    public boolean specifyType() {
        return this.mySpecifyType;
    }

    public void setSpecifyType(boolean specifyType) {
        this.mySpecifyType = specifyType;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @NotNull
    public PsiClass getOwner() {
        PsiClass psiClass = this.myOwner;
        if (psiClass == null) {
            ExtractMethodInfoHelper.$$$reportNull$$$0(0);
        }
        return psiClass;
    }

    public void setForceReturn(boolean isForceReturn) {
        this.myForceReturn = isForceReturn;
    }

    private static boolean canBeStatic(PsiElement statement) {
        for (PsiElement parent2 = statement.getParent(); parent2 != null && !(parent2 instanceof PsiFile); parent2 = parent2.getParent()) {
            if (!(parent2 instanceof GrMember)) continue;
            return ((GrMember)parent2).hasModifierProperty("static");
        }
        return false;
    }

    @Override
    public boolean isForceReturn() {
        return this.myForceReturn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/extract/method/ExtractMethodInfoHelper", "getOwner"));
    }
}

