/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.shellcheck;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShFileType;
import com.intellij.sh.settings.ShSettings;
import com.intellij.sh.shellcheck.ShShellcheckUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShellcheckSetupNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"sh.shellcheck.installation");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            ShellcheckSetupNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file == null) {
            ShellcheckSetupNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            ShellcheckSetupNotificationProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ShellcheckSetupNotificationProvider.$$$reportNull$$$0(3);
        }
        if (file.getFileType() instanceof ShFileType && !ShShellcheckUtil.isValidPath(ShSettings.getShellcheckPath())) {
            EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor);
            panel.setText(ShBundle.message("sh.shellcheck.install.question", new Object[0]));
            Runnable onSuccess = () -> {
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
                }
                Notifications.Bus.notify((Notification)new Notification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shellcheck.success.install", new Object[0]), NotificationType.INFORMATION));
            };
            Runnable onFailure = () -> Notifications.Bus.notify((Notification)new Notification(ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.shellcheck.cannot.download", new Object[0]), NotificationType.ERROR));
            panel.createActionLabel(ShBundle.message("sh.install", new Object[0]), () -> ShShellcheckUtil.download(null, onSuccess, onFailure));
            panel.createActionLabel(ShBundle.message("sh.no.thanks", new Object[0]), () -> {
                ShSettings.setShellcheckPath(ShSettings.I_DO_MIND_SUPPLIER.get());
                EditorNotifications.getInstance((Project)project).updateAllNotifications();
            });
            return panel;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/shellcheck/ShellcheckSetupNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/shellcheck/ShellcheckSetupNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

