/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.spellchecker;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class ShIdentifierOwnerTokenizer
extends Tokenizer<PsiNameIdentifierOwner> {
    public static final ShIdentifierOwnerTokenizer INSTANCE = new ShIdentifierOwnerTokenizer();

    public void tokenize(@NotNull PsiNameIdentifierOwner element, TokenConsumer consumer) {
        PsiElement identifier;
        if (element == null) {
            ShIdentifierOwnerTokenizer.$$$reportNull$$$0(0);
        }
        if ((identifier = element.getNameIdentifier()) == null) {
            return;
        }
        PsiNameIdentifierOwner parent = element;
        TextRange range = identifier.getTextRange();
        if (range.isEmpty()) {
            return;
        }
        int offset = range.getStartOffset() - parent.getTextRange().getStartOffset();
        if (offset < 0) {
            parent = PsiTreeUtil.findCommonParent((PsiElement)identifier, (PsiElement)element);
            offset = range.getStartOffset() - parent.getTextRange().getStartOffset();
        }
        String text = identifier.getText();
        consumer.consumeToken((PsiElement)parent, text, true, offset, TextRange.allOf((String)text), (Splitter)PlainTextSplitter.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sh/spellchecker/ShIdentifierOwnerTokenizer", "tokenize"));
    }
}

